/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiblioscapeImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "Biblioscape";
    }

    @Override
    public String getCLIId() {
        return "biblioscape";
    }

    @Override
    public boolean isRecognizedFormat(InputStream in) throws IOException {
        return true;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream, OutputPrinter status) throws IOException {
        String line;
        ArrayList<BibtexEntry> bibItems = new ArrayList<BibtexEntry>();
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        HashMap<String, String> hm = new HashMap<String, String>();
        HashMap<String, StringBuffer> lines = new HashMap<String, StringBuffer>();
        StringBuffer previousLine = null;
        while ((line = in.readLine()) != null) {
            if (line.length() == 0) continue;
            if (line.equals("------")) {
                String[] type = new String[2];
                String[] pages = new String[2];
                String country = null;
                String address = null;
                String titleST = null;
                String titleTI = null;
                Vector<String> comments = new Vector<String>();
                for (Map.Entry entry : lines.entrySet()) {
                    if (((String)entry.getKey()).equals("AU")) {
                        hm.put("author", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("TI")) {
                        titleTI = ((StringBuffer)entry.getValue()).toString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("ST")) {
                        titleST = ((StringBuffer)entry.getValue()).toString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("YP")) {
                        hm.put("year", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("VL")) {
                        hm.put("volume", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("NB")) {
                        hm.put("number", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("PS")) {
                        pages[0] = ((StringBuffer)entry.getValue()).toString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("PE")) {
                        pages[1] = ((StringBuffer)entry.getValue()).toString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("KW")) {
                        hm.put("keywords", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("RT")) {
                        type[0] = ((StringBuffer)entry.getValue()).toString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("SB")) {
                        comments.add("Subject: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("SA")) {
                        comments.add("Secondary Authors: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("NT")) {
                        hm.put("note", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("PB")) {
                        hm.put("publisher", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("TA")) {
                        comments.add("Tertiary Authors: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("TT")) {
                        comments.add("Tertiary Title: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("ED")) {
                        hm.put("edition", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("TW")) {
                        type[1] = ((StringBuffer)entry.getValue()).toString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("QA")) {
                        comments.add("Quaternary Authors: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("QT")) {
                        comments.add("Quaternary Title: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("IS")) {
                        hm.put("isbn", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("AB")) {
                        hm.put("abstract", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("AD")) {
                        address = ((StringBuffer)entry.getValue()).toString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("LG")) {
                        hm.put("language", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("CO")) {
                        country = ((StringBuffer)entry.getValue()).toString();
                        continue;
                    }
                    if (((String)entry.getKey()).equals("UR") || ((String)entry.getKey()).equals("AT")) {
                        String s = ((StringBuffer)entry.getValue()).toString().trim();
                        hm.put(s.startsWith("http://") || s.startsWith("ftp://") ? "url" : "pdf", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("C1")) {
                        comments.add("Custom1: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("C2")) {
                        comments.add("Custom2: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("C3")) {
                        comments.add("Custom3: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("C4")) {
                        comments.add("Custom4: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("C5")) {
                        comments.add("Custom5: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("C6")) {
                        comments.add("Custom6: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("DE")) {
                        hm.put("annote", ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("CA")) {
                        comments.add("Categories: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (((String)entry.getKey()).equals("TH")) {
                        comments.add("Short Title: " + ((StringBuffer)entry.getValue()).toString());
                        continue;
                    }
                    if (!((String)entry.getKey()).equals("SE")) continue;
                    hm.put("chapter", ((StringBuffer)entry.getValue()).toString());
                }
                String bibtexType = "misc";
                for (int i = 1; i >= 0 && bibtexType.equals("misc"); --i) {
                    if (type[i] == null) continue;
                    type[i] = type[i].toLowerCase();
                    if (type[i].indexOf("article") >= 0) {
                        bibtexType = "article";
                        continue;
                    }
                    if (type[i].indexOf("journal") >= 0) {
                        bibtexType = "article";
                        continue;
                    }
                    if (type[i].indexOf("book section") >= 0) {
                        bibtexType = "inbook";
                        continue;
                    }
                    if (type[i].indexOf("book") >= 0) {
                        bibtexType = "book";
                        continue;
                    }
                    if (type[i].indexOf("conference") >= 0) {
                        bibtexType = "inproceedings";
                        continue;
                    }
                    if (type[i].indexOf("proceedings") >= 0) {
                        bibtexType = "inproceedings";
                        continue;
                    }
                    if (type[i].indexOf("report") >= 0) {
                        bibtexType = "techreport";
                        continue;
                    }
                    if (type[i].indexOf("thesis") >= 0 && type[i].indexOf("master") >= 0) {
                        bibtexType = "mastersthesis";
                        continue;
                    }
                    if (type[i].indexOf("thesis") < 0) continue;
                    bibtexType = "phdthesis";
                }
                if (bibtexType.equals("article")) {
                    if (titleST != null) {
                        hm.put("journal", titleST);
                    }
                    if (titleTI != null) {
                        hm.put("title", titleTI);
                    }
                } else if (bibtexType.equals("inbook")) {
                    if (titleST != null) {
                        hm.put("booktitle", titleST);
                    }
                    if (titleTI != null) {
                        hm.put("title", titleTI);
                    }
                } else {
                    if (titleST != null) {
                        hm.put("booktitle", titleST);
                    }
                    if (titleTI != null) {
                        hm.put("title", titleTI);
                    }
                }
                if (pages[0] != null || pages[1] != null) {
                    hm.put("pages", (pages[0] != null ? pages[0] : "") + (pages[1] != null ? "--" + pages[1] : ""));
                }
                if (address != null) {
                    hm.put("address", address + (country != null ? ", " + country : ""));
                }
                if (comments.size() > 0) {
                    StringBuffer s = new StringBuffer();
                    for (int i = 0; i < comments.size(); ++i) {
                        s.append(i > 0 ? "; " : "").append(((String)comments.elementAt(i)).toString());
                    }
                    hm.put("comment", s.toString());
                }
                BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(bibtexType));
                b.setField(hm);
                bibItems.add(b);
                hm.clear();
                lines.clear();
                previousLine = null;
                continue;
            }
            if (line.startsWith("--") && line.length() >= 7 && line.substring(4, 7).equals("-- ")) {
                previousLine = new StringBuffer(line.substring(7));
                lines.put(line.substring(2, 4), previousLine);
                continue;
            }
            if (previousLine == null) {
                return null;
            }
            previousLine.append(line.trim());
        }
        return bibItems;
    }
}

