/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.GridLayout;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.HTMLConverter;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;

public class ACMPortalFetcher
implements EntryFetcher {
    private ImportInspector dialog = null;
    private OutputPrinter status;
    private final HTMLConverter htmlConverter = new HTMLConverter();
    private String terms;
    private static final String startUrl = "http://portal.acm.org/";
    private static final String searchUrlPart = "results.cfm?query=";
    private static final String searchUrlPartII = "&dl=";
    private static final String endUrl = "&coll=Portal&short=0";
    private static final String bibtexUrl = "exportformats.cfm?id=";
    private static final String bibtexUrlEnd = "&expformat=bibtex";
    private static final String abstractUrl = "tab_abstract.cfm?id=";
    private final JRadioButton acmButton = new JRadioButton(Globals.lang("The ACM Digital Library"));
    private final JRadioButton guideButton = new JRadioButton(Globals.lang("The Guide to Computing Literature"));
    private final JCheckBox absCheckBox = new JCheckBox(Globals.lang("Include abstracts"), false);
    private static final int perPage = 20;
    private static final int MAX_FETCH = 20;
    private static final int WAIT_TIME = 1000;
    private int hits = 0;
    private int unparseable = 0;
    private int parsed = 0;
    private boolean shouldContinue = false;
    private boolean fetchAbstract = false;
    private boolean acmOrGuide = false;
    private static final Pattern hitsPattern = Pattern.compile(".*Found <b>(\\d+,*\\d*)</b>.*");
    private static final Pattern maxHitsPattern = Pattern.compile(".*Results \\d+ - \\d+ of (\\d+,*\\d*).*");
    private static final Pattern bibPattern = Pattern.compile(".*'(exportformats.cfm\\?id=\\d+&expformat=bibtex)'.*");
    private static final Pattern fullCitationPattern = Pattern.compile("<A HREF=\"(citation.cfm.*)\" class.*");
    private static final Pattern idPattern = Pattern.compile("citation.cfm\\?id=\\d*\\.?(\\d+)&.*");
    private int piv = 0;

    public JPanel getOptionsPanel() {
        JPanel pan = new JPanel();
        pan.setLayout(new GridLayout(0, 1));
        this.guideButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.acmButton);
        group.add(this.guideButton);
        pan.add(this.absCheckBox);
        pan.add(this.acmButton);
        pan.add(this.guideButton);
        return pan;
    }

    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        this.dialog = dialog;
        this.status = status;
        this.terms = query;
        this.piv = 0;
        this.shouldContinue = true;
        this.parsed = 0;
        this.unparseable = 0;
        this.acmOrGuide = this.acmButton.isSelected();
        this.fetchAbstract = this.absCheckBox.isSelected();
        int firstEntry = 1;
        String address = this.makeUrl(firstEntry);
        try {
            URL url = new URL(address);
            String page = this.getResults(url);
            this.hits = this.getNumberOfHits(page, "Found", hitsPattern);
            int index = page.indexOf("Found");
            if (index >= 0 && (index = (page = page.substring(index + 5)).indexOf("Found")) >= 0) {
                page = page.substring(index);
            }
            if (this.hits == 0) {
                status.showMessage(Globals.lang("No entries found for the search string '%0'", this.terms), Globals.lang("Search ACM Portal"), 1);
                return false;
            }
            int maxHits = this.getNumberOfHits(page, "Results", maxHitsPattern);
            if (this.hits > maxHits) {
                this.hits = maxHits;
            }
            if (this.hits > 20) {
                status.showMessage(Globals.lang("%0 entries found. To reduce server load, only %1 will be downloaded. It will be very slow, in order to make ACM happy.", new String[]{String.valueOf(this.hits), String.valueOf(20)}), Globals.lang("Search ACM Portal"), 1);
                this.hits = 20;
            }
            this.parse(dialog, page, 0, firstEntry);
            firstEntry += 20;
            while (this.shouldContinue && firstEntry <= this.hits) {
                address = this.makeUrl(firstEntry);
                page = this.getResults(new URL(address));
                this.parse(dialog, page, 0, firstEntry);
                firstEntry += 20;
            }
            return true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ConnectException e) {
            status.showMessage(Globals.lang("Connection to ACM Portal failed"), Globals.lang("Search ACM Portal"), 0);
        }
        catch (IOException e) {
            status.showMessage(Globals.lang(e.getMessage()), Globals.lang("Search ACM Portal"), 0);
            e.printStackTrace();
        }
        return false;
    }

    private String makeUrl(int startIndex) {
        StringBuffer sb = new StringBuffer(startUrl).append(searchUrlPart);
        sb.append(this.terms.replaceAll(" ", "%20"));
        sb.append("&start=" + String.valueOf(startIndex));
        sb.append(searchUrlPartII);
        if (this.acmOrGuide) {
            sb.append("ACM");
        } else {
            sb.append("GUIDE");
        }
        sb.append(endUrl);
        return sb.toString();
    }

    private void parse(ImportInspector dialog, String text, int startIndex, int firstEntryNumber) {
        BibtexEntry entry;
        this.piv = startIndex;
        int entryNumber = firstEntryNumber;
        while ((entry = this.parseNextEntry(text, this.piv, entryNumber)) != null && this.shouldContinue) {
            if (entry.getField("title") != null) {
                dialog.addEntry(entry);
                dialog.setProgress(this.parsed + this.unparseable, this.hits);
                ++this.parsed;
            }
            ++entryNumber;
        }
    }

    private BibtexEntry parseEntryBibTeX(String fullCitation, boolean abs) throws IOException {
        String bibAddr = "";
        String ID = "";
        try {
            Matcher idMatcher = idPattern.matcher(fullCitation);
            if (!idMatcher.find()) {
                System.out.println("Did not find ID in: " + fullCitation);
                return null;
            }
            ID = idMatcher.group(1);
            bibAddr = bibtexUrl + ID + bibtexUrlEnd;
            URL bibtexUrl = new URL(startUrl + bibAddr);
            BufferedReader in = new BufferedReader(new InputStreamReader(bibtexUrl.openStream()));
            ParserResult result = BibtexParser.parse(in);
            in.close();
            Collection<BibtexEntry> item = result.getDatabase().getEntries();
            if (item.size() == 0) {
                return null;
            }
            BibtexEntry entry = item.iterator().next();
            Thread.sleep(1000L);
            if (abs) {
                URL url = new URL("http://portal.acm.org/tab_abstract.cfm?id=" + ID);
                String page = this.getResults(url);
                entry.setField("abstract", this.convertHTMLChars(page).trim());
                Thread.sleep(1000L);
            }
            return entry;
        }
        catch (NoSuchElementException e) {
            System.out.println("Bad Bibtex record read at: http://portal.acm.org/" + bibAddr);
            System.out.println("link read was: " + fullCitation);
            e.printStackTrace();
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (ConnectException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private BibtexEntry parseNextEntry(String allText, int startIndex, int entryNumber) {
        String toFind = new StringBuffer().append("<strong>").append(entryNumber).append("</strong><br>").toString();
        int index = allText.indexOf(toFind, startIndex);
        int endIndex = allText.indexOf("</table>", index + 1);
        endIndex = allText.length();
        BibtexEntry entry = null;
        if (index >= 0) {
            this.piv = index + 1;
            String text = allText.substring(index, endIndex);
            Matcher fullCitation = fullCitationPattern.matcher(text);
            if (fullCitation.find()) {
                try {
                    entry = this.parseEntryBibTeX(fullCitation.group(1), this.fetchAbstract);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.printf("Citation Unmatched %d\n", entryNumber);
                System.out.printf(text, new Object[0]);
            }
            if (entry != null) {
                return entry;
            }
        }
        return null;
    }

    private String convertHTMLChars(String text) {
        return this.htmlConverter.format(text);
    }

    private int getNumberOfHits(String page, String marker, Pattern pattern) throws IOException {
        int ind = page.indexOf(marker);
        if (ind < 0) {
            System.out.println(page);
            throw new IOException(Globals.lang("Could not parse number of hits"));
        }
        String substring = page.substring(ind, Math.min(ind + 42, page.length()));
        Matcher m = pattern.matcher(substring);
        if (m.find()) {
            try {
                String number = m.group(1);
                number = number.replaceAll(",", "");
                return Integer.parseInt(number);
            }
            catch (NumberFormatException ex) {
                throw new IOException(Globals.lang("Could not parse number of hits"));
            }
            catch (IllegalStateException e) {
                throw new IOException(Globals.lang("Could not parse number of hits"));
            }
        }
        System.out.println("Unmatched!");
        System.out.println(substring);
        throw new IOException(Globals.lang("Could not parse number of hits"));
    }

    public String getResults(URL source) throws IOException {
        int bytesRead;
        InputStream in = source.openStream();
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[256];
        while ((bytesRead = in.read(buffer)) != -1) {
            for (int i = 0; i < bytesRead; ++i) {
                sb.append((char)buffer[i]);
            }
        }
        return sb.toString();
    }

    public String getResultsFromFile(File f) throws IOException {
        int bytesRead;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[256];
        while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
            for (int i = 0; i < bytesRead; ++i) {
                sb.append((char)buffer[i]);
            }
        }
        return sb.toString();
    }

    public String getTitle() {
        return "ACM Portal";
    }

    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    public String getHelpPage() {
        return "ACMPortalHelp.html";
    }

    public String getKeyName() {
        return "ACM Portal";
    }

    public void cancelled() {
        this.shouldContinue = false;
    }

    public void done(int entriesImported) {
    }

    public void stopFetching() {
        this.shouldContinue = false;
    }
}

