/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.RightClickMenu;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileMenuItem;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.MainTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainTableSelectionListener
implements ListEventListener<BibtexEntry>,
MouseListener,
KeyListener,
FocusListener {
    PreviewPanel[] previewPanel = null;
    int activePreview = Globals.prefs.getInt("activePreview");
    PreviewPanel preview;
    MainTable table;
    BasePanel panel;
    EventList<BibtexEntry> tableRows;
    private boolean previewActive = Globals.prefs.getBoolean("previewEnabled");
    private boolean workingOnPreview = false;
    private boolean enabled = true;
    private int[] lastPressed = new int[20];
    private int lastPressedCount = 0;
    private long lastPressedTime = 0L;
    private long QUICK_JUMP_TIMEOUT = 2000L;

    public MainTableSelectionListener(BasePanel panel, MainTable table) {
        this.table = table;
        this.panel = panel;
        this.tableRows = table.getTableRows();
        this.instantiatePreviews();
        this.preview = this.previewPanel[this.activePreview];
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void instantiatePreviews() {
        this.previewPanel = new PreviewPanel[]{new PreviewPanel(this.panel.database(), null, this.panel, this.panel.metaData(), Globals.prefs.get("preview0")), new PreviewPanel(this.panel.database(), null, this.panel, this.panel.metaData(), Globals.prefs.get("preview1"))};
        this.panel.frame().getSearchManager().addSearchListener(this.previewPanel[0]);
        this.panel.frame().getSearchManager().addSearchListener(this.previewPanel[1]);
    }

    public void updatePreviews() {
        try {
            this.previewPanel[0].readLayout(Globals.prefs.get("preview0"));
            this.previewPanel[1].readLayout(Globals.prefs.get("preview1"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void listChanged(ListEvent<BibtexEntry> e) {
        if (!this.enabled) {
            return;
        }
        EventList<BibtexEntry> selected = e.getSourceList();
        Object newSelected = null;
        while (e.next()) {
            if (e.getType() != 2) continue;
            if (newSelected != null) {
                return;
            }
            if (e.getIndex() >= selected.size()) continue;
            newSelected = selected.get(e.getIndex());
        }
        if (newSelected != null) {
            BibtexEntry toShow = newSelected;
            int mode = this.panel.getMode();
            if (mode == 3 || mode == 2) {
                EntryEditor oldEditor = this.panel.getCurrentEditor();
                String visName = null;
                if (oldEditor != null) {
                    visName = oldEditor.getVisiblePanelName();
                }
                EntryEditor newEditor = this.panel.getEntryEditor(toShow);
                if (oldEditor != null) {
                    oldEditor.setMovingToDifferentEntry();
                }
                if (newEditor != oldEditor || mode != 2) {
                    if (visName != null) {
                        newEditor.setVisiblePanel(visName);
                    }
                    this.panel.showEntryEditor(newEditor);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MainTableSelectionListener.this.table.ensureVisible(MainTableSelectionListener.this.table.getSelectedRow());
                        }
                    });
                }
            } else if (this.previewActive) {
                this.updatePreview(toShow, false);
            }
        }
    }

    private void updatePreview(BibtexEntry toShow, boolean changedPreview) {
        this.updatePreview(toShow, changedPreview, 0);
    }

    private void updatePreview(final BibtexEntry toShow, final boolean changedPreview, int repeats) {
        if (this.workingOnPreview) {
            if (repeats > 0) {
                return;
            }
            Timer t = new Timer(50, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainTableSelectionListener.this.updatePreview(toShow, changedPreview, 1);
                }
            });
            t.setRepeats(false);
            t.start();
            return;
        }
        EventList<BibtexEntry> list = this.table.getSelected();
        if (list.size() != 1 || list.get(0) != toShow) {
            return;
        }
        final int mode = this.panel.getMode();
        this.workingOnPreview = true;
        final Runnable update = new Runnable(){

            public void run() {
                if (changedPreview || mode == 0) {
                    MainTableSelectionListener.this.panel.showPreview(MainTableSelectionListener.this.preview);
                    MainTableSelectionListener.this.panel.adjustSplitter();
                }
                MainTableSelectionListener.this.workingOnPreview = false;
            }
        };
        Runnable worker = new Runnable(){

            public void run() {
                MainTableSelectionListener.this.preview.setEntry(toShow);
                SwingUtilities.invokeLater(update);
            }
        };
        new Thread(worker).start();
    }

    public void editSignalled() {
        if (this.table.getSelected().size() == 1) {
            this.editSignalled((BibtexEntry)this.table.getSelected().get(0));
        }
    }

    public void editSignalled(BibtexEntry entry) {
        int mode = this.panel.getMode();
        EntryEditor editor = this.panel.getEntryEditor(entry);
        if (mode != 2) {
            this.panel.showEntryEditor(editor);
            this.panel.adjustSplitter();
        }
        new FocusRequester(editor);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (e.isPopupTrigger()) {
            int col = this.table.columnAtPoint(e.getPoint());
            String[] iconType = this.table.getIconTypeForColumn(col);
            if (iconType == null) {
                this.processPopupTrigger(e, row);
            } else {
                this.showIconRightClickMenu(e, row, iconType);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int col = this.table.columnAtPoint(e.getPoint());
        int row = this.table.rowAtPoint(e.getPoint());
        String[] iconType = this.table.getIconTypeForColumn(col);
        if (e.isPopupTrigger()) {
            if (iconType == null) {
                this.processPopupTrigger(e, row);
            } else {
                this.showIconRightClickMenu(e, row, iconType);
            }
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int col = this.table.columnAtPoint(e.getPoint());
        int row = this.table.rowAtPoint(e.getPoint());
        if (e.getClickCount() == 2) {
            BibtexEntry toShow = (BibtexEntry)this.tableRows.get(row);
            this.editSignalled(toShow);
        }
        String[] iconType = this.table.getIconTypeForColumn(col);
        if (Globals.ON_WIN && iconType != null && e.getButton() != 1) {
            return;
        }
        if (iconType != null) {
            Object value = this.table.getValueAt(row, col);
            if (value == null) {
                return;
            }
            final BibtexEntry entry = (BibtexEntry)this.tableRows.get(row);
            int hasField = -1;
            for (int i = iconType.length - 1; i >= 0; --i) {
                if (entry.getField(iconType[i]) == null) continue;
                hasField = i;
            }
            if (hasField == -1) {
                return;
            }
            final String fieldName = iconType[hasField];
            new Thread(){

                public void run() {
                    MainTableSelectionListener.this.panel.output(Globals.lang("External viewer called") + ".");
                    String link = entry.getField(fieldName);
                    if (link == null) {
                        Globals.logger("Error: no link to " + fieldName + ".");
                        return;
                    }
                    if (fieldName.equals("file")) {
                        FileListTableModel fileList = new FileListTableModel();
                        fileList.setContent(link);
                        if (fileList.getRowCount() > 0) {
                            FileListEntry flEntry = fileList.getEntry(0);
                            ExternalFileMenuItem item = new ExternalFileMenuItem(MainTableSelectionListener.this.panel.frame(), entry, "", flEntry.getLink(), (Icon)flEntry.getType().getIcon(), MainTableSelectionListener.this.panel.metaData(), flEntry.getType());
                            boolean success = item.openLink();
                            if (!success) {
                                MainTableSelectionListener.this.panel.output(Globals.lang("Unable to open link."));
                            }
                        }
                    } else {
                        try {
                            Util.openExternalViewer(MainTableSelectionListener.this.panel.metaData(), link, fieldName);
                        }
                        catch (IOException ex) {
                            MainTableSelectionListener.this.panel.output(Globals.lang("Unable to open link."));
                        }
                    }
                }
            }.start();
        }
    }

    protected void processPopupTrigger(MouseEvent e, int row) {
        int selRow = this.table.getSelectedRow();
        if (selRow == -1 || !this.table.isRowSelected(this.table.rowAtPoint(e.getPoint()))) {
            this.table.setRowSelectionInterval(row, row);
        }
        RightClickMenu rightClickMenu = new RightClickMenu(this.panel, this.panel.metaData());
        rightClickMenu.show(this.table, e.getX(), e.getY());
    }

    private void showIconRightClickMenu(MouseEvent e, int row, String[] iconType) {
        BibtexEntry entry = (BibtexEntry)this.tableRows.get(row);
        JPopupMenu menu = new JPopupMenu();
        int count = 0;
        if (iconType[0].equals("file")) {
            String o = entry.getField(iconType[0]);
            FileListTableModel fileList = new FileListTableModel();
            fileList.setContent(o);
            for (int i = 0; i < fileList.getRowCount(); ++i) {
                FileListEntry flEntry = fileList.getEntry(i);
                String description = flEntry.getDescription();
                if (description == null || description.trim().length() == 0) {
                    description = flEntry.getLink();
                }
                menu.add(new ExternalFileMenuItem(this.panel.frame(), entry, description, flEntry.getLink(), (Icon)flEntry.getType().getIcon(), this.panel.metaData(), flEntry.getType()));
                ++count;
            }
        } else {
            for (int i = 0; i < iconType.length; ++i) {
                String o = entry.getField(iconType[i]);
                if (o == null) continue;
                menu.add(new ExternalFileMenuItem(this.panel.frame(), entry, o, o, GUIGlobals.getTableIcon(iconType[i]).getIcon(), this.panel.metaData(), iconType[i]));
                ++count;
            }
        }
        if (count == 0) {
            this.processPopupTrigger(e, row);
            return;
        }
        menu.show(this.table, e.getX(), e.getY());
    }

    public void entryEditorClosing(EntryEditor editor) {
        this.preview.setEntry(editor.getEntry());
        if (this.previewActive) {
            this.panel.showPreview(this.preview);
        } else {
            this.panel.hideBottomComponent();
        }
        this.panel.adjustSplitter();
        new FocusRequester(this.table);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setPreviewActive(boolean enabled) {
        this.previewActive = enabled;
        if (!this.previewActive) {
            this.panel.hideBottomComponent();
        } else if (this.table.getSelected().size() > 0) {
            this.updatePreview((BibtexEntry)this.table.getSelected().get(0), false);
        }
    }

    public void switchPreview() {
        this.activePreview = this.activePreview < this.previewPanel.length - 1 ? ++this.activePreview : 0;
        Globals.prefs.putInt("activePreview", this.activePreview);
        if (this.previewActive) {
            this.preview = this.previewPanel[this.activePreview];
            if (this.table.getSelected().size() > 0) {
                this.updatePreview((BibtexEntry)this.table.getSelected().get(0), true);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!e.isActionKey() && Character.isLetterOrDigit(e.getKeyChar()) && e.getModifiers() == 0) {
            int sortingColumn;
            long time = System.currentTimeMillis();
            if (time - this.lastPressedTime > this.QUICK_JUMP_TIMEOUT) {
                this.lastPressedCount = 0;
            }
            this.lastPressedTime = time;
            char c = e.getKeyChar();
            if (this.lastPressedCount < this.lastPressed.length) {
                this.lastPressed[this.lastPressedCount++] = c;
            }
            if ((sortingColumn = this.table.getSortingColumn(0)) == -1) {
                return;
            }
            int startRow = 0;
            boolean done = false;
            while (!done) {
                for (int i = startRow; i < this.table.getRowCount(); ++i) {
                    String s;
                    Object o = this.table.getValueAt(i, sortingColumn);
                    if (o == null || (s = o.toString().toLowerCase()).length() < this.lastPressedCount) continue;
                    for (int j = 0; j < this.lastPressedCount && s.charAt(j) == this.lastPressed[j]; ++j) {
                        if (j != this.lastPressedCount - 1) continue;
                        this.table.setRowSelectionInterval(i, i);
                        this.table.ensureVisible(i);
                        return;
                    }
                }
                if (startRow > 0) {
                    startRow = 0;
                    continue;
                }
                done = true;
            }
        } else if (e.getKeyChar() == '\u001b') {
            this.lastPressedCount = 0;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.lastPressedCount = 0;
    }
}

