/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.Map;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.SearchRule;
import net.sf.jabref.SearchRuleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AndOrSearchRuleSet
extends SearchRuleSet {
    private boolean and;
    private boolean invert;

    public AndOrSearchRuleSet(boolean and, boolean invert) {
        this.and = and;
        this.invert = invert;
    }

    @Override
    public int applyRule(Map<String, String> searchString, BibtexEntry bibtexEntry) {
        boolean res;
        int score = 0;
        for (SearchRule rule : this.ruleSet) {
            score += rule.applyRule(searchString, bibtexEntry) > 0 ? 1 : 0;
        }
        if (this.and) {
            res = score == this.ruleSet.size();
        } else {
            boolean bl = res = score > 0;
        }
        if (this.invert) {
            return res ? 0 : 1;
        }
        return res ? 1 : 0;
    }
}

