/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.util.XMPUtil;

public class WriteXMPAction
extends AbstractWorker {
    BasePanel panel;
    BibtexEntry[] entries;
    BibtexDatabase database;
    OptionsDialog optDiag;
    boolean goOn = true;
    int skipped;
    int entriesChanged;
    int errors;

    public WriteXMPAction(BasePanel panel) {
        this.panel = panel;
    }

    public void init() {
        this.entries = this.panel.getSelectedEntries();
        if (this.entries.length == 0) {
            this.database = this.panel.getDatabase();
            this.entries = this.database.getEntries().toArray(new BibtexEntry[0]);
            if (this.entries.length == 0) {
                JOptionPane.showMessageDialog(this.panel, Globals.lang("This operation requires at least one entry."), Globals.lang("Write XMP-metadata"), 0);
                this.goOn = false;
                return;
            }
            int response = JOptionPane.showConfirmDialog(this.panel, Globals.lang("Write XMP-metadata for all PDFs in current database?"), Globals.lang("Write XMP-metadata"), 1, 3);
            if (response != 0) {
                this.goOn = false;
                return;
            }
        }
        this.skipped = 0;
        this.entriesChanged = 0;
        this.errors = 0;
        if (this.optDiag == null) {
            this.optDiag = new OptionsDialog(this.panel.frame());
        }
        this.optDiag.open();
        this.panel.output(Globals.lang("Writing XMP metadata..."));
    }

    public void run() {
        if (!this.goOn) {
            return;
        }
        for (int i = 0; i < this.entries.length; ++i) {
            String[] dirs;
            BibtexEntry entry = this.entries[i];
            ArrayList<File> files = new ArrayList<File>();
            String pdf = entry.getField("pdf");
            File f = Util.expandFilename(pdf, dirs = this.panel.metaData().getFileDirectory("pdf"));
            if (f != null) {
                files.add(f);
            }
            dirs = this.panel.metaData().getFileDirectory("file");
            String field = entry.getField("file");
            if (field != null) {
                FileListTableModel tm = new FileListTableModel();
                tm.setContent(field);
                for (int j = 0; j < tm.getRowCount(); ++j) {
                    FileListEntry flEntry = tm.getEntry(j);
                    if (flEntry.getType() == null || !flEntry.getType().getName().toLowerCase().equals("pdf") || (f = Util.expandFilename(flEntry.getLink(), dirs)) == null) continue;
                    files.add(f);
                }
            }
            this.optDiag.progressArea.append(entry.getCiteKey() + "\n");
            if (files.size() == 0) {
                ++this.skipped;
                this.optDiag.progressArea.append("  " + Globals.lang("Skipped - No PDF linked") + ".\n");
            } else {
                for (File file : files) {
                    if (!file.exists()) {
                        ++this.skipped;
                        this.optDiag.progressArea.append("  " + Globals.lang("Skipped - PDF does not exist") + ":\n");
                        this.optDiag.progressArea.append("    " + file.getPath() + "\n");
                        continue;
                    }
                    try {
                        XMPUtil.writeXMP(file, entry, this.database);
                        this.optDiag.progressArea.append("  " + Globals.lang("Ok") + ".\n");
                        ++this.entriesChanged;
                    }
                    catch (Exception e) {
                        this.optDiag.progressArea.append("  " + Globals.lang("Error while writing") + " '" + file.getPath() + "':\n");
                        this.optDiag.progressArea.append("    " + e.getLocalizedMessage() + "\n");
                        ++this.errors;
                    }
                }
            }
            if (!this.optDiag.canceled) continue;
            this.optDiag.progressArea.append("\n" + Globals.lang("Operation canceled.\n"));
            break;
        }
        this.optDiag.progressArea.append("\n" + Globals.lang("Finished writing XMP for %0 file (%1 skipped, %2 errors).", String.valueOf(this.entriesChanged), String.valueOf(this.skipped), String.valueOf(this.errors)));
        this.optDiag.done();
    }

    public void update() {
        if (!this.goOn) {
            return;
        }
        this.panel.output(Globals.lang("Finished writing XMP for %0 file (%1 skipped, %2 errors).", String.valueOf(this.entriesChanged), String.valueOf(this.skipped), String.valueOf(this.errors)));
    }

    class OptionsDialog
    extends JDialog {
        private static final long serialVersionUID = 7459164400811785958L;
        JButton okButton;
        JButton cancelButton;
        boolean canceled;
        JTextArea progressArea;

        public OptionsDialog(JFrame parent) {
            super(parent, Globals.lang("Writing XMP metadata for selected entries..."), false);
            this.okButton = new JButton(Globals.lang("Ok"));
            this.cancelButton = new JButton(Globals.lang("Cancel"));
            this.okButton.setEnabled(false);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.dispose();
                }
            });
            AbstractAction cancel = new AbstractAction(){
                private static final long serialVersionUID = -338601477652815366L;

                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.canceled = true;
                }
            };
            this.cancelButton.addActionListener(cancel);
            InputMap im = this.cancelButton.getInputMap(2);
            ActionMap am = this.cancelButton.getActionMap();
            im.put(Globals.prefs.getKey("Close dialog"), "close");
            am.put("close", cancel);
            this.progressArea = new JTextArea(15, 60);
            JScrollPane scrollPane = new JScrollPane(this.progressArea, 22, 31);
            Dimension d = this.progressArea.getPreferredSize();
            d.height += scrollPane.getHorizontalScrollBar().getHeight() + 15;
            d.width += scrollPane.getVerticalScrollBar().getWidth() + 15;
            WriteXMPAction.this.panel.setSize(d);
            this.progressArea.setBackground(Color.WHITE);
            this.progressArea.setEditable(false);
            this.progressArea.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.progressArea.setText("");
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
            panel.add(scrollPane);
            ButtonBarBuilder bb = new ButtonBarBuilder();
            bb.addGlue();
            bb.addGridded(this.okButton);
            bb.addRelatedGap();
            bb.addGridded(this.cancelButton);
            bb.addGlue();
            JPanel bbPanel = bb.getPanel();
            bbPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            this.getContentPane().add((Component)panel, "Center");
            this.getContentPane().add((Component)bbPanel, "South");
            this.pack();
            this.setResizable(false);
        }

        public void done() {
            this.okButton.setEnabled(true);
            this.cancelButton.setEnabled(false);
        }

        public void open() {
            this.progressArea.setText("");
            this.canceled = false;
            Util.placeDialog(WriteXMPAction.this.optDiag, WriteXMPAction.this.panel.frame());
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            new FocusRequester(this.okButton);
            WriteXMPAction.this.optDiag.setVisible(true);
        }
    }
}

