/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.external.PushToApplication;
import net.sf.jabref.external.PushToApplicationAction;
import net.sf.jabref.external.PushToEmacs;
import net.sf.jabref.external.PushToLatexEditor;
import net.sf.jabref.external.PushToLyx;
import net.sf.jabref.external.PushToVim;
import net.sf.jabref.external.PushToWinEdt;
import net.sf.jabref.oo.OpenOfficePanel;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushToApplicationButton
implements ActionListener {
    public static List<PushToApplication> applications;
    private JabRefFrame frame;
    private List<PushToApplication> pushActions;
    private JPanel comp;
    private JButton pushButton;
    private JButton menuButton;
    private int selected = 0;
    private JPopupMenu popup = null;
    private HashMap<PushToApplication, PushToApplicationAction> actions = new HashMap();
    private final Dimension buttonDim = new Dimension(23, 23);
    private static final URL ARROW_ICON;
    private MenuAction mAction = new MenuAction();
    private JPopupMenu optPopup = new JPopupMenu();
    private JMenuItem settings = new JMenuItem(Globals.lang("Settings"));

    public PushToApplicationButton(JabRefFrame frame, List<PushToApplication> pushActions) {
        this.frame = frame;
        this.pushActions = pushActions;
        this.init();
    }

    private void init() {
        this.comp = new JPanel();
        this.comp.setLayout(new BorderLayout());
        this.menuButton = new JButton(new ImageIcon(ARROW_ICON));
        this.menuButton.setMargin(new Insets(0, 0, 0, 0));
        this.menuButton.setPreferredSize(new Dimension(this.menuButton.getIcon().getIconWidth(), this.menuButton.getIcon().getIconHeight()));
        this.menuButton.addActionListener(new MenuButtonActionListener());
        this.menuButton.setToolTipText(Globals.lang("Select external application"));
        this.pushButton = new JButton();
        if (Globals.prefs.hasKey("pushToApplication")) {
            String appSelected = Globals.prefs.get("pushToApplication");
            for (int i = 0; i < this.pushActions.size(); ++i) {
                PushToApplication toApp = this.pushActions.get(i);
                if (!toApp.getName().equals(appSelected)) continue;
                this.selected = i;
                break;
            }
        }
        this.setSelected(this.selected);
        this.pushButton.addActionListener(this);
        this.pushButton.addMouseListener(new PushButtonMouseListener());
        this.pushButton.setOpaque(false);
        this.menuButton.setOpaque(false);
        this.comp.setOpaque(false);
        this.comp.add((Component)this.pushButton, "Center");
        this.comp.add((Component)this.menuButton, "East");
        this.comp.setMaximumSize(this.comp.getPreferredSize());
        this.optPopup.add(this.settings);
        this.settings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PushToApplication toApp = (PushToApplication)PushToApplicationButton.this.pushActions.get(PushToApplicationButton.this.selected);
                JPanel options = toApp.getSettingsPanel();
                if (options != null) {
                    PushToApplicationButton.showSettingsDialog(PushToApplicationButton.this.frame, toApp, options);
                }
            }
        });
        this.buildPopupMenu();
    }

    private void buildPopupMenu() {
        this.popup = new JPopupMenu();
        int j = 0;
        for (PushToApplication application : this.pushActions) {
            JMenuItem item = new JMenuItem(application.getApplicationName(), application.getIcon());
            item.setToolTipText(application.getTooltip());
            item.addActionListener(new PopupItemActionListener(j));
            this.popup.add(item);
            ++j;
        }
    }

    private void setSelected(int i) {
        this.selected = i;
        PushToApplication toApp = this.pushActions.get(i);
        this.pushButton.setIcon(toApp.getIcon());
        this.pushButton.setToolTipText(toApp.getTooltip());
        this.pushButton.setPreferredSize(this.buttonDim);
        Globals.prefs.put("pushToApplication", toApp.getName());
        this.mAction.setTitle(toApp.getApplicationName());
    }

    public Component getComponent() {
        return this.comp;
    }

    public Action getMenuAction() {
        return this.mAction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PushToApplication toApp = this.pushActions.get(this.selected);
        PushToApplicationAction action = this.actions.get(toApp);
        if (action == null) {
            action = new PushToApplicationAction(this.frame, toApp);
            this.actions.put(toApp, action);
        }
        action.actionPerformed(new ActionEvent(toApp, 0, "push"));
    }

    public static void showSettingsDialog(Object parent, PushToApplication toApp, JPanel options) {
        final BooleanHolder okPressed = new BooleanHolder(false);
        JDialog dg = parent instanceof JDialog ? new JDialog((JDialog)parent, Globals.lang("Settings"), true) : new JDialog((JFrame)parent, Globals.lang("Settings"), true);
        final JDialog diag = dg;
        options.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        diag.getContentPane().add((Component)options, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        JButton ok = new JButton(Globals.lang("Ok"));
        JButton cancel = new JButton(Globals.lang("Cancel"));
        bb.addGlue();
        bb.addGridded(ok);
        bb.addGridded(cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        diag.getContentPane().add((Component)bb.getPanel(), "South");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                okPressed.value = true;
                diag.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                diag.dispose();
            }
        });
        ActionMap am = bb.getPanel().getActionMap();
        InputMap im = bb.getPanel().getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                diag.dispose();
            }
        });
        diag.pack();
        if (parent instanceof JDialog) {
            diag.setLocationRelativeTo((JDialog)parent);
        } else {
            diag.setLocationRelativeTo((JFrame)parent);
        }
        diag.setVisible(true);
        if (okPressed.value) {
            toApp.storeSettings();
        }
    }

    static {
        ARROW_ICON = GUIGlobals.class.getResource("/images/secondary_sorted_reverse.png");
        applications = new ArrayList<PushToApplication>();
        JabRefPlugin jabrefPlugin = JabRefPlugin.getInstance(PluginCore.getManager());
        if (jabrefPlugin != null) {
            List<_JabRefPlugin.PushToApplicationExtension> plugins = jabrefPlugin.getPushToApplicationExtensions();
            for (_JabRefPlugin.PushToApplicationExtension extension : plugins) {
                applications.add(extension.getPushToApp());
            }
            applications.add(new PushToLyx());
            applications.add(new PushToEmacs());
            applications.add(new PushToWinEdt());
            applications.add(new PushToLatexEditor());
            applications.add(new PushToVim());
            applications.add(OpenOfficePanel.getInstance());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PushToApplicationComparator
    implements Comparator<PushToApplication> {
        PushToApplicationComparator() {
        }

        @Override
        public int compare(PushToApplication one, PushToApplication two) {
            return one.getName().compareTo(two.getName());
        }
    }

    class PushButtonMouseListener
    extends MouseAdapter {
        PushButtonMouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.processPopupTrigger(event);
            }
        }

        public void mouseClicked(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.processPopupTrigger(event);
            }
        }

        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.processPopupTrigger(event);
            }
        }

        private void processPopupTrigger(MouseEvent e) {
            PushToApplication toApp = (PushToApplication)PushToApplicationButton.this.pushActions.get(PushToApplicationButton.this.selected);
            if (toApp.getSettingsPanel() != null) {
                PushToApplicationButton.this.optPopup.show(PushToApplicationButton.this.pushButton, e.getX(), e.getY());
            }
        }
    }

    class MenuAction
    extends MnemonicAwareAction {
        public MenuAction() {
            this.putValue("AcceleratorKey", Globals.prefs.getKey("Push to application"));
        }

        public void setTitle(String appName) {
            this.putValue("Name", Globals.lang("Push entries to external application (%0)", appName));
        }

        public void actionPerformed(ActionEvent e) {
            PushToApplicationButton.this.actionPerformed(null);
        }
    }

    class MenuButtonActionListener
    implements ActionListener {
        MenuButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (PushToApplicationButton.this.popup == null) {
                PushToApplicationButton.this.buildPopupMenu();
            }
            PushToApplicationButton.this.popup.show(PushToApplicationButton.this.comp, 0, PushToApplicationButton.this.menuButton.getHeight());
        }
    }

    class PopupItemActionListener
    implements ActionListener {
        private int index;

        public PopupItemActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            PushToApplicationButton.this.setSelected(this.index);
            PushToApplicationButton.this.pushButton.requestFocus();
        }
    }

    static class BooleanHolder {
        public boolean value;

        public BooleanHolder(boolean value) {
            this.value = value;
        }
    }
}

