/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.FileListEditor;
import net.sf.jabref.gui.FileListEntry;

public class MoveFileAction
extends AbstractAction {
    private JabRefFrame frame;
    private EntryEditor eEditor;
    private FileListEditor editor;
    private boolean toFileDir;

    public MoveFileAction(JabRefFrame frame, EntryEditor eEditor, FileListEditor editor, boolean toFileDir) {
        this.frame = frame;
        this.eEditor = eEditor;
        this.editor = editor;
        this.toFileDir = toFileDir;
    }

    public void actionPerformed(ActionEvent event) {
        block27: {
            int selected = this.editor.getSelectedRow();
            if (selected == -1) {
                return;
            }
            FileListEntry flEntry = this.editor.getTableModel().getEntry(selected);
            String ln = flEntry.getLink();
            boolean httpLink = ln.toLowerCase().startsWith("http");
            if (httpLink) {
                // empty if block
            }
            String[] dirs = this.frame.basePanel().metaData().getFileDirectory("file");
            int found = -1;
            for (int i = 0; i < dirs.length; ++i) {
                if (!new File(dirs[i]).exists()) continue;
                found = i;
                break;
            }
            if (found < 0) {
                JOptionPane.showMessageDialog(this.frame, Globals.lang("File_directory_is_not_set_or_does_not_exist!"), Globals.lang("Move/Rename file"), 0);
                return;
            }
            File file = new File(ln);
            if (!file.isAbsolute()) {
                file = Util.expandFilename(ln, dirs);
            }
            if (file != null && file.exists()) {
                String extension = null;
                if (flEntry.getType() != null) {
                    extension = "." + flEntry.getType().getExtension();
                }
                File newFile = null;
                boolean repeat = true;
                while (repeat) {
                    String chosenFile;
                    repeat = false;
                    if (this.toFileDir) {
                        String suggName = Util.getLinkedFileName(this.eEditor.getDatabase(), this.eEditor.getEntry()).concat(".").concat(flEntry.getType().extension);
                        CheckBoxMessage cbm = new CheckBoxMessage(Globals.lang("Move file to file directory?"), Globals.lang("Rename to '%0'", suggName), Globals.prefs.getBoolean("renameOnMoveFileToFileDir"));
                        int answer = !suggName.equals(file.getName()) ? JOptionPane.showConfirmDialog(this.frame, cbm, Globals.lang("Move/Rename file"), 0) : JOptionPane.showConfirmDialog(this.frame, Globals.lang("Move file to file directory?"), Globals.lang("Move/Rename file"), 0);
                        if (answer != 0) {
                            return;
                        }
                        Globals.prefs.putBoolean("renameOnMoveFileToFileDir", cbm.isSelected());
                        StringBuilder sb = new StringBuilder(dirs[found]);
                        if (!dirs[found].endsWith(File.separator)) {
                            sb.append(File.separator);
                        }
                        if (cbm.isSelected()) {
                            sb.append(suggName);
                        } else {
                            sb.append(file.getName());
                        }
                        chosenFile = sb.toString();
                    } else {
                        chosenFile = FileDialogs.getNewFile(this.frame, file, extension, 1, false);
                    }
                    if (chosenFile == null) {
                        return;
                    }
                    newFile = new File(chosenFile);
                    if (!newFile.exists() || JOptionPane.showConfirmDialog(this.frame, "'" + newFile.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Move/Rename file"), 2) == 0) continue;
                    if (!this.toFileDir) {
                        repeat = true;
                        continue;
                    }
                    return;
                }
                if (!newFile.equals(file)) {
                    try {
                        boolean success = file.renameTo(newFile);
                        if (!success) {
                            success = Util.copyFile(file, newFile, true);
                        }
                        if (success) {
                            file.delete();
                            String canPath = new File(dirs[found]).getCanonicalPath();
                            if (newFile.getCanonicalPath().startsWith(canPath)) {
                                if (newFile.getCanonicalPath().length() > canPath.length() && newFile.getCanonicalPath().charAt(canPath.length()) == File.separatorChar) {
                                    flEntry.setLink(newFile.getCanonicalPath().substring(1 + canPath.length()));
                                } else {
                                    flEntry.setLink(newFile.getCanonicalPath().substring(canPath.length()));
                                }
                            } else {
                                flEntry.setLink(newFile.getCanonicalPath());
                            }
                            this.eEditor.updateField(this.editor);
                            JOptionPane.showMessageDialog(this.frame, Globals.lang("File moved"), Globals.lang("Move/Rename file"), 1);
                            break block27;
                        }
                        JOptionPane.showMessageDialog(this.frame, Globals.lang("Move file failed"), Globals.lang("Move/Rename file"), 0);
                    }
                    catch (SecurityException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not move file") + ": " + ex.getMessage(), Globals.lang("Move/Rename file"), 0);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not move file") + ": " + ex.getMessage(), Globals.lang("Move/Rename file"), 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not find file '%0'.", flEntry.getLink()), Globals.lang("File not found"), 0);
            }
        }
    }
}

