/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.sf.jabref.BaseAction;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessLinksForEntries {
    public static List<FileListEntry> getExternalLinksForEntries(List<BibtexEntry> entries) {
        ArrayList<FileListEntry> files = new ArrayList<FileListEntry>();
        FileListTableModel model = new FileListTableModel();
        for (BibtexEntry entry : entries) {
            String links = entry.getField("file");
            if (links == null) continue;
            model.setContent(links);
            for (int i = 0; i < model.getRowCount(); ++i) {
                files.add(model.getEntry(i));
            }
        }
        return files;
    }

    public static void copyExternalLinksToDirectory(final List<FileListEntry> files, File toDir, MetaData metaData, final JProgressBar prog, boolean deleteOriginalFiles, ActionListener callback) {
        if (prog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    prog.setMaximum(files.size());
                    prog.setValue(0);
                    prog.setIndeterminate(false);
                }
            });
        }
        HashSet<String> fileNames = new HashSet<String>();
        int i = 0;
        for (FileListEntry entry : files) {
            int i2;
            File file = new File(entry.getLink());
            String name = file.getName();
            int pos = name.lastIndexOf(46);
            String extension = pos >= 0 && pos < name.length() - 1 ? name.substring(pos + 1).trim().toLowerCase() : null;
            String[] dir = metaData.getFileDirectory(extension);
            String[] fileDir = metaData.getFileDirectory("file");
            ArrayList<String> al = new ArrayList<String>();
            for (i2 = 0; i2 < dir.length; ++i2) {
                if (al.contains(dir[i2])) continue;
                al.add(dir[i2]);
            }
            for (i2 = 0; i2 < fileDir.length; ++i2) {
                if (al.contains(fileDir[i2])) continue;
                al.add(fileDir[i2]);
            }
            String[] dirs = al.toArray(new String[al.size()]);
            File tmp = Util.expandFilename(entry.getLink(), dirs);
            if (tmp != null) {
                file = tmp;
            }
            if (!file.exists() || fileNames.contains(name)) continue;
            fileNames.add(name);
            File destination = new File(toDir, name);
            if (!destination.equals(file)) {
                try {
                    Util.copyFile(file, destination, false);
                    if (deleteOriginalFiles) {
                        file.delete();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            final int j = ++i;
            if (prog == null) continue;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    prog.setValue(j);
                }
            });
        }
        if (callback != null) {
            callback.actionPerformed(null);
        }
    }

    public static class SaveWithLinkedFiles
    extends BaseAction {
        private BasePanel panel;

        public SaveWithLinkedFiles(BasePanel panel) {
            this.panel = panel;
        }

        public void action() throws Throwable {
            ArrayList<BibtexEntry> entries = new ArrayList<BibtexEntry>();
            BibtexEntry[] sel = this.panel.getSelectedEntries();
            for (int i = 0; i < sel.length; ++i) {
                BibtexEntry bibtexEntry = sel[i];
                entries.add(bibtexEntry);
            }
            final List<FileListEntry> links = AccessLinksForEntries.getExternalLinksForEntries(entries);
            for (FileListEntry entry : links) {
                System.out.println("Link: " + entry.getLink());
            }
            final JProgressBar prog = new JProgressBar();
            prog.setIndeterminate(true);
            final JDialog diag = new JDialog((Frame)this.panel.frame(), false);
            diag.getContentPane().add((Component)prog, "Center");
            diag.pack();
            diag.setLocationRelativeTo(this.panel.frame());
            diag.setVisible(true);
            Thread t = new Thread(new Runnable(){

                public void run() {
                    AccessLinksForEntries.copyExternalLinksToDirectory(links, new File("/home/alver/tmp"), SaveWithLinkedFiles.this.panel.metaData(), prog, false, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            diag.dispose();
                        }
                    });
                }
            });
            t.start();
        }
    }
}

