/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertString;

public class StringAddChange
extends Change {
    BibtexString string;
    InfoPane tp = new InfoPane();
    JScrollPane sp = new JScrollPane(this.tp);

    public StringAddChange(BibtexString string) {
        this.name = Globals.lang("Added string") + ": '" + string.getName() + "'";
        this.string = string;
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML><H2>");
        sb.append(Globals.lang("Added string"));
        sb.append("</H2><H3>");
        sb.append(Globals.lang("Label")).append(":</H3>");
        sb.append(string.getName());
        sb.append("<H3>");
        sb.append(Globals.lang("Content")).append(":</H3>");
        sb.append(string.getContent());
        sb.append("</HTML>");
        this.tp.setText(sb.toString());
    }

    public boolean makeChange(BasePanel panel, BibtexDatabase secondary, NamedCompound undoEdit) {
        if (panel.database().hasStringLabel(this.string.getName())) {
            Globals.logger("Cannot add string '" + this.string.getName() + "' because the name " + "is already in use.");
        }
        try {
            panel.database().addString(this.string);
            undoEdit.addEdit(new UndoableInsertString(panel, panel.database(), this.string));
        }
        catch (KeyCollisionException ex) {
            Globals.logger("Error: could not add string '" + this.string.getName() + "': " + ex.getMessage());
        }
        try {
            secondary.addString(new BibtexString(Util.createNeutralId(), this.string.getName(), this.string.getContent()));
        }
        catch (KeyCollisionException ex) {
            Globals.logger("Error: could not add string '" + this.string.getName() + "' to tmp database: " + ex.getMessage());
        }
        return true;
    }

    JComponent description() {
        return this.sp;
    }
}

