/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.CompressedEntryEditorTab;
import net.sf.jabref.EntryEditorTab;
import net.sf.jabref.EntryEditorTabList;
import net.sf.jabref.FieldContentSelector;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldTextArea;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JTextAreaWithHighlighting;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.SearchTextListener;
import net.sf.jabref.SimpleUrlDragDrop;
import net.sf.jabref.Util;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.external.ExternalFilePanel;
import net.sf.jabref.external.WriteXMPEntryEditorAction;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.FileListEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.VerticalLabelUI;
import net.sf.jabref.gui.date.DatePickerButton;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.journals.JournalAbbreviations;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableChangeType;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.undo.UndoableKeyChange;
import net.sf.jabref.undo.UndoableRemoveEntry;

public class EntryEditor
extends JPanel
implements VetoableChangeListener {
    private BibtexEntry entry;
    BibtexEntryType type;
    CloseAction closeAction;
    DeleteAction deleteAction = new DeleteAction();
    CopyKeyAction copyKeyAction;
    AbstractAction nextEntryAction = new NextEntryAction();
    AbstractAction prevEntryAction = new PrevEntryAction();
    public StoreFieldAction storeFieldAction;
    SwitchLeftAction switchLeftAction = new SwitchLeftAction();
    SwitchRightAction switchRightAction = new SwitchRightAction();
    public GenerateKeyAction generateKeyAction;
    public AutoSetFileAction autoLink = new AutoSetFileAction();
    public AbstractAction writeXmp;
    SaveDatabaseAction saveDatabaseAction = new SaveDatabaseAction();
    JPanel mainPanel = new JPanel();
    JPanel srcPanel = new JPanel();
    EntryEditorTab genPan;
    EntryEditorTab optPan;
    EntryEditorTab reqPan;
    EntryEditorTab absPan;
    JTextField bibtexKey;
    FieldTextField tf;
    JTextArea source;
    JToolBar tlb;
    JTabbedPane tabbed = new JTabbedPane();
    JLabel lab;
    TypeLabel typeLabel;
    JabRefFrame frame;
    BasePanel panel;
    EntryEditor ths = this;
    HashSet<FieldContentSelector> contentSelectors = new HashSet();
    Logger logger = Logger.getLogger(EntryEditor.class.getName());
    boolean updateSource = true;
    boolean movingToDifferentEntry = false;
    List<Object> tabs = new ArrayList<Object>();
    boolean lastSourceAccepted = true;
    String lastSourceStringAccepted = null;
    private int sourceIndex = -1;
    JabRefPreferences prefs;
    HelpAction helpAction;
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    TabListener tabListener = new TabListener();

    public EntryEditor(JabRefFrame frame_, BasePanel panel_, BibtexEntry entry_) {
        this.frame = frame_;
        this.panel = panel_;
        this.entry = entry_;
        this.prefs = Globals.prefs;
        this.type = this.entry.getType();
        this.entry.addPropertyChangeListener(this);
        this.helpAction = new HelpAction(this.frame.helpDiag, GUIGlobals.entryEditorHelp, "Help");
        this.closeAction = new CloseAction();
        this.copyKeyAction = new CopyKeyAction();
        this.generateKeyAction = new GenerateKeyAction(this.frame);
        this.storeFieldAction = new StoreFieldAction();
        this.writeXmp = new WriteXMPEntryEditorAction(panel_, this);
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        this.setupToolBar();
        this.setupFieldPanels();
        this.setupSourcePanel();
        this.add((Component)this.tabbed, "Center");
        this.tabbed.addChangeListener(this.tabListener);
        if (this.prefs.getBoolean("showSource") && this.prefs.getBoolean("defaultShowSource")) {
            this.tabbed.setSelectedIndex(this.sourceIndex);
        }
        this.updateAllFields();
    }

    private void setupFieldPanels() {
        this.tabbed.removeAll();
        this.tabs.clear();
        String[] fields = this.entry.getRequiredFields();
        List<String> fieldList = null;
        if (fields != null) {
            fieldList = Arrays.asList(fields);
        }
        this.reqPan = new EntryEditorTab(this.frame, this.panel, fieldList, this, true, Globals.lang("Required fields"));
        this.tabbed.addTab(Globals.lang("Required fields"), GUIGlobals.getImage("required"), this.reqPan.getPane(), Globals.lang("Show required fields"));
        this.tabs.add(this.reqPan);
        if (this.entry.getOptionalFields() != null && this.entry.getOptionalFields().length >= 1) {
            if (!this.prefs.getBoolean("biblatexMode")) {
                this.optPan = new EntryEditorTab(this.frame, this.panel, Arrays.asList(this.entry.getOptionalFields()), this, false, Globals.lang("Optional fields"));
                this.tabbed.addTab(Globals.lang("Optional fields"), GUIGlobals.getImage("optional"), this.optPan.getPane(), Globals.lang("Show optional fields"));
                this.tabs.add(this.optPan);
            } else {
                this.optPan = new CompressedEntryEditorTab(this.frame, this.panel, Arrays.asList(this.entry.getType().getPrimaryOptionalFields()), this, false, Globals.lang("Optional fields"));
                this.tabbed.addTab(Globals.lang("Optional fields"), GUIGlobals.getImage("optional"), this.optPan.getPane(), Globals.lang("Show optional fields"));
                this.tabs.add(this.optPan);
                this.optPan = new CompressedEntryEditorTab(this.frame, this.panel, Arrays.asList(Util.getRemainder(this.entry.getOptionalFields(), this.entry.getType().getPrimaryOptionalFields())), this, false, Globals.lang("Optional fields 2"));
                this.tabbed.addTab(Globals.lang("Optional fields 2"), GUIGlobals.getImage("optional"), this.optPan.getPane(), Globals.lang("Show optional fields"));
                this.tabs.add(this.optPan);
            }
        }
        EntryEditorTabList tabList = Globals.prefs.getEntryEditorTabList();
        for (int i = 0; i < tabList.getTabCount(); ++i) {
            EntryEditorTab newTab = new EntryEditorTab(this.frame, this.panel, tabList.getTabFields(i), this, false, tabList.getTabName(i));
            this.tabbed.addTab(tabList.getTabName(i), GUIGlobals.getImage("general"), newTab.getPane());
            this.tabs.add(newTab);
        }
        this.srcPanel.setName(Globals.lang("BibTeX source"));
        if (Globals.prefs.getBoolean("showSource")) {
            this.tabbed.addTab(Globals.lang("BibTeX source"), GUIGlobals.getImage("source"), this.srcPanel, Globals.lang("Show/edit BibTeX source"));
            this.tabs.add(this.srcPanel);
        }
        this.sourceIndex = this.tabs.size() - 1;
        this.srcPanel.setFocusCycleRoot(true);
    }

    public BibtexEntryType getType() {
        return this.type;
    }

    public BibtexEntry getEntry() {
        return this.entry;
    }

    public BibtexDatabase getDatabase() {
        return this.panel.getDatabase();
    }

    private void setupToolBar() {
        JPanel leftPan = new JPanel();
        leftPan.setLayout(new BorderLayout());
        this.tlb = new JToolBar(1);
        this.tlb.setBorder(null);
        this.tlb.setRollover(true);
        this.tlb.setMargin(new Insets(0, 0, 0, 2));
        ActionMap am = this.tlb.getActionMap();
        InputMap im = this.tlb.getInputMap(2);
        im.put(this.prefs.getKey("Close entry editor"), "close");
        am.put("close", this.closeAction);
        im.put(this.prefs.getKey("Entry editor, store field"), "store");
        am.put("store", this.storeFieldAction);
        im.put(this.prefs.getKey("Autogenerate BibTeX keys"), "generateKey");
        am.put("generateKey", this.generateKeyAction);
        im.put(this.prefs.getKey("Automatically link files"), "autoLink");
        am.put("autoLink", this.autoLink);
        im.put(this.prefs.getKey("Entry editor, previous entry"), "prev");
        am.put("prev", this.prevEntryAction);
        im.put(this.prefs.getKey("Entry editor, next entry"), "next");
        am.put("next", this.nextEntryAction);
        im.put(this.prefs.getKey("Undo"), "undo");
        am.put("undo", this.undoAction);
        im.put(this.prefs.getKey("Redo"), "redo");
        am.put("redo", this.redoAction);
        im.put(this.prefs.getKey("Help"), "help");
        am.put("help", this.helpAction);
        this.tlb.setFloatable(false);
        JButton closeBut = new JButton(this.closeAction);
        closeBut.setText(null);
        closeBut.setBorder(null);
        leftPan.add((Component)closeBut, "North");
        this.typeLabel = new TypeLabel(this.entry.getType().getName());
        leftPan.add((Component)this.typeLabel, "Center");
        this.tlb.addSeparator();
        this.tlb.add(this.generateKeyAction);
        this.tlb.add(this.autoLink);
        this.tlb.add(this.writeXmp);
        this.tlb.addSeparator();
        this.tlb.add(this.deleteAction);
        this.tlb.add(this.prevEntryAction);
        this.tlb.add(this.nextEntryAction);
        this.tlb.addSeparator();
        this.tlb.add(this.helpAction);
        Component[] comps = this.tlb.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ((JComponent)comps[i]).setOpaque(false);
        }
        leftPan.add((Component)this.tlb, "South");
        this.add((Component)leftPan, "West");
    }

    public void rebuildPanels() {
        this.tabbed.removeChangeListener(this.tabListener);
        this.setupFieldPanels();
        this.tabbed.addChangeListener(this.tabListener);
        this.revalidate();
        this.repaint();
    }

    public JComponent getExtra(String string, final FieldEditor ed) {
        final String fieldName = ed.getFieldName();
        String s = BibtexFields.getFieldExtras(string);
        if (fieldName.equals(Globals.prefs.get("timeStampField")) || s != null && s.equals("datepicker")) {
            ((JTextArea)((Object)ed)).addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        String date = Util.easyDateFormat();
                        ed.setText(date);
                    }
                }
            });
            if (s != null && s.equals("datepicker")) {
                DatePickerButton datePicker = new DatePickerButton(ed);
                return datePicker.getDatePicker();
            }
        }
        if (s != null && s.equals("external")) {
            ((JComponent)((Object)ed)).addMouseListener(new ExternalViewerListener());
            return null;
        }
        if (s != null && s.equals("journalNames")) {
            JPanel controls = new JPanel();
            controls.setLayout(new BorderLayout());
            if (this.panel.metaData.getData("selector_" + ed.getFieldName()) != null) {
                FieldContentSelector ws = new FieldContentSelector(this.frame, this.panel, this.frame, ed, this.panel.metaData, this.storeFieldAction, false, ", ");
                this.contentSelectors.add(ws);
                controls.add((Component)ws, "North");
            }
            controls.add((Component)JournalAbbreviations.getNameSwitcher(this, ed, this.panel.undoManager), "South");
            return controls;
        }
        if (this.panel.metaData.getData("selector_" + ed.getFieldName()) != null) {
            FieldContentSelector ws = new FieldContentSelector(this.frame, this.panel, this.frame, ed, this.panel.metaData, this.storeFieldAction, false, ed.getFieldName().equals("author") || ed.getFieldName().equals("editor") ? " and " : ", ");
            this.contentSelectors.add(ws);
            return ws;
        }
        if (s != null && s.equals("browse")) {
            JButton but = new JButton(Globals.lang("Browse"));
            ((JComponent)((Object)ed)).addMouseListener(new ExternalViewerListener());
            but.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String chosenFile;
                    String dir = ed.getText();
                    if (dir.equals("")) {
                        dir = EntryEditor.this.prefs.get(fieldName + "_dir", "");
                    }
                    if ((chosenFile = FileDialogs.getNewFile(EntryEditor.this.frame, new File(dir), "." + fieldName, 0, false)) != null) {
                        File newFile = new File(chosenFile);
                        ed.setText(newFile.getPath());
                        EntryEditor.this.prefs.put(fieldName + "_dir", newFile.getPath());
                        EntryEditor.this.updateField(ed);
                    }
                }
            });
            return but;
        }
        if (s != null && (s.equals("browseDoc") || s.equals("browseDocZip"))) {
            String ext = "." + fieldName.toLowerCase();
            OpenFileFilter off = s.equals("browseDocZip") ? new OpenFileFilter(new String[]{ext, ext + ".gz", ext + ".bz2"}) : new OpenFileFilter(new String[]{ext});
            ExternalFilePanel pan = new ExternalFilePanel(this.frame, this.panel.metaData(), this, fieldName, off, ed);
            return pan;
        }
        if (s != null && s.equals("url")) {
            ((JComponent)((Object)ed)).setDropTarget(new DropTarget((Component)((Object)ed), 0, new SimpleUrlDragDrop(ed, this.storeFieldAction)));
            return null;
        }
        if (s != null && s.equals("setOwner")) {
            JButton button = new JButton(Globals.lang("Auto"));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ed.setText(Globals.prefs.get("defaultOwner"));
                    EntryEditor.this.storeFieldAction.actionPerformed(new ActionEvent(ed, 0, ""));
                }
            });
            return button;
        }
        return null;
    }

    private void setupSourcePanel() {
        this.source = new JTextAreaWithHighlighting();
        this.frame.getSearchManager().addSearchListener((SearchTextListener)((Object)this.source));
        this.source.setEditable(true);
        this.source.setLineWrap(true);
        this.source.setTabSize(4);
        this.source.addFocusListener(new FieldEditorFocusListener());
        this.source.addFocusListener(Globals.focusListener);
        this.source.setFont(new Font("Monospaced", 0, Globals.prefs.getInt("fontSize")));
        this.setupJTextComponent(this.source);
        this.updateSource();
        JScrollPane sp = new JScrollPane(this.source, 20, 31);
        this.srcPanel.setLayout(new BorderLayout());
        this.srcPanel.add((Component)sp, "Center");
    }

    public void updateSource() {
        if (this.updateSource) {
            StringWriter sw = new StringWriter(200);
            try {
                LatexFieldFormatter formatter = new LatexFieldFormatter();
                formatter.setNeverFailOnHashes(true);
                this.entry.write(sw, formatter, false);
                String srcString = sw.getBuffer().toString();
                this.source.setText(srcString);
                this.lastSourceStringAccepted = srcString;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int row = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
                        if (row >= 0) {
                            if (EntryEditor.this.panel.mainTable.getSelectedRowCount() == 0) {
                                EntryEditor.this.panel.mainTable.setRowSelectionInterval(row, row);
                            }
                            EntryEditor.this.panel.mainTable.ensureVisible(row);
                        }
                    }
                });
            }
            catch (IOException ex) {
                this.source.setText(ex.getMessage() + "\n\n" + Globals.lang("Correct the entry, and reopen editor to display/edit source."));
                this.source.setEditable(false);
            }
        }
    }

    public void setupJTextComponent(JTextComponent ta) {
        InputMap im = ta.getInputMap(0);
        ActionMap am = ta.getActionMap();
        im.put(this.prefs.getKey("Entry editor, store field"), "store");
        am.put("store", this.storeFieldAction);
        im.put(this.prefs.getKey("Entry editor, next panel"), "right");
        im.put(this.prefs.getKey("Entry editor, next panel 2"), "right");
        am.put("right", this.switchRightAction);
        im.put(this.prefs.getKey("Entry editor, previous panel"), "left");
        im.put(this.prefs.getKey("Entry editor, previous panel 2"), "left");
        am.put("left", this.switchLeftAction);
        im.put(this.prefs.getKey("Help"), "help");
        am.put("help", this.helpAction);
        im.put(this.prefs.getKey("Save database"), "save");
        am.put("save", this.saveDatabaseAction);
        im.put(Globals.prefs.getKey("Next tab"), "nexttab");
        am.put("nexttab", this.frame.nextTab);
        im.put(Globals.prefs.getKey("Previous tab"), "prevtab");
        am.put("prevtab", this.frame.prevTab);
        try {
            HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(ta.getFocusTraversalKeys(0));
            keys.clear();
            keys.add(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
            ta.setFocusTraversalKeys(0, keys);
            keys = new HashSet<AWTKeyStroke>(ta.getFocusTraversalKeys(1));
            keys.clear();
            keys.add(KeyStroke.getKeyStroke("shift pressed TAB"));
            ta.setFocusTraversalKeys(1, keys);
        }
        catch (Throwable t) {
            System.err.println(t);
        }
        ta.addFocusListener(new FieldListener());
    }

    public void requestFocus() {
        this.activateVisible();
    }

    private void activateVisible() {
        Object activeTab = this.tabs.get(this.tabbed.getSelectedIndex());
        if (activeTab instanceof EntryEditorTab) {
            ((EntryEditorTab)activeTab).activate();
        } else {
            new FocusRequester(this.source);
        }
    }

    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        for (Object o : this.tabs) {
            if (!(o instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)o).setEnabled(enabled);
        }
        this.source.setEnabled(enabled);
    }

    private void scrollTo(int row) {
        this.movingToDifferentEntry = true;
        this.panel.mainTable.setRowSelectionInterval(row, row);
        this.panel.mainTable.ensureVisible(row);
    }

    public void storeCurrentEdit() {
        JComponent comp = Globals.focusListener.getFocused();
        if (comp == this.source || comp instanceof FieldEditor && this.isAncestorOf(comp)) {
            if (comp instanceof FieldEditor) {
                ((FieldEditor)((Object)comp)).clearAutoCompleteSuggestion();
            }
            this.storeFieldAction.actionPerformed(new ActionEvent(comp, 0, ""));
        }
    }

    public int getVisiblePanel() {
        return this.tabbed.getSelectedIndex();
    }

    public String getVisiblePanelName() {
        return this.tabbed.getSelectedComponent().getName();
    }

    public void setVisiblePanel(int i) {
        this.tabbed.setSelectedIndex(Math.min(i, this.tabbed.getTabCount() - 1));
    }

    public void setVisiblePanel(String name) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            if (!name.equals(this.tabbed.getComponent(i).getName())) continue;
            this.tabbed.setSelectedIndex(i);
            return;
        }
        if (this.tabbed.getTabCount() > 0) {
            this.tabbed.setSelectedIndex(0);
        }
    }

    public synchronized void switchTo(BibtexEntry be) {
        if (this.entry == be) {
            this.updateSource();
            return;
        }
        this.storeCurrentEdit();
        this.entry.removePropertyChangeListener(this);
        be.addPropertyChangeListener(this);
        this.entry = be;
        this.updateAllFields();
        this.validateAllFields();
        this.updateSource();
        this.panel.newEntryShowing(be);
    }

    public boolean lastSourceAccepted() {
        if (this.tabbed.getSelectedComponent() == this.srcPanel) {
            this.storeSource(false);
        }
        return this.lastSourceAccepted;
    }

    public boolean storeSource(boolean showError) {
        BibtexParser bp = new BibtexParser(new StringReader(this.source.getText()));
        try {
            boolean emptyWarning;
            BibtexDatabase db = bp.parse().getDatabase();
            if (db.getEntryCount() > 1) {
                throw new Exception("More than one entry found.");
            }
            if (db.getEntryCount() < 1) {
                throw new Exception("No entries found.");
            }
            NamedCompound compound = new NamedCompound(Globals.lang("source edit"));
            BibtexEntry nu = db.getEntryById(db.getKeySet().iterator().next());
            String id = this.entry.getId();
            String newKey = nu.getCiteKey();
            boolean anyChanged = false;
            boolean changedType = false;
            boolean duplicateWarning = false;
            boolean bl = emptyWarning = newKey == null || newKey.equals("");
            if (this.panel.database.setCiteKeyForEntry(id, newKey)) {
                duplicateWarning = true;
            }
            for (String field : this.entry.getAllFields()) {
                if (!BibtexFields.isDisplayableField(field.toString()) || nu.getField(field.toString()) != null) continue;
                compound.addEdit(new UndoableFieldChange(this.entry, field.toString(), this.entry.getField(field.toString()), null));
                this.entry.clearField(field.toString());
                anyChanged = true;
            }
            for (String field : nu.getAllFields()) {
                if (this.entry.getField(field.toString()) == nu.getField(field.toString())) continue;
                String toSet = nu.getField(field.toString());
                new LatexFieldFormatter().format(toSet, field.toString());
                compound.addEdit(new UndoableFieldChange(this.entry, field.toString(), this.entry.getField(field.toString()), toSet));
                this.entry.setField(field.toString(), toSet);
                anyChanged = true;
            }
            if (nu.getType() != this.entry.getType()) {
                compound.addEdit(new UndoableChangeType(this.entry, this.entry.getType(), nu.getType()));
                this.entry.setType(nu.getType());
                anyChanged = true;
                changedType = true;
            }
            compound.end();
            if (!anyChanged) {
                return true;
            }
            this.panel.undoManager.addEdit(compound);
            if (duplicateWarning) {
                this.warnDuplicateBibtexkey();
            } else if (emptyWarning && showError) {
                this.warnEmptyBibtexkey();
            } else {
                this.panel.output(Globals.lang("Stored entry") + ".");
            }
            this.lastSourceStringAccepted = this.source.getText();
            if (!changedType) {
                this.updateAllFields();
                this.lastSourceAccepted = true;
                this.updateSource = true;
            } else {
                this.panel.updateEntryEditorIfShowing();
            }
            this.panel.markBaseChanged();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int row = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
                    if (row >= 0) {
                        EntryEditor.this.panel.mainTable.ensureVisible(row);
                    }
                }
            });
            return true;
        }
        catch (Throwable ex) {
            this.updateSource = false;
            this.lastSourceAccepted = false;
            this.tabbed.setSelectedComponent(this.srcPanel);
            if (showError) {
                Object[] options = new Object[]{Globals.lang("Edit"), Globals.lang("Revert to original source")};
                int answer = JOptionPane.showOptionDialog(this.frame, Globals.lang("Error") + ": " + ex.getMessage(), Globals.lang("Problem with parsing entry"), 0, 0, null, options, options[0]);
                if (answer != 0) {
                    this.updateSource = true;
                    this.updateSource();
                }
            }
            return false;
        }
    }

    public void setField(String fieldName, String newFieldData) {
        for (Object o : this.tabs) {
            if (!(o instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)o).updateField(fieldName, newFieldData);
        }
    }

    public void updateAllFields() {
        for (Object o : this.tabs) {
            if (!(o instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)o).setEntry(this.entry);
        }
    }

    public void validateAllFields() {
        for (Object o : this.tabs) {
            if (!(o instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)o).validateAllFields();
        }
    }

    public void updateAllContentSelectors() {
        if (this.contentSelectors.size() > 0) {
            Iterator<FieldContentSelector> i = this.contentSelectors.iterator();
            while (i.hasNext()) {
                i.next().rebuildComboBox();
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent e) {
        String newValue = e.getNewValue() != null ? e.getNewValue().toString() : "";
        this.setField(e.getPropertyName(), newValue);
    }

    public void updateField(Object source) {
        this.storeFieldAction.actionPerformed(new ActionEvent(source, 0, ""));
    }

    public void setMovingToDifferentEntry() {
        this.movingToDifferentEntry = true;
    }

    private void warnDuplicateBibtexkey() {
        this.panel.output(Globals.lang("Warning") + ": " + Globals.lang("Duplicate BibTeX key."));
        if (this.prefs.getBoolean("dialogWarningForDuplicateKey")) {
            CheckBoxMessage jcb = new CheckBoxMessage(Globals.lang("Warning") + ": " + Globals.lang("Duplicate BibTeX key. Grouping may not work for this entry."), Globals.lang("Disable this warning dialog"), false);
            JOptionPane.showMessageDialog(this.frame, jcb, Globals.lang("Warning"), 2);
            if (jcb.isSelected()) {
                this.prefs.putBoolean("dialogWarningForDuplicateKey", false);
            }
        }
    }

    private void warnEmptyBibtexkey() {
        this.panel.output(Globals.lang("Warning") + ": " + Globals.lang("Empty BibTeX key."));
        if (this.prefs.getBoolean("dialogWarningForEmptyKey")) {
            CheckBoxMessage jcb = new CheckBoxMessage(Globals.lang("Warning") + ": " + Globals.lang("Empty BibTeX key. Grouping may not work for this entry."), Globals.lang("Disable this warning dialog"), false);
            JOptionPane.showMessageDialog(this.frame, jcb, Globals.lang("Warning"), 2);
            if (jcb.isSelected()) {
                this.prefs.putBoolean("dialogWarningForEmptyKey", false);
            }
        }
    }

    class AutoSetFileAction
    extends AbstractAction {
        public AutoSetFileAction() {
            this.putValue("SmallIcon", GUIGlobals.getImage("autoGroup"));
            this.putValue("ShortDescription", Globals.lang("Automatically set file links for this entry") + " (Alt-F)");
        }

        public void actionPerformed(ActionEvent event) {
            JDialog diag = new JDialog((Frame)EntryEditor.this.frame, true);
            final FileListTableModel tableModel = new FileListTableModel();
            tableModel.setContent(EntryEditor.this.entry.getField("file"));
            FileListEditor.autoSetLinks(EntryEditor.this.entry, tableModel, EntryEditor.this.panel.metaData(), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getID() > 0) {
                        EntryEditor.this.entry.setField("file", tableModel.getStringRepresentation());
                        EntryEditor.this.frame.output(Globals.lang("Finished autosetting external links."));
                    } else {
                        EntryEditor.this.frame.output(Globals.lang("Finished autosetting external links.") + " " + Globals.lang("No files found."));
                    }
                }
            }, diag);
        }
    }

    class ChangeTypeAction
    extends AbstractAction {
        BibtexEntryType type;
        BasePanel panel;

        public ChangeTypeAction(BibtexEntryType type, BasePanel bp) {
            super(type.getName());
            this.type = type;
            this.panel = bp;
        }

        public void actionPerformed(ActionEvent evt) {
            this.panel.changeType(EntryEditor.this.entry, this.type);
        }
    }

    class ExternalViewerListener
    extends MouseAdapter {
        ExternalViewerListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                FieldTextArea tf = (FieldTextArea)evt.getSource();
                if (tf.getText().equals("")) {
                    return;
                }
                tf.selectAll();
                String link = tf.getText();
                try {
                    Util.openExternalViewer(EntryEditor.this.panel.metaData(), link, tf.getFieldName());
                }
                catch (IOException ex) {
                    System.err.println("Error opening file.");
                }
            }
        }
    }

    class SaveDatabaseAction
    extends AbstractAction {
        public SaveDatabaseAction() {
            super("Save database");
        }

        public void actionPerformed(ActionEvent e) {
            Object activeTab = EntryEditor.this.tabs.get(EntryEditor.this.tabbed.getSelectedIndex());
            if (activeTab instanceof EntryEditorTab) {
                EntryEditorTab fp = (EntryEditorTab)activeTab;
                FieldEditor fe = fp.getActive();
                fe.clearAutoCompleteSuggestion();
                EntryEditor.this.updateField(fe);
            } else {
                EntryEditor.this.updateField(activeTab);
            }
            try {
                EntryEditor.this.panel.runCommand("save");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Undo", GUIGlobals.getImage("redo"));
            this.putValue("ShortDescription", "Redo");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                EntryEditor.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", GUIGlobals.getImage("undo"));
            this.putValue("ShortDescription", "Undo");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                EntryEditor.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class GenerateKeyAction
    extends AbstractAction {
        JabRefFrame parent;
        BibtexEntry selectedEntry;

        public GenerateKeyAction(JabRefFrame parentFrame) {
            super(Globals.lang("Generate BibTeX key"), GUIGlobals.getImage("makeKey"));
            this.parent = parentFrame;
            this.putValue("ShortDescription", Globals.lang("Generate BibTeX key"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                EntryEditor.this.storeCurrentEdit();
                String oldValue = EntryEditor.this.entry.getField("bibtexkey");
                LabelPatternUtil.makeLabel(EntryEditor.this.prefs.getKeyPattern(), EntryEditor.this.panel.database, EntryEditor.this.entry);
                EntryEditor.this.panel.undoManager.addEdit(new UndoableKeyChange(EntryEditor.this.panel.database, EntryEditor.this.entry.getId(), oldValue, EntryEditor.this.entry.getField("bibtexkey")));
                String bibtexKeyData = EntryEditor.this.entry.getField("bibtexkey");
                EntryEditor.this.setField("bibtexkey", bibtexKeyData);
                EntryEditor.this.updateSource();
                EntryEditor.this.panel.markBaseChanged();
            }
            catch (Throwable t) {
                System.err.println("error setting key: " + t);
            }
        }
    }

    class PrevEntryAction
    extends AbstractAction {
        public PrevEntryAction() {
            super(Globals.lang("Previous entry"), GUIGlobals.getImage("up"));
            this.putValue("ShortDescription", Globals.lang("Previous entry"));
        }

        public void actionPerformed(ActionEvent e) {
            int thisRow = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
            int newRow = -1;
            if (thisRow - 1 >= 0) {
                newRow = thisRow - 1;
            } else if (thisRow != EntryEditor.this.panel.database.getEntryCount() - 1) {
                newRow = EntryEditor.this.panel.database.getEntryCount() - 1;
            } else {
                return;
            }
            EntryEditor.this.scrollTo(newRow);
            EntryEditor.this.panel.mainTable.setRowSelectionInterval(newRow, newRow);
        }
    }

    class NextEntryAction
    extends AbstractAction {
        public NextEntryAction() {
            super(Globals.lang("Next entry"), GUIGlobals.getImage("down"));
            this.putValue("ShortDescription", Globals.lang("Next entry"));
        }

        public void actionPerformed(ActionEvent e) {
            int thisRow = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
            int newRow = -1;
            if (thisRow + 1 < EntryEditor.this.panel.database.getEntryCount()) {
                newRow = thisRow + 1;
            } else if (thisRow > 0) {
                newRow = 0;
            } else {
                return;
            }
            EntryEditor.this.scrollTo(newRow);
            EntryEditor.this.panel.mainTable.setRowSelectionInterval(newRow, newRow);
        }
    }

    class SwitchRightAction
    extends AbstractAction {
        public SwitchRightAction() {
            super("Switch to the panel to the right");
        }

        public void actionPerformed(ActionEvent e) {
            int i = EntryEditor.this.tabbed.getSelectedIndex();
            EntryEditor.this.tabbed.setSelectedIndex(i < EntryEditor.this.tabbed.getTabCount() - 1 ? i + 1 : 0);
            EntryEditor.this.activateVisible();
        }
    }

    class SwitchLeftAction
    extends AbstractAction {
        public SwitchLeftAction() {
            super("Switch to the panel to the left");
        }

        public void actionPerformed(ActionEvent e) {
            int i = EntryEditor.this.tabbed.getSelectedIndex();
            EntryEditor.this.tabbed.setSelectedIndex(i > 0 ? i - 1 : EntryEditor.this.tabbed.getTabCount() - 1);
            EntryEditor.this.activateVisible();
        }
    }

    public class StoreFieldAction
    extends AbstractAction {
        public StoreFieldAction() {
            super("Store field value");
            this.putValue("ShortDescription", "Store field value");
        }

        public void actionPerformed(ActionEvent e) {
            boolean accepted;
            boolean movingAway = EntryEditor.this.movingToDifferentEntry;
            EntryEditor.this.movingToDifferentEntry = false;
            if (e.getSource() instanceof FieldTextField) {
                FieldTextField fe = (FieldTextField)e.getSource();
                String oldValue = EntryEditor.this.entry.getCiteKey();
                String newValue = fe.getText();
                if (newValue.equals("")) {
                    newValue = null;
                }
                if (oldValue == null && newValue == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
                    return;
                }
                String cleaned = Util.checkLegalKey(newValue);
                if (cleaned != null && !cleaned.equals(newValue)) {
                    JOptionPane.showMessageDialog(EntryEditor.this.frame, Globals.lang("Invalid BibTeX key"), Globals.lang("Error setting field"), 0);
                    fe.setInvalidBackgroundColor();
                    return;
                }
                fe.setValidBackgroundColor();
                boolean isDuplicate = EntryEditor.this.panel.database.setCiteKeyForEntry(EntryEditor.this.entry.getId(), newValue);
                if (newValue != null) {
                    if (isDuplicate) {
                        EntryEditor.this.warnDuplicateBibtexkey();
                    } else {
                        EntryEditor.this.panel.output(Globals.lang("BibTeX key is unique."));
                    }
                } else {
                    EntryEditor.this.warnEmptyBibtexkey();
                }
                EntryEditor.this.panel.undoManager.addEdit(new UndoableKeyChange(EntryEditor.this.panel.database, EntryEditor.this.entry.getId(), oldValue, newValue));
                if (newValue != null && newValue.length() > 0) {
                    fe.setValidBackgroundColor();
                } else {
                    fe.setValidBackgroundColor();
                }
                if (fe.getTextComponent().hasFocus()) {
                    fe.setActiveBackgroundColor();
                }
                EntryEditor.this.updateSource();
                EntryEditor.this.panel.markBaseChanged();
            } else if (e.getSource() instanceof FieldEditor) {
                String toSet = null;
                FieldEditor fe = (FieldEditor)e.getSource();
                String currentText = fe.getText();
                String trim = currentText.trim();
                if (trim.length() > 0) {
                    toSet = trim;
                }
                boolean set = toSet == null ? EntryEditor.this.entry.getField(fe.getFieldName()) != null : EntryEditor.this.entry.getField(fe.getFieldName()) == null || !toSet.equals(EntryEditor.this.entry.getField(fe.getFieldName()).toString());
                if (set) {
                    try {
                        if (toSet != null) {
                            new LatexFieldFormatter().format(toSet, fe.getFieldName());
                        }
                        String oldValue = EntryEditor.this.entry.getField(fe.getFieldName());
                        if (toSet != null) {
                            EntryEditor.this.entry.setField(fe.getFieldName(), toSet);
                        } else {
                            EntryEditor.this.entry.clearField(fe.getFieldName());
                        }
                        if (toSet != null && toSet.length() > 0) {
                            fe.setValidBackgroundColor();
                        } else {
                            fe.setValidBackgroundColor();
                        }
                        AbstractAutoCompleter aComp = EntryEditor.this.panel.getAutoCompleter(fe.getFieldName());
                        if (aComp != null) {
                            aComp.addBibtexEntry(EntryEditor.this.entry);
                        }
                        EntryEditor.this.panel.undoManager.addEdit(new UndoableFieldChange(EntryEditor.this.entry, fe.getFieldName(), oldValue, toSet));
                        EntryEditor.this.updateSource();
                        EntryEditor.this.panel.markBaseChanged();
                    }
                    catch (IllegalArgumentException ex) {
                        JOptionPane.showMessageDialog(EntryEditor.this.frame, Globals.lang("Error") + ": " + ex.getMessage(), Globals.lang("Error setting field"), 0);
                        fe.setInvalidBackgroundColor();
                    }
                } else {
                    fe.setValidBackgroundColor();
                }
                if (fe.getTextComponent().hasFocus()) {
                    fe.setBackground(GUIGlobals.activeEditor);
                }
            } else if (!EntryEditor.this.source.isEditable() || EntryEditor.this.source.getText().equals(EntryEditor.this.lastSourceStringAccepted) || (accepted = EntryEditor.this.storeSource(true))) {
                // empty if block
            }
            if (!movingAway && EntryEditor.this.isShowing()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int row = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
                        if (row >= 0) {
                            EntryEditor.this.panel.mainTable.ensureVisible(row);
                        }
                    }
                });
            }
        }
    }

    class CopyKeyAction
    extends AbstractAction {
        public CopyKeyAction() {
            super("Copy BibTeX key to clipboard");
            this.putValue("ShortDescription", "Copy BibTeX key to clipboard (Ctrl-K)");
        }

        public void actionPerformed(ActionEvent e) {
            String s = EntryEditor.this.entry.getField("bibtexkey");
            StringSelection ss = new StringSelection(s);
            if (s != null) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close window"), GUIGlobals.getImage("close"));
            this.putValue("ShortDescription", Globals.lang("Close window"));
        }

        public void actionPerformed(ActionEvent e) {
            if (EntryEditor.this.tabbed.getSelectedComponent() == EntryEditor.this.srcPanel) {
                EntryEditor.this.updateField(EntryEditor.this.source);
                if (EntryEditor.this.lastSourceAccepted) {
                    EntryEditor.this.panel.entryEditorClosing(EntryEditor.this);
                }
            } else {
                EntryEditor.this.panel.entryEditorClosing(EntryEditor.this);
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(Globals.lang("Delete"), GUIGlobals.getImage("delete"));
            this.putValue("ShortDescription", Globals.lang("Delete entry"));
        }

        public void actionPerformed(ActionEvent e) {
            boolean goOn = EntryEditor.this.panel.showDeleteConfirmationDialog(1);
            if (!goOn) {
                return;
            }
            EntryEditor.this.panel.entryEditorClosing(EntryEditor.this);
            EntryEditor.this.panel.database.removeEntry(EntryEditor.this.entry.getId());
            EntryEditor.this.panel.markBaseChanged();
            EntryEditor.this.panel.undoManager.addEdit(new UndoableRemoveEntry(EntryEditor.this.panel.database, EntryEditor.this.entry, EntryEditor.this.panel));
            EntryEditor.this.panel.output(Globals.lang("Deleted") + " " + Globals.lang("entry"));
        }
    }

    class TabListener
    implements ChangeListener {
        TabListener() {
        }

        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EntryEditor.this.activateVisible();
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object activeTab = EntryEditor.this.tabs.get(EntryEditor.this.tabbed.getSelectedIndex());
                    if (activeTab instanceof EntryEditorTab) {
                        ((EntryEditorTab)activeTab).updateAll();
                    }
                }
            });
        }
    }

    class FieldListener
    extends FocusAdapter {
        FieldListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                EntryEditor.this.updateField(e.getSource());
            }
        }
    }

    private class TypeLabel
    extends JLabel {
        public TypeLabel(String type) {
            super(type + " ");
            this.setUI(new VerticalLabelUI(false));
            this.setForeground(GUIGlobals.entryEditorLabelColor);
            this.setHorizontalAlignment(4);
            this.setFont(GUIGlobals.typeNameFont);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    boolean ctrlClick = EntryEditor.this.prefs.getBoolean("ctrlClick");
                    if (e.getButton() == 3 || ctrlClick && e.getButton() == 1 && e.isControlDown()) {
                        JPopupMenu typeMenu = new JPopupMenu();
                        for (String s : BibtexEntryType.ALL_TYPES.keySet()) {
                            typeMenu.add(new ChangeTypeAction(BibtexEntryType.getType(s), EntryEditor.this.panel));
                        }
                        typeMenu.show(EntryEditor.this.ths, e.getX(), e.getY());
                    }
                }
            });
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g2);
        }
    }
}

