/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.io.IOException;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.Grammar;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Target {
    protected String[] targetCharValueEscape;

    protected void genRecognizerFile(Tool tool, CodeGenerator generator, Grammar grammar, StringTemplate outputFileST) throws IOException {
        String fileName = generator.getRecognizerFileName();
        generator.write(outputFileST, fileName);
    }

    protected void genRecognizerHeaderFile(Tool tool, CodeGenerator generator, Grammar grammar, StringTemplate headerFileST) throws IOException {
    }

    protected void performGrammarAnalysis(CodeGenerator generator, Grammar grammar) {
        grammar.createNFAs();
        grammar.createLookaheadDFAs();
    }

    public boolean isValidActionScope(int grammarType, String scope) {
        switch (grammarType) {
            case 1: {
                if (!scope.equals("lexer")) break;
                return true;
            }
            case 2: {
                if (!scope.equals("parser")) break;
                return true;
            }
            case 4: {
                if (scope.equals("parser")) {
                    return true;
                }
                if (!scope.equals("lexer")) break;
                return true;
            }
            case 3: {
                if (!scope.equals("treeparser")) break;
                return true;
            }
        }
        return false;
    }

    public String getTokenTypeAsTargetLabel(CodeGenerator generator, int ttype) {
        String name = generator.grammar.getTokenDisplayName(ttype);
        if (name.charAt(0) == '\'') {
            return String.valueOf(ttype);
        }
        return name;
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator generator, String literal) {
        StringBuffer buf = new StringBuffer();
        buf.append('\'');
        int c = Grammar.getCharValueFromGrammarCharLiteral(literal);
        if (c < 0) {
            return "'\u0000'";
        }
        if (c < this.targetCharValueEscape.length && this.targetCharValueEscape[c] != null) {
            buf.append(this.targetCharValueEscape[c]);
        } else if (Character.UnicodeBlock.of((char)c) == Character.UnicodeBlock.BASIC_LATIN && !Character.isISOControl((char)c)) {
            buf.append((char)c);
        } else {
            String hex = Integer.toHexString(c | 0x10000).toUpperCase().substring(1, 5);
            buf.append("\\u");
            buf.append(hex);
        }
        buf.append('\'');
        return buf.toString();
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal) {
        literal = Utils.replace(literal, "\"", "\\\"");
        StringBuffer buf = new StringBuffer(literal);
        buf.setCharAt(0, '\"');
        buf.setCharAt(literal.length() - 1, '\"');
        return buf.toString();
    }

    public String getTargetStringLiteralFromString(String s, boolean quoted) {
        if (s == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (quoted) {
            buf.append('\"');
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c != '\'' && c < this.targetCharValueEscape.length && this.targetCharValueEscape[c] != null) {
                buf.append(this.targetCharValueEscape[c]);
            } else {
                buf.append(c);
            }
            ++i;
        }
        if (quoted) {
            buf.append('\"');
        }
        return buf.toString();
    }

    public String getTargetStringLiteralFromString(String s) {
        return this.getTargetStringLiteralFromString(s, false);
    }

    public String getTarget64BitStringFromValue(long word) {
        int numHexDigits = 16;
        StringBuffer buf = new StringBuffer(numHexDigits + 2);
        buf.append("0x");
        String digits = Long.toHexString(word);
        digits = digits.toUpperCase();
        int padding = numHexDigits - digits.length();
        int i = 1;
        while (i <= padding) {
            buf.append('0');
            ++i;
        }
        buf.append(digits);
        return buf.toString();
    }

    public int getMaxCharValue(CodeGenerator generator) {
        return 65534;
    }

    private final /* synthetic */ void this() {
        this.targetCharValueEscape = new String[255];
    }

    public Target() {
        this.this();
        this.targetCharValueEscape[10] = "\\n";
        this.targetCharValueEscape[13] = "\\r";
        this.targetCharValueEscape[9] = "\\t";
        this.targetCharValueEscape[8] = "\\b";
        this.targetCharValueEscape[12] = "\\f";
        this.targetCharValueEscape[92] = "\\\\";
        this.targetCharValueEscape[39] = "\\'";
        this.targetCharValueEscape[34] = "\\\"";
    }
}

