/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OvidImporter
extends ImportFormat {
    public static Pattern ovid_src_pat = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+)\\(([\\w\\-]+)\\):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    public static Pattern ovid_src_pat_no_issue = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    public static Pattern ovid_src_pat_2 = Pattern.compile("([ \\w&\\-,]+)\\. Vol ([0-9]+)\\(([\\w\\-]+)\\) ([A-Za-z]+) ([0-9][0-9][0-9][0-9]), ([0-9]+\\-?[0-9]+)");
    public static Pattern incollection_pat = Pattern.compile("(.+)\\(([0-9][0-9][0-9][0-9])\\)\\. ([ \\w&\\-,:]+)\\.[ ]+\\(pp. ([0-9]+\\-?[0-9]+?)\\).[A-Za-z0-9, ]+pp\\. ([\\w, ]+): ([\\w, ]+)");
    public static Pattern book_pat = Pattern.compile("\\(([0-9][0-9][0-9][0-9])\\)\\. [A-Za-z, ]+([0-9]+) pp\\. ([\\w, ]+): ([\\w, ]+)");
    static final Pattern ovidPattern = Pattern.compile("<[0-9]+>");

    @Override
    public String getFormatName() {
        return "Ovid";
    }

    @Override
    public String getCLIId() {
        return "ovid";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        for (int i = 0; (str = in.readLine()) != null && i < 50; ++i) {
            if (!ovidPattern.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream) throws IOException {
        String line;
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        while ((line = in.readLine()) != null) {
            if (line.length() > 0 && line.charAt(0) != ' ') {
                sb.append("__NEWFIELD__");
            }
            sb.append(line);
            sb.append('\n');
        }
        String[] items = sb.toString().split("<[0-9]+>");
        for (int i = 1; i < items.length; ++i) {
            HashMap<String, String> h = new HashMap<String, String>();
            String[] fields = items[i].split("__NEWFIELD__");
            for (int j = 0; j < fields.length; ++j) {
                boolean isAuthor;
                int linebreak = fields[j].indexOf(10);
                String fieldName = fields[j].substring(0, linebreak).trim();
                String content = fields[j].substring(linebreak).trim();
                boolean bl = isAuthor = fieldName.indexOf("Author") == 0 && fieldName.indexOf("Author Keywords") == -1 && fieldName.indexOf("Author e-mail") == -1;
                if (!isAuthor && content.endsWith(".")) {
                    content = content.substring(0, content.length() - 1);
                }
                if (isAuthor) {
                    h.put("author", content);
                    continue;
                }
                if (fieldName.indexOf("Title") == 0) {
                    if ((content = content.replaceAll("\\[.+\\]", "").trim()).endsWith(".")) {
                        content = content.substring(0, content.length() - 1);
                    }
                    h.put("title", content);
                    continue;
                }
                if (fieldName.indexOf("Chapter Title") == 0) {
                    h.put("chaptertitle", content);
                    continue;
                }
                if (fieldName.indexOf("Source") == 0) {
                    Matcher matcher = ovid_src_pat.matcher(content);
                    if (matcher.find()) {
                        h.put("journal", matcher.group(1));
                        h.put("volume", matcher.group(2));
                        h.put("issue", matcher.group(3));
                        h.put("pages", matcher.group(4));
                        h.put("year", matcher.group(5));
                    } else {
                        matcher = ovid_src_pat_no_issue.matcher(content);
                        if (matcher.find()) {
                            h.put("journal", matcher.group(1));
                            h.put("volume", matcher.group(2));
                            h.put("pages", matcher.group(3));
                            h.put("year", matcher.group(4));
                        } else {
                            matcher = ovid_src_pat_2.matcher(content);
                            if (matcher.find()) {
                                h.put("journal", matcher.group(1));
                                h.put("volume", matcher.group(2));
                                h.put("issue", matcher.group(3));
                                h.put("month", matcher.group(4));
                                h.put("year", matcher.group(5));
                                h.put("pages", matcher.group(6));
                            } else {
                                matcher = incollection_pat.matcher(content);
                                if (matcher.find()) {
                                    h.put("editor", matcher.group(1).replaceAll(" \\(Ed\\)", ""));
                                    h.put("year", matcher.group(2));
                                    h.put("booktitle", matcher.group(3));
                                    h.put("pages", matcher.group(4));
                                    h.put("address", matcher.group(5));
                                    h.put("publisher", matcher.group(6));
                                } else {
                                    matcher = book_pat.matcher(content);
                                    if (matcher.find()) {
                                        h.put("year", matcher.group(1));
                                        h.put("pages", matcher.group(2));
                                        h.put("address", matcher.group(3));
                                        h.put("publisher", matcher.group(4));
                                    }
                                }
                            }
                        }
                    }
                    if (h.get("pages") == null) continue;
                    h.put("pages", h.get("pages").replaceAll("-", "--"));
                    continue;
                }
                if (fieldName.equals("Abstract")) {
                    h.put("abstract", content);
                    continue;
                }
                if (!fieldName.equals("Publication Type")) continue;
                if (content.indexOf("Book") >= 0) {
                    h.put("entrytype", "book");
                    continue;
                }
                if (content.indexOf("Journal") >= 0) {
                    h.put("entrytype", "article");
                    continue;
                }
                if (content.indexOf("Conference Paper") < 0) continue;
                h.put("entrytype", "inproceedings");
            }
            String auth = (String)h.get("author");
            if (auth != null && auth.indexOf(" [Ed]") >= 0) {
                h.remove("author");
                h.put("editor", auth.replaceAll(" \\[Ed\\]", ""));
            }
            if ((auth = (String)h.get("author")) != null) {
                h.put("author", this.fixNames(auth));
            }
            if ((auth = (String)h.get("editor")) != null) {
                h.put("editor", this.fixNames(auth));
            }
            String entryType = h.containsKey("entrytype") ? (String)h.get("entrytype") : "other";
            h.remove("entrytype");
            if (entryType.equals("book") && h.containsKey("chaptertitle")) {
                entryType = "incollection";
                h.put("title", h.remove("chaptertitle"));
            }
            BibtexEntry b = new BibtexEntry(Util.createNeutralId(), Globals.getEntryType(entryType));
            b.setField(h);
            bibitems.add(b);
        }
        return bibitems;
    }

    private String fixNames(String content) {
        String names;
        if (content.indexOf(";") > 0) {
            names = content.replaceAll("[^\\.A-Za-z,;\\- ]", "").replaceAll(";", " and");
        } else if (content.indexOf("  ") > 0) {
            String[] sNames = content.split("  ");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sNames.length; ++i) {
                if (i > 0) {
                    sb.append(" and ");
                }
                sb.append(sNames[i].replaceFirst(" ", ", "));
            }
            names = sb.toString();
        } else {
            names = content;
        }
        return AuthorList.fixAuthor_lastNameFirst(names);
    }
}

