/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportInspectionCommandLine
implements ImportInspector {
    List<BibtexEntry> entries = new LinkedList<BibtexEntry>();
    OutputPrinter status = new OutputPrinter(){

        public void setStatus(String s) {
            System.out.println(s);
        }

        public void showMessage(Object message, String title, int msgType) {
            System.out.println(title + ": " + message);
        }

        public void showMessage(String message) {
            System.out.println(message);
        }
    };

    @Override
    public void addEntry(BibtexEntry entry) {
        this.entries.add(entry);
    }

    @Override
    public void setProgress(int current, int max) {
        this.status.setStatus(Globals.lang("Progress: %0 of %1", String.valueOf(current), String.valueOf(max)));
    }

    public Collection<BibtexEntry> query(String query, EntryFetcher fetcher) {
        this.entries.clear();
        if (fetcher.processQuery(query, this, this.status)) {
            return this.entries;
        }
        return null;
    }

    @Override
    public void toFront() {
    }
}

