/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRule;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.UnsupportedVersionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllEntriesGroup
extends AbstractGroup
implements SearchRule {
    public static final String ID = "AllEntriesGroup:";

    public AllEntriesGroup() {
        super(Globals.lang("All Entries"), 0);
    }

    public static AbstractGroup fromString(String s, BibtexDatabase db, int version) throws Exception {
        if (!s.startsWith(ID)) {
            throw new Exception("Internal error: AllEntriesGroup cannot be created from \"" + s + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        switch (version) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new AllEntriesGroup();
            }
        }
        throw new UnsupportedVersionException("AllEntriesGroup", version);
    }

    @Override
    public SearchRule getSearchRule() {
        return this;
    }

    @Override
    public boolean supportsAdd() {
        return false;
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public AbstractUndoableEdit add(BibtexEntry[] entries) {
        return null;
    }

    @Override
    public AbstractUndoableEdit remove(BibtexEntry[] entries) {
        return null;
    }

    @Override
    public boolean contains(Map<String, String> searchOptions, BibtexEntry entry) {
        return true;
    }

    @Override
    public AbstractGroup deepCopy() {
        return new AllEntriesGroup();
    }

    @Override
    public int applyRule(Map<String, String> searchStrings, BibtexEntry bibtexEntry) {
        return 1;
    }

    public boolean equals(Object o) {
        return o instanceof AllEntriesGroup;
    }

    public String toString() {
        return ID;
    }

    @Override
    public boolean contains(BibtexEntry entry) {
        return true;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String getDescription() {
        return "This group contains all entries. It cannot be edited or removed.";
    }

    @Override
    public String getShortDescription() {
        return Globals.lang("<b>All Entries</b> (this group cannot be edited or removed)");
    }

    @Override
    public String getTypeId() {
        return ID;
    }
}

