/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.export.ExportFileFilter;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.IExportFormat;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.export.VerifyingWriter;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportFormat
implements IExportFormat {
    String displayName;
    String consoleName;
    String lfFileName;
    String directory;
    String extension;
    String encoding = null;
    FileFilter fileFilter;
    boolean customExport = false;

    public ExportFormat(String displayName, String consoleName, String lfFileName, String directory, String extension) {
        this.displayName = displayName;
        this.consoleName = consoleName;
        this.lfFileName = lfFileName;
        this.directory = directory;
        this.extension = extension;
    }

    protected ExportFormat() {
    }

    public void setCustomExport(boolean custom) {
        this.customExport = custom;
    }

    @Override
    public String getConsoleName() {
        return this.consoleName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected Reader getReader(String filename) throws IOException {
        String dir = this.customExport ? "" : "/resource/layout/" + (this.directory == null ? "" : this.directory + "/");
        return FileActions.getReader(dir + filename);
    }

    @Override
    public void performExport(BibtexDatabase database, MetaData metaData, String file, String encoding, Set<String> entryIds) throws Exception {
        File outFile = new File(file);
        SaveSession ss = null;
        if (this.encoding != null) {
            try {
                ss = this.getSaveSession(this.encoding, outFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (ss == null) {
            ss = this.getSaveSession(encoding, outFile);
        }
        VerifyingWriter ps = ss.getWriter();
        Layout beginLayout = null;
        Reader reader = null;
        HashMap<String, String> customNameFormatters = this.readFormatterFile(this.lfFileName);
        Globals.prefs.customExportNameFormatters = customNameFormatters;
        ArrayList<String> missingFormatters = new ArrayList<String>(1);
        try {
            reader = this.getReader(this.lfFileName + ".begin.layout");
            LayoutHelper layoutHelper = new LayoutHelper(reader);
            beginLayout = layoutHelper.getLayoutFromText("net.sf.jabref.export.layout.format.");
            reader.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (beginLayout != null) {
            ps.write(beginLayout.doLayout(database, encoding));
            missingFormatters.addAll(beginLayout.getMissingFormatters());
        }
        List<BibtexEntry> sorted = FileActions.getSortedEntries(database, entryIds, false);
        reader = this.getReader(this.lfFileName + ".layout");
        LayoutHelper layoutHelper = new LayoutHelper(reader);
        Layout defLayout = layoutHelper.getLayoutFromText("net.sf.jabref.export.layout.format.");
        reader.close();
        if (defLayout != null) {
            missingFormatters.addAll(defLayout.getMissingFormatters());
            System.out.println(defLayout.getMissingFormatters());
        }
        HashMap<String, Layout> layouts = new HashMap<String, Layout>();
        ExportFormats.entryNumber = 0;
        for (BibtexEntry entry : sorted) {
            Layout layout;
            ++ExportFormats.entryNumber;
            String type = entry.getType().getName().toLowerCase();
            if (layouts.containsKey(type)) {
                layout = (Layout)layouts.get(type);
            } else {
                try {
                    reader = this.getReader(this.lfFileName + "." + type + ".layout");
                    layoutHelper = new LayoutHelper(reader);
                    layout = layoutHelper.getLayoutFromText("net.sf.jabref.export.layout.format.");
                    layouts.put(type, layout);
                    reader.close();
                    if (layout != null) {
                        missingFormatters.addAll(layout.getMissingFormatters());
                    }
                }
                catch (IOException ex) {
                    layout = defLayout;
                }
            }
            ps.write(layout.doLayout(entry, database));
        }
        Layout endLayout = null;
        try {
            reader = this.getReader(this.lfFileName + ".end.layout");
            layoutHelper = new LayoutHelper(reader);
            endLayout = layoutHelper.getLayoutFromText("net.sf.jabref.export.layout.format.");
            reader.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (endLayout != null) {
            ps.write(endLayout.doLayout(database, encoding));
            missingFormatters.addAll(endLayout.getMissingFormatters());
        }
        Globals.prefs.customExportNameFormatters = null;
        if (missingFormatters.size() > 0) {
            StringBuilder sb = new StringBuilder("The following formatters could not be found").append(": ");
            Iterator i = missingFormatters.iterator();
            while (i.hasNext()) {
                sb.append((String)i.next());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            System.err.println(sb.toString());
        }
        this.finalizeSaveSession(ss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> readFormatterFile(String lfFileName) {
        HashMap<String, String> formatters = new HashMap<String, String>();
        File formatterFile = new File(lfFileName + ".formatters");
        if (formatterFile.exists()) {
            FileReader in = null;
            try {
                in = new FileReader(formatterFile);
                if (in != null) {
                    int c;
                    StringBuilder sb = new StringBuilder();
                    while ((c = ((Reader)in).read()) != -1) {
                        sb.append((char)c);
                    }
                    String[] lines = sb.toString().split("\n");
                    for (int i = 0; i < lines.length; ++i) {
                        int index;
                        String line = lines[i].trim();
                        if (line.length() == 0 || (index = line.indexOf(":")) <= 0 || index + 1 >= line.length()) continue;
                        String formatterName = line.substring(0, index);
                        String contents = line.substring(index + 1);
                        formatters.put(formatterName, contents);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        ((Reader)in).close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return formatters;
    }

    protected SaveSession getSaveSession(String encoding, File outFile) throws IOException {
        return new SaveSession(outFile, encoding, false);
    }

    @Override
    public FileFilter getFileFilter() {
        if (this.fileFilter == null) {
            this.fileFilter = new ExportFileFilter(this, this.extension);
        }
        return this.fileFilter;
    }

    public void finalizeSaveSession(SaveSession ss) throws Exception {
        ss.getWriter().flush();
        ss.getWriter().close();
        if (!ss.getWriter().couldEncodeAll()) {
            System.err.println("Could not encode...");
        }
        ss.commit();
    }
}

