/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.autocompleter;

import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jabref.BibtexEntry;

public abstract class AbstractAutoCompleter {
    public static final int SHORTEST_TO_COMPLETE = 2;
    public static final int SHORTEST_WORD = 4;
    private TreeSet<String> _index = new TreeSet();

    public abstract void addBibtexEntry(BibtexEntry var1);

    public abstract boolean isSingleUnitField();

    public String[] complete(String str) {
        if (AbstractAutoCompleter.stringMinLength(str)) {
            return null;
        }
        String ender = AbstractAutoCompleter.incrementLastCharacter(str);
        SortedSet<String> subset = this._index.subSet(str, ender);
        return subset.toArray(new String[0]);
    }

    private static String incrementLastCharacter(String str) {
        char lastChar = str.charAt(str.length() - 1);
        String ender = str.substring(0, str.length() - 1) + Character.toString((char)(lastChar + '\u0001'));
        return ender;
    }

    private static boolean stringMinLength(String str) {
        return str.length() < 2;
    }

    public void addWordToIndex(String word) {
        if (word.length() >= 4) {
            this._index.add(word);
        }
    }

    public boolean indexContainsWord(String word) {
        return this._index.contains(word);
    }
}

