/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.HelpDialog;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.Util;
import net.sf.jabref.labelPattern.LabelPattern;
import net.sf.jabref.labelPattern.LabelPatternUtil;

public class TabLabelPattern
extends JPanel
implements PrefsTab {
    private String def = Globals.lang("Default");
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints con = new GridBagConstraints();
    private HashMap<String, JTextField> textFields = new HashMap();
    private JabRefPreferences _prefs;
    private LabelPattern _keypatterns = null;
    private JCheckBox dontOverwrite = new JCheckBox(Globals.lang("Do not overwrite existing keys"));
    private JCheckBox warnBeforeOverwriting = new JCheckBox(Globals.lang("Warn before overwriting existing keys"));
    private JCheckBox generateOnSave = new JCheckBox(Globals.lang("Generate keys before saving (for entries without a key)"));
    private JCheckBox autoGenerateOnImport = new JCheckBox(Globals.lang("Generate keys for imported entries"));
    private JLabel lblEntryType;
    private JLabel lblKeyPattern;
    private JTextField defaultPat = new JTextField();
    private JTextField KeyPatternRegex = new JTextField(20);
    private JTextField KeyPatternReplacement = new JTextField(20);
    private JButton btnDefaultAll;
    private JButton btnDefault;
    private HelpAction help;

    public TabLabelPattern(JabRefPreferences prefs, HelpDialog helpDiag) {
        this._prefs = prefs;
        this.help = new HelpAction(helpDiag, GUIGlobals.labelPatternHelp, "Help on key patterns");
        this.buildGUI();
    }

    public void storeSettings() {
        Globals.prefs.put("defaultLabelPattern", this.defaultPat.getText());
        Globals.prefs.putBoolean("warnBeforeOverwritingKey", this.warnBeforeOverwriting.isSelected());
        Globals.prefs.putBoolean("avoidOverwritingKey", this.dontOverwrite.isSelected());
        Globals.prefs.put("KeyPatternRegex", this.KeyPatternRegex.getText());
        Globals.prefs.put("KeyPatternReplacement", this.KeyPatternReplacement.getText());
        Globals.prefs.putBoolean("generateKeysAfterInspection", this.autoGenerateOnImport.isSelected());
        Globals.prefs.putBoolean("generateKeysBeforeSaving", this.generateOnSave.isSelected());
        LabelPatternUtil.updateDefaultPattern();
        LabelPattern defKeyPattern = this._keypatterns.getParent();
        this._keypatterns = new LabelPattern(defKeyPattern);
        for (String s : this.textFields.keySet()) {
            String text = this.textFields.get(s).getText();
            if ("".equals(text.trim())) continue;
            this._keypatterns.addLabelPattern(s, text);
        }
        this._prefs.putKeyPattern(this._keypatterns);
    }

    private JTextField addEntryType(Container c, String name, int y) {
        JLabel lab = new JLabel(Util.nCase(name));
        name = name.toLowerCase();
        this.con.gridx = 0;
        this.con.gridy = y;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 17;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(lab, this.con);
        c.add(lab);
        JTextField tf = new JTextField();
        tf.setColumns(15);
        this.con.gridx = 1;
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(tf, this.con);
        c.add(tf);
        JButton but = new JButton(this.def);
        this.con.gridx = 2;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(but, this.con);
        but.setActionCommand(name);
        but.addActionListener(new buttonHandler());
        c.add(but);
        return tf;
    }

    private void setValue(JTextField tf, String fieldName) {
        if (this._keypatterns.isDefaultValue(fieldName)) {
            tf.setText("");
        } else {
            tf.setText(this._keypatterns.getValue(fieldName).get(0).toString());
        }
    }

    private void buildGUI() {
        JPanel pan = new JPanel();
        JScrollPane sp = new JScrollPane(pan);
        sp.setPreferredSize(new Dimension(100, 100));
        sp.setBorder(BorderFactory.createEmptyBorder());
        pan.setLayout(this.gbl);
        this.setLayout(this.gbl);
        this.lblEntryType = new JLabel(Globals.lang("Entry type"));
        Font f = new Font("plain", 1, 12);
        this.lblEntryType.setFont(f);
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.fill = 3;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 0);
        this.gbl.setConstraints(this.lblEntryType, this.con);
        pan.add(this.lblEntryType);
        this.lblKeyPattern = new JLabel(Globals.lang("Key pattern"));
        this.lblKeyPattern.setFont(f);
        this.con.gridx = 1;
        this.con.gridy = 0;
        this.con.gridheight = 1;
        this.con.fill = 2;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 5);
        this.gbl.setConstraints(this.lblKeyPattern, this.con);
        pan.add(this.lblKeyPattern);
        this.con.gridy = 1;
        this.con.gridx = 0;
        JLabel lab = new JLabel(Globals.lang("Default pattern"));
        this.gbl.setConstraints(lab, this.con);
        pan.add(lab);
        this.con.gridx = 1;
        this.gbl.setConstraints(this.defaultPat, this.con);
        pan.add(this.defaultPat);
        this.con.insets = new Insets(5, 5, 10, 5);
        this.btnDefault = new JButton(Globals.lang("Default"));
        this.btnDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TabLabelPattern.this.defaultPat.setText((String)Globals.prefs.defaults.get("defaultLabelPattern"));
            }
        });
        this.con.gridx = 2;
        int y = 2;
        this.gbl.setConstraints(this.btnDefault, this.con);
        pan.add(this.btnDefault);
        for (String s : BibtexEntryType.ALL_TYPES.keySet()) {
            this.textFields.put(s, this.addEntryType(pan, s, y));
            ++y;
        }
        this.con.fill = 1;
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.gridwidth = 3;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.gbl.setConstraints(sp, this.con);
        this.add(sp);
        this.con.gridwidth = 1;
        this.con.gridx = 1;
        this.con.gridy = 2;
        this.con.fill = 2;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(0, 5, 0, 5);
        JButton hlb = new JButton(GUIGlobals.getImage("helpSmall"));
        hlb.setToolTipText(Globals.lang("Help on key patterns"));
        this.gbl.setConstraints(hlb, this.con);
        this.add(hlb);
        hlb.addActionListener(this.help);
        this.btnDefaultAll = new JButton(Globals.lang("Reset all"));
        this.con.gridx = 2;
        this.con.gridy = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(20, 5, 0, 5);
        this.gbl.setConstraints(this.btnDefaultAll, this.con);
        this.btnDefaultAll.addActionListener(new buttonHandler());
        this.add(this.btnDefaultAll);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 8dlu, left:pref", "");
        pan = new JPanel();
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Globals.lang("Key generator settings"));
        builder.nextLine();
        builder.append(pan);
        builder.append(this.autoGenerateOnImport);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.warnBeforeOverwriting);
        builder.append(this.dontOverwrite);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.generateOnSave);
        builder.nextLine();
        builder.append(pan);
        builder.append(Globals.lang("Replace (regular expression)") + ":");
        builder.append(Globals.lang("by") + ":");
        builder.nextLine();
        builder.append(pan);
        builder.append(this.KeyPatternRegex);
        builder.append(this.KeyPatternReplacement);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.con.gridx = 1;
        this.con.gridy = 3;
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.fill = 1;
        this.gbl.setConstraints(builder.getPanel(), this.con);
        this.add(builder.getPanel());
        this.dontOverwrite.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                TabLabelPattern.this.warnBeforeOverwriting.setEnabled(!TabLabelPattern.this.dontOverwrite.isSelected());
            }
        });
    }

    public boolean readyToClose() {
        return true;
    }

    public void setValues() {
        this._keypatterns = this._prefs.getKeyPattern();
        this.defaultPat.setText(Globals.prefs.get("defaultLabelPattern"));
        this.dontOverwrite.setSelected(Globals.prefs.getBoolean("avoidOverwritingKey"));
        this.generateOnSave.setSelected(Globals.prefs.getBoolean("generateKeysBeforeSaving"));
        this.autoGenerateOnImport.setSelected(Globals.prefs.getBoolean("generateKeysAfterInspection"));
        this.warnBeforeOverwriting.setSelected(Globals.prefs.getBoolean("warnBeforeOverwritingKey"));
        this.warnBeforeOverwriting.setEnabled(!this.dontOverwrite.isSelected());
        for (String name : this.textFields.keySet()) {
            JTextField tf = this.textFields.get(name);
            this.setValue(tf, name);
        }
        this.KeyPatternRegex.setText(Globals.prefs.get("KeyPatternRegex"));
        this.KeyPatternReplacement.setText(Globals.prefs.get("KeyPatternReplacement"));
    }

    public String getTabName() {
        return Globals.lang("BibTeX key generator");
    }

    class buttonHandler
    implements ActionListener {
        buttonHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == TabLabelPattern.this.btnDefaultAll) {
                for (String s : TabLabelPattern.this.textFields.keySet()) {
                    JTextField tf = (JTextField)TabLabelPattern.this.textFields.get(s);
                    tf.setText("");
                }
                return;
            }
            JTextField tf = (JTextField)TabLabelPattern.this.textFields.get(evt.getActionCommand());
            tf.setText("");
        }
    }
}

