/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.SearchRule;
import net.sf.jabref.export.layout.format.RemoveLatexCommands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExpRule
implements SearchRule {
    final boolean m_caseSensitiveSearch;
    static RemoveLatexCommands removeBrackets = new RemoveLatexCommands();

    public RegExpRule(boolean caseSensitive) {
        this.m_caseSensitiveSearch = caseSensitive;
    }

    @Override
    public int applyRule(Map<String, String> searchStrings, BibtexEntry bibtexEntry) throws PatternSyntaxException {
        int score = 0;
        String searchString = searchStrings.values().iterator().next();
        int flags = 0;
        if (!this.m_caseSensitiveSearch) {
            flags = 2;
        }
        Pattern pattern = Pattern.compile(searchString, flags);
        return score += this.searchFields(bibtexEntry.getAllFields(), bibtexEntry, pattern);
    }

    protected int searchFields(Set<String> fields, BibtexEntry bibtexEntry, Pattern pattern) {
        int score = 0;
        if (fields != null) {
            for (String field : fields) {
                try {
                    Matcher m;
                    String value = bibtexEntry.getField(field);
                    if (value == null || !(m = pattern.matcher(removeBrackets.format(value))).find()) continue;
                    ++score;
                }
                catch (Throwable t) {
                    System.err.println("Searching error: " + t);
                }
            }
        }
        return score;
    }
}

