/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.VersionHandling;
import net.sf.jabref.sql.DBStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData
implements Iterable<String> {
    private HashMap<String, Vector<String>> metaData = new HashMap();
    private StringReader data;
    private GroupTreeNode groupsRoot = null;
    private File file = null;
    private DBStrings dbStrings = new DBStrings();

    public MetaData(HashMap<String, String> inData, BibtexDatabase db) {
        boolean groupsTreePresent = false;
        Vector<String> flatGroupsData = null;
        Vector<String> treeGroupsData = null;
        int groupsVersionOnDisk = 0;
        if (inData != null) {
            for (String key : inData.keySet()) {
                this.data = new StringReader(inData.get(key));
                Vector<String> orderedData = new Vector<String>();
                try {
                    String unit;
                    while ((unit = this.getNextUnit(this.data)) != null) {
                        orderedData.add(unit);
                    }
                }
                catch (IOException ex) {
                    System.err.println("Weird error while parsing meta data.");
                }
                if (key.equals("groupsversion")) {
                    if (orderedData.size() < 1) continue;
                    groupsVersionOnDisk = Integer.parseInt(((String)orderedData.firstElement()).toString());
                    continue;
                }
                if (key.equals("groupstree")) {
                    groupsTreePresent = true;
                    treeGroupsData = orderedData;
                    continue;
                }
                if (key.equals("groups")) {
                    flatGroupsData = orderedData;
                    continue;
                }
                this.putData(key, orderedData);
            }
        }
        if (groupsTreePresent) {
            this.putGroups(treeGroupsData, db, groupsVersionOnDisk);
        }
        if (!groupsTreePresent && flatGroupsData != null) {
            this.groupsRoot = VersionHandling.importFlatGroups(flatGroupsData);
        }
    }

    public MetaData() {
    }

    public void initializeNewDatabase() {
        this.metaData.put("selector_keywords", new Vector());
        this.metaData.put("selector_author", new Vector());
        this.metaData.put("selector_journal", new Vector());
        this.metaData.put("selector_publisher", new Vector());
    }

    @Override
    public Iterator<String> iterator() {
        return this.metaData.keySet().iterator();
    }

    public Vector<String> getData(String key) {
        return this.metaData.get(key);
    }

    public void remove(String key) {
        this.metaData.remove(key);
    }

    public void putData(String key, Vector<String> orderedData) {
        this.metaData.put(key, orderedData);
    }

    public String getFileDirectory(String fieldName) {
        String dir;
        String key = fieldName + "Directory";
        Vector<String> vec = this.getData(key);
        if (vec != null && vec.size() > 0) {
            String relDir;
            dir = vec.get(0);
            if (!new File(dir).isAbsolute() && this.file != null && new File(relDir = new StringBuffer(this.file.getParent()).append(System.getProperty("file.separator")).append(dir).toString()).exists()) {
                dir = relDir;
            }
        } else {
            dir = Globals.prefs.get(key);
        }
        return dir;
    }

    private void putGroups(Vector<String> orderedData, BibtexDatabase db, int version) {
        try {
            this.groupsRoot = VersionHandling.importGroups(orderedData, db, version);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public GroupTreeNode getGroups() {
        return this.groupsRoot;
    }

    public void setGroups(GroupTreeNode root) {
        this.groupsRoot = root;
    }

    public void writeMetaData(Writer out) throws IOException {
        for (String key : this.metaData.keySet()) {
            StringBuffer sb = new StringBuffer();
            Vector<String> orderedData = this.metaData.get(key);
            if (orderedData.size() >= 0) {
                sb.append("@comment{").append(GUIGlobals.META_FLAG).append(key).append(":");
                for (int j = 0; j < orderedData.size(); ++j) {
                    sb.append(Util.quote(orderedData.elementAt(j), ";", '\\')).append(";");
                }
                sb.append("}");
            }
            this.wrapStringBuffer(sb, Globals.METADATA_LINE_LENGTH);
            sb.append(Globals.NEWLINE);
            sb.append(Globals.NEWLINE);
            out.write(sb.toString());
        }
        if (this.groupsRoot != null && this.groupsRoot.getChildCount() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("@comment{").append(GUIGlobals.META_FLAG).append("groupsversion:");
            sb.append("3;");
            sb.append("}");
            sb.append(Globals.NEWLINE);
            sb.append(Globals.NEWLINE);
            out.write(sb.toString());
            sb = new StringBuffer();
            sb.append("@comment{").append(GUIGlobals.META_FLAG).append("groupstree:");
            sb.append(Globals.NEWLINE);
            StringTokenizer tok = new StringTokenizer(this.groupsRoot.getTreeAsString(), Globals.NEWLINE);
            while (tok.hasMoreTokens()) {
                StringBuffer s = new StringBuffer(Util.quote(tok.nextToken(), ";", '\\') + ";");
                this.wrapStringBuffer(s, Globals.METADATA_LINE_LENGTH);
                sb.append(s);
                sb.append(Globals.NEWLINE);
            }
            sb.append("}");
            sb.append(Globals.NEWLINE);
            sb.append(Globals.NEWLINE);
            out.write(sb.toString());
        }
    }

    private void wrapStringBuffer(StringBuffer sb, int lineLength) {
        for (int i = lineLength; i < sb.length(); i += lineLength + Globals.NEWLINE_LENGTH) {
            sb.insert(i, Globals.NEWLINE);
        }
    }

    private String getNextUnit(Reader reader) throws IOException {
        int c;
        boolean escape = false;
        StringBuffer res = new StringBuffer();
        while ((c = reader.read()) != -1) {
            if (escape) {
                res.append((char)c);
                escape = false;
                continue;
            }
            if (c == 92) {
                escape = true;
                continue;
            }
            if (c == 59) break;
            res.append((char)c);
        }
        if (res.length() > 0) {
            return res.toString();
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public DBStrings getDBStrings() {
        return this.dbStrings;
    }

    public void setDBStrings(DBStrings dbStrings) {
        this.dbStrings = dbStrings;
    }
}

