/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Comparator;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkedComparator
implements Comparator<BibtexEntry> {
    Comparator<BibtexEntry> next;

    public MarkedComparator(Comparator<BibtexEntry> next) {
        this.next = next;
    }

    @Override
    public int compare(BibtexEntry e1, BibtexEntry e2) {
        boolean mrk2;
        if (e1 == e2) {
            return 0;
        }
        boolean mrk1 = Util.isMarked(e1);
        if (mrk1 == (mrk2 = Util.isMarked(e2))) {
            return this.next != null ? this.next.compare(e1, e2) : this.idCompare(e1, e2);
        }
        if (mrk2) {
            return 1;
        }
        return -1;
    }

    private int idCompare(BibtexEntry b1, BibtexEntry b2) {
        return b1.getId().compareTo(b2.getId());
    }
}

