/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;

public class CustomEntryType
extends BibtexEntryType {
    private String name;
    private String[] req;
    private String[] opt;
    private String[][] reqSets = null;

    public CustomEntryType(String name_, String[] req_, String[] opt_) {
        this.name = name_;
        this.parseRequiredFields(req_);
        this.opt = opt_;
    }

    public CustomEntryType(String name_, String reqStr, String optStr) {
        this.name = name_;
        if (reqStr.length() == 0) {
            this.req = new String[0];
        } else {
            this.parseRequiredFields(reqStr);
        }
        this.opt = optStr.length() == 0 ? new String[0] : optStr.split(";");
    }

    protected void parseRequiredFields(String reqStr) {
        String[] parts = reqStr.split(";");
        this.parseRequiredFields(parts);
    }

    protected void parseRequiredFields(String[] parts) {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String[]> sets = new ArrayList<String[]>();
        for (int i = 0; i < parts.length; ++i) {
            String[] subParts = parts[i].split("/");
            for (int j = 0; j < subParts.length; ++j) {
                fields.add(subParts[j]);
            }
            if (subParts.length <= 1) continue;
            sets.add(subParts);
        }
        this.req = fields.toArray(new String[fields.size()]);
        if (sets.size() > 0) {
            this.reqSets = (String[][])sets.toArray((T[])new String[sets.size()][]);
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getOptionalFields() {
        return this.opt;
    }

    public String[] getRequiredFields() {
        return this.req;
    }

    public String[] getRequiredFieldsForCustomization() {
        return this.getRequiredFieldsString().split(";");
    }

    public String describeRequiredFields() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.req.length; ++i) {
            sb.append(this.req[i]);
            sb.append(i <= this.req.length - 1 && this.req.length > 1 ? ", " : "");
        }
        return sb.toString();
    }

    public String describeOptionalFields() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.opt.length; ++i) {
            sb.append(this.opt[i]);
            sb.append(i <= this.opt.length - 1 && this.opt.length > 1 ? ", " : "");
        }
        return sb.toString();
    }

    public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
        int i;
        if (entry.getField("bibtexkey") == null) {
            return false;
        }
        boolean[] isSet = new boolean[this.req.length];
        for (i = 0; i < this.req.length; ++i) {
            isSet[i] = BibtexDatabase.getResolvedField(this.req[i], entry, database) != null;
        }
        for (i = 0; i < this.req.length; ++i) {
            if (isSet[i] || this.isCoupledFieldSet(this.req[i], entry, database)) continue;
            return false;
        }
        return true;
    }

    protected boolean isCoupledFieldSet(String field, BibtexEntry entry, BibtexDatabase database) {
        if (this.reqSets == null) {
            return false;
        }
        for (int i = 0; i < this.reqSets.length; ++i) {
            boolean takesPart = false;
            boolean oneSet = false;
            for (int j = 0; j < this.reqSets[i].length; ++j) {
                if (this.reqSets[i][j].equalsIgnoreCase(field)) {
                    takesPart = true;
                    continue;
                }
                if (BibtexDatabase.getResolvedField(this.reqSets[i][j], entry, database) == null) continue;
                oneSet = true;
            }
            if (!takesPart || !oneSet) continue;
            return true;
        }
        return false;
    }

    public String getRequiredFieldsString() {
        StringBuilder sb = new StringBuilder();
        int reqSetsPiv = 0;
        for (int i = 0; i < this.req.length; ++i) {
            if (this.reqSets == null || reqSetsPiv == this.reqSets.length) {
                sb.append(this.req[i]);
            } else if (this.req[i].equals(this.reqSets[reqSetsPiv][0])) {
                for (int j = 0; j < this.reqSets[reqSetsPiv].length; ++j) {
                    sb.append(this.reqSets[reqSetsPiv][j]);
                    if (j >= this.reqSets[reqSetsPiv].length - 1) continue;
                    sb.append("/");
                }
                i += this.reqSets[reqSetsPiv].length - 1;
                ++reqSetsPiv;
            } else {
                sb.append(this.req[i]);
            }
            if (i >= this.req.length - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public void save(Writer out) throws IOException {
        out.write("@comment{");
        out.write(GUIGlobals.ENTRYTYPE_FLAG);
        out.write(this.getName());
        out.write(": req[");
        out.write(this.getRequiredFieldsString());
        out.write("] opt[");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.opt.length; ++i) {
            sb.append(this.opt[i]);
            if (i >= this.opt.length - 1) continue;
            sb.append(";");
        }
        out.write(sb.toString());
        out.write("]}" + Globals.NEWLINE);
    }

    public static CustomEntryType parseEntryType(String comment) {
        try {
            String rest = comment.substring(GUIGlobals.ENTRYTYPE_FLAG.length());
            int nPos = rest.indexOf(58);
            String name = rest.substring(0, nPos);
            rest = rest.substring(nPos + 2);
            int rPos = rest.indexOf(93);
            if (rPos < 4) {
                throw new IndexOutOfBoundsException();
            }
            String reqFields = rest.substring(4, rPos);
            int oPos = rest.indexOf(93, rPos + 1);
            String optFields = rest.substring(rPos + 6, oPos);
            return new CustomEntryType(name, reqFields, optFields);
        }
        catch (IndexOutOfBoundsException ex) {
            Globals.logger("Ill-formed entrytype comment in BibTeX file.");
            return null;
        }
    }
}

