/*
 * Decompiled with CFR 0.152.
 */
package wsi.ra.tool;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ResourceLoader {
    private static ResourceLoader resourceLoader;

    private ResourceLoader() {
    }

    public static synchronized ResourceLoader instance() {
        if (resourceLoader == null) {
            resourceLoader = new ResourceLoader();
        }
        return resourceLoader;
    }

    public byte[] getBytesFromResourceLocation(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).startsWith("..") || string.startsWith("/") || string.startsWith("\\") || string.length() > 1 && string.charAt(1) == ':') {
            return this.getBytesFromFile(string);
        }
        this.getClass().getClassLoader();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = this.getBytesFromStream(inputStream);
        return byArray;
    }

    public static Vector readLines(String string) {
        return ResourceLoader.readLines(string, false);
    }

    public static Vector readLines(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        byte[] byArray = ResourceLoader.instance().getBytesFromResourceLocation(string);
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(byteArrayInputStream));
        Vector<String> vector = new Vector<String>(100);
        try {
            String string2;
            while ((string2 = lineNumberReader.readLine()) != null) {
                if (!bl) {
                    if (string2.charAt(0) == '#') continue;
                    vector.add(string2);
                    continue;
                }
                vector.add(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return vector;
    }

    private byte[] getBytesFromArchive(String string, String string2) {
        URL uRL = null;
        int n = -1;
        byte[] byArray = null;
        try {
            Object object;
            uRL = new URL(string);
            ZipFile zipFile = new ZipFile(uRL.getFile());
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!((ZipEntry)object).getName().equals(string2)) continue;
                if (((ZipEntry)object).isDirectory()) {
                    return null;
                }
                if (((ZipEntry)object).getSize() > 65536L) {
                    System.out.println("Resource files should be smaller than 65536 bytes...");
                }
                n = (int)((ZipEntry)object).getSize();
            }
            zipFile.close();
            object = new FileInputStream(uRL.getFile());
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(string2)) continue;
                byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n - n2 > 0 && (n3 = zipInputStream.read(byArray, n2, n - n2)) != -1) {
                    n2 += n3;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("error while loading");
            return null;
        }
        return byArray;
    }

    private byte[] getBytesFromFile(String string) {
        if (string.startsWith("/cygdrive/")) {
            int n = "/cygdrive/".length();
            string = string.substring(n, n + 1) + ":" + string.substring(n + 1);
        }
        File file = new File(string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (Exception exception) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        try {
            while (n - n2 > 0 && (n3 = bufferedInputStream.read(byArray, n2, n - n2)) != -1) {
                n2 += n3;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    private byte[] getBytesFromStream(InputStream inputStream) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            int n = bufferedInputStream.available();
            byte[] byArray = new byte[n];
            int n2 = 0;
            int n3 = 0;
            while (n - n2 > 0 && (n3 = bufferedInputStream.read(byArray, n2, n - n2)) != -1) {
                n2 += n3;
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

