/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.Iterator;
import java.util.List;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFA;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.State;
import org.antlr.analysis.StateCluster;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NFAFactory {
    NFA nfa;
    String currentRuleName;
    protected int stateCounter;

    public NFAState newState() {
        int state;
        NFAState n = new NFAState(this.nfa);
        n.stateNumber = state = this.stateCounter++;
        this.nfa.addState(n);
        n.setEnclosingRuleName(this.currentRuleName);
        return n;
    }

    public int getNumberOfStates() {
        return this.stateCounter;
    }

    public void optimizeAlternative(StateCluster alt) {
        NFAState s = alt.left;
        while (s != alt.right) {
            if (s.endOfBlockStateNumber != -1) {
                s = this.nfa.getState(s.endOfBlockStateNumber);
                continue;
            }
            Transition t = s.transition(0);
            if (t instanceof RuleClosureTransition) {
                s = ((RuleClosureTransition)t).getFollowState();
                continue;
            }
            if (t.label.isEpsilon() && s.getNumberOfTransitions() == 1) {
                NFAState epsilonTarget = (NFAState)t.target;
                if (epsilonTarget.endOfBlockStateNumber == -1 && epsilonTarget.transition(0) != null) {
                    s.setTransition0(epsilonTarget.transition(0));
                }
            }
            s = (NFAState)t.target;
        }
    }

    public StateCluster build_Atom(int label) {
        NFAState left = this.newState();
        NFAState right = this.newState();
        this.transitionBetweenStates(left, right, label);
        StateCluster g = new StateCluster(left, right);
        return g;
    }

    public StateCluster build_Set(IntSet set) {
        NFAState left = this.newState();
        NFAState right = this.newState();
        Transition e = new Transition(new Label(set), (State)right);
        left.addTransition(e);
        StateCluster g = new StateCluster(left, right);
        return g;
    }

    public StateCluster build_Range(int a, int b) {
        NFAState left = this.newState();
        NFAState right = this.newState();
        Transition e = new Transition(new Label(IntervalSet.of(a, b)), (State)right);
        left.addTransition(e);
        StateCluster g = new StateCluster(left, right);
        return g;
    }

    public StateCluster build_CharLiteralAtom(String charLiteral) {
        int c = Grammar.getCharValueFromGrammarCharLiteral(charLiteral);
        return this.build_Atom(c);
    }

    public StateCluster build_CharRange(String a, String b) {
        int from = Grammar.getCharValueFromGrammarCharLiteral(a);
        int to = Grammar.getCharValueFromGrammarCharLiteral(b);
        return this.build_Range(from, to);
    }

    public StateCluster build_StringLiteralAtom(String stringLiteral) {
        if (this.nfa.grammar.type == 1) {
            StringBuffer chars = Grammar.getUnescapedStringFromGrammarStringLiteral(stringLiteral);
            NFAState first = this.newState();
            NFAState last = null;
            NFAState prev = first;
            int i = 0;
            while (i < chars.length()) {
                char c = chars.charAt(i);
                NFAState next = this.newState();
                this.transitionBetweenStates(prev, next, c);
                prev = last = next;
                ++i;
            }
            return new StateCluster(first, last);
        }
        int tokenType = this.nfa.grammar.getTokenType(stringLiteral);
        return this.build_Atom(tokenType);
    }

    public StateCluster build_RuleRef(int ruleIndex, NFAState ruleStart) {
        NFAState left = this.newState();
        NFAState right = this.newState();
        RuleClosureTransition e = new RuleClosureTransition(ruleIndex, ruleStart, right);
        left.addTransition(e);
        StateCluster g = new StateCluster(left, right);
        return g;
    }

    public StateCluster build_Epsilon() {
        NFAState left = this.newState();
        NFAState right = this.newState();
        this.transitionBetweenStates(left, right, -5);
        StateCluster g = new StateCluster(left, right);
        return g;
    }

    public StateCluster build_SemanticPredicate(GrammarAST pred) {
        if (!pred.getText().toUpperCase().startsWith("synpred".toUpperCase())) {
            ++this.nfa.grammar.numberOfSemanticPredicates;
        }
        NFAState left = this.newState();
        NFAState right = this.newState();
        Transition e = new Transition(new Label(pred), (State)right);
        left.addTransition(e);
        StateCluster g = new StateCluster(left, right);
        return g;
    }

    public int build_EOFStates(List rules) {
        int numberUnInvokedRules = 0;
        Iterator iterator = rules.iterator();
        while (iterator.hasNext()) {
            Rule r = (Rule)iterator.next();
            String ruleName = r.name;
            NFAState endNFAState = this.nfa.grammar.getRuleStopState(ruleName);
            if (endNFAState.transition(0) != null) continue;
            this.build_EOFState(endNFAState);
            ++numberUnInvokedRules;
        }
        return numberUnInvokedRules;
    }

    private final void build_EOFState(NFAState endNFAState) {
        NFAState end = this.newState();
        int label = -1;
        if (this.nfa.grammar.type == 1) {
            label = -2;
            end.setEOTTargetState(true);
        }
        Transition toEnd = new Transition(label, (State)end);
        endNFAState.addTransition(toEnd);
    }

    public StateCluster build_AB(StateCluster A, StateCluster B) {
        if (A == null) {
            return B;
        }
        if (B == null) {
            return A;
        }
        this.transitionBetweenStates(A.right, B.left, -5);
        StateCluster g = new StateCluster(A.left, B.right);
        return g;
    }

    public StateCluster build_AlternativeBlock(List alternativeStateClusters) {
        StateCluster result = null;
        if (alternativeStateClusters == null || alternativeStateClusters.size() == 0) {
            return null;
        }
        if (alternativeStateClusters.size() == 1) {
            StateCluster g = (StateCluster)alternativeStateClusters.get(0);
            NFAState startOfAlt = this.newState();
            this.transitionBetweenStates(startOfAlt, g.left, -5);
            return new StateCluster(startOfAlt, g.right);
        }
        NFAState prevAlternative = null;
        NFAState firstAlt = null;
        NFAState blockEndNFAState = this.newState();
        blockEndNFAState.setDescription("end block");
        int altNum = 1;
        Iterator iter = alternativeStateClusters.iterator();
        while (iter.hasNext()) {
            StateCluster g = (StateCluster)iter.next();
            NFAState left = this.newState();
            left.setDescription("alt " + altNum + " of ()");
            this.transitionBetweenStates(left, g.left, -5);
            this.transitionBetweenStates(g.right, blockEndNFAState, -5);
            if (firstAlt == null) {
                firstAlt = left;
            } else {
                this.transitionBetweenStates(prevAlternative, left, -5);
            }
            prevAlternative = left;
            ++altNum;
        }
        result = new StateCluster(firstAlt, blockEndNFAState);
        firstAlt.decisionStateType = 2;
        firstAlt.endOfBlockStateNumber = blockEndNFAState.stateNumber;
        return result;
    }

    public StateCluster build_Aoptional(StateCluster A) {
        StateCluster g = null;
        int n = this.nfa.grammar.getNumberOfAltsForDecisionNFA(A.left);
        if (n == 1) {
            NFAState decisionState = A.left;
            decisionState.setDescription("only alt of ()? block");
            NFAState emptyAlt = this.newState();
            emptyAlt.setDescription("epsilon path of ()? block");
            NFAState blockEndNFAState = null;
            blockEndNFAState = this.newState();
            this.transitionBetweenStates(A.right, blockEndNFAState, -5);
            blockEndNFAState.setDescription("end ()? block");
            this.transitionBetweenStates(decisionState, emptyAlt, -5);
            this.transitionBetweenStates(emptyAlt, blockEndNFAState, -5);
            decisionState.endOfBlockStateNumber = blockEndNFAState.stateNumber;
            blockEndNFAState.decisionStateType = 5;
            g = new StateCluster(decisionState, blockEndNFAState);
        } else {
            NFAState lastRealAlt = this.nfa.grammar.getNFAStateForAltOfDecision(A.left, n);
            NFAState emptyAlt = this.newState();
            emptyAlt.setDescription("epsilon path of ()? block");
            this.transitionBetweenStates(lastRealAlt, emptyAlt, -5);
            this.transitionBetweenStates(emptyAlt, A.right, -5);
            A.left.endOfBlockStateNumber = A.right.stateNumber;
            A.right.decisionStateType = 5;
            g = A;
        }
        g.left.decisionStateType = 3;
        return g;
    }

    public StateCluster build_Aplus(StateCluster A) {
        NFAState left = this.newState();
        NFAState blockEndNFAState = this.newState();
        blockEndNFAState.decisionStateType = 5;
        if (A.right.decisionStateType == 5) {
            NFAState extraRightEdge = this.newState();
            this.transitionBetweenStates(A.right, extraRightEdge, -5);
            A.right = extraRightEdge;
        }
        this.transitionBetweenStates(A.right, blockEndNFAState, -5);
        this.transitionBetweenStates(A.right, A.left, -5);
        this.transitionBetweenStates(left, A.left, -5);
        A.right.decisionStateType = 1;
        A.left.decisionStateType = 2;
        A.left.endOfBlockStateNumber = A.right.stateNumber;
        StateCluster g = new StateCluster(left, blockEndNFAState);
        return g;
    }

    public StateCluster build_Astar(StateCluster A) {
        NFAState bypassDecisionState = this.newState();
        bypassDecisionState.setDescription("enter loop path of ()* block");
        NFAState optionalAlt = this.newState();
        optionalAlt.setDescription("epsilon path of ()* block");
        NFAState blockEndNFAState = this.newState();
        blockEndNFAState.decisionStateType = 5;
        if (A.right.decisionStateType == 5) {
            NFAState extraRightEdge = this.newState();
            this.transitionBetweenStates(A.right, extraRightEdge, -5);
            A.right = extraRightEdge;
        }
        A.right.setDescription("()* loopback");
        this.transitionBetweenStates(bypassDecisionState, A.left, -5);
        this.transitionBetweenStates(bypassDecisionState, optionalAlt, -5);
        this.transitionBetweenStates(optionalAlt, blockEndNFAState, -5);
        this.transitionBetweenStates(A.right, blockEndNFAState, -5);
        this.transitionBetweenStates(A.right, A.left, -5);
        bypassDecisionState.decisionStateType = 4;
        A.left.decisionStateType = 2;
        A.right.decisionStateType = 1;
        A.left.endOfBlockStateNumber = A.right.stateNumber;
        bypassDecisionState.endOfBlockStateNumber = blockEndNFAState.stateNumber;
        StateCluster g = new StateCluster(bypassDecisionState, blockEndNFAState);
        return g;
    }

    public StateCluster build_Wildcard() {
        NFAState left = this.newState();
        NFAState right = this.newState();
        Label label = new Label(this.nfa.grammar.getTokenTypes());
        Transition e = new Transition(label, (State)right);
        left.addTransition(e);
        StateCluster g = new StateCluster(left, right);
        return g;
    }

    protected IntSet getCollapsedBlockAsSet(State blk) {
        Label label;
        State s1;
        State s0 = blk;
        if (s0 != null && s0.transition(0) != null && (s1 = s0.transition((int)0).target) != null && s1.transition(0) != null && (label = s1.transition((int)0).label).isSet()) {
            return label.getSet();
        }
        return null;
    }

    private final void transitionBetweenStates(NFAState a, NFAState b, int label) {
        Transition e = new Transition(label, (State)b);
        a.addTransition(e);
    }

    private final /* synthetic */ void this() {
        this.nfa = null;
        this.currentRuleName = null;
        this.stateCounter = 0;
    }

    public NFAFactory(NFA nfa) {
        this.this();
        nfa.setFactory(this);
        this.nfa = nfa;
    }
}

