/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TXMLReader {
    private Document config;
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder builder;
    private boolean ready = false;

    public TXMLReader(String string) {
        try {
            this.builder = this.factory.newDocumentBuilder();
            InputStream inputStream = null;
            if (string != null) {
                inputStream = TXMLReader.class.getResourceAsStream(string);
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream("src" + string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                this.config = this.builder.parse(inputStream);
                this.ready = true;
            }
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public NodeList getNodes(String string) {
        return this.config.getElementsByTagName(string);
    }

    private Element getFirstElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() < 1) {
            throw new RuntimeException("Element: " + element + " does not contain: " + string);
        }
        return (Element)nodeList.item(0);
    }

    public String getSimpleElementText(Element element, String string) {
        Element element2 = this.getFirstElement(element, string);
        return this.getSimpleElementText(element2);
    }

    public String getSimpleElementText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Text)) continue;
            stringBuffer.append(node.getNodeValue().trim());
        }
        return stringBuffer.toString();
    }

    public int readIntegerAttribute(Element element, String string, int n) {
        String string2;
        int n2 = n;
        if (element != null && (string2 = element.getAttribute(string)) != null && string2.length() > 0) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public String readStringAttribute(Element element, String string, String string2) {
        String string3;
        if (element != null && (string3 = element.getAttribute(string)) != null && string3.length() > 0) {
            return string3;
        }
        return string2;
    }

    public double readDoubleAttribute(Element element, String string, double d) {
        String string2;
        if (element != null && (string2 = element.getAttribute(string)) != null && string2.length() > 0) {
            return Double.parseDouble(string2);
        }
        return d;
    }
}

