/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.Util;
import net.sf.jabref.undo.NamedCompound;

public class MassSetFieldAction
extends MnemonicAwareAction {
    private JabRefFrame frame;
    private JDialog diag;
    private JRadioButton all;
    private JRadioButton selected;
    private JRadioButton clear;
    private JRadioButton set;
    private JTextField field;
    private JTextField text;
    private JButton ok;
    private JButton cancel;
    boolean cancelled = true;
    private JCheckBox overwrite;

    public MassSetFieldAction(JabRefFrame jabRefFrame) {
        this.putValue("Name", "Set/clear fields");
        this.frame = jabRefFrame;
    }

    private void createDialog() {
        this.diag = new JDialog(this.frame, Globals.lang("Set/clear fields"), true);
        this.field = new JTextField();
        this.text = new JTextField();
        this.ok = new JButton(Globals.lang("Ok"));
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.all = new JRadioButton(Globals.lang("All entries"));
        this.selected = new JRadioButton(Globals.lang("Selected entries"));
        this.clear = new JRadioButton(Globals.lang("Clear fields"));
        this.set = new JRadioButton(Globals.lang("Set fields"));
        this.set.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MassSetFieldAction.this.text.setEnabled(MassSetFieldAction.this.set.isSelected());
                MassSetFieldAction.this.overwrite.setEnabled(MassSetFieldAction.this.set.isSelected());
            }
        });
        this.overwrite = new JCheckBox(Globals.lang("Overwrite existing field values"), true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.all);
        buttonGroup.add(this.selected);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.clear);
        buttonGroup.add(this.set);
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:100dlu", ""));
        defaultFormBuilder.appendSeparator(Globals.lang("Field name"));
        defaultFormBuilder.append(Globals.lang("Field name"));
        defaultFormBuilder.append(this.field);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Include entries"));
        defaultFormBuilder.append((Component)this.all, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.selected, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("New field value"));
        defaultFormBuilder.append(this.set);
        defaultFormBuilder.append(this.text);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.clear);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.overwrite, 3);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(this.ok);
        buttonBarBuilder.addGridded(this.cancel);
        buttonBarBuilder.addGlue();
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.diag.pack();
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MassSetFieldAction.this.cancelled = false;
                MassSetFieldAction.this.diag.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MassSetFieldAction.this.cancelled = true;
                MassSetFieldAction.this.diag.dispose();
            }
        });
    }

    private void prepareDialog(boolean bl) {
        this.selected.setEnabled(bl);
        if (bl) {
            this.selected.setSelected(true);
        } else {
            this.all.setSelected(true);
        }
        if (!this.set.isSelected() && !this.clear.isSelected()) {
            this.set.setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        BasePanel basePanel = this.frame.basePanel();
        if (basePanel == null) {
            return;
        }
        BibtexEntry[] bibtexEntryArray = basePanel.getSelectedEntries();
        if (this.diag == null) {
            this.createDialog();
        }
        this.cancelled = true;
        this.prepareDialog(bibtexEntryArray.length > 0);
        Util.placeDialog(this.diag, this.frame);
        this.diag.setVisible(true);
        if (this.cancelled) {
            return;
        }
        Collection<BibtexEntry> collection = this.all.isSelected() ? basePanel.database().getEntries() : Arrays.asList(bibtexEntryArray);
        String string = this.text.getText();
        if (string.length() == 0) {
            string = null;
        }
        String[] stringArray = this.getFieldNames(this.field.getText().trim().toLowerCase());
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Set field"));
        for (int i = 0; i < stringArray.length; ++i) {
            namedCompound.addEdit(Util.massSetField(collection, stringArray[i], this.set.isSelected() ? string : null, this.overwrite.isSelected()));
        }
        namedCompound.end();
        basePanel.undoManager.addEdit(namedCompound);
        basePanel.markBaseChanged();
    }

    private String[] getFieldNames(String string) {
        return string.split("[^a-z]");
    }
}

