/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sf.jabref.Globals;

public class ErrorConsole {
    ByteArrayOutputStream errByteStream = new ByteArrayOutputStream();
    ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
    private static ErrorConsole instance = null;

    public static ErrorConsole getInstance() {
        if (instance == null) {
            instance = new ErrorConsole();
        }
        return instance;
    }

    private ErrorConsole() {
        PrintStream printStream = new PrintStream(this.errByteStream);
        TeeStream teeStream = new TeeStream(System.err, printStream);
        System.setErr(teeStream);
        printStream = new PrintStream(this.outByteStream);
        teeStream = new TeeStream(System.out, printStream);
        System.setOut(teeStream);
    }

    public String getErrorMessages() {
        return this.errByteStream.toString();
    }

    public String getOutput() {
        return this.outByteStream.toString();
    }

    public void displayErrorConsole(JFrame jFrame) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JTextArea jTextArea = new JTextArea(this.getOutput());
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTabbedPane.addTab(Globals.lang("Output"), jScrollPane);
        jTextArea = new JTextArea(this.getErrorMessages());
        jTextArea.setEditable(false);
        if (jTextArea.getText().length() == 0) {
            jTextArea.setText(Globals.lang("No exceptions have ocurred."));
        }
        jScrollPane = new JScrollPane(jTextArea);
        jTabbedPane.addTab(Globals.lang("Exceptions"), jScrollPane);
        jTabbedPane.setPreferredSize(new Dimension(500, 500));
        JOptionPane.showMessageDialog(jFrame, jTabbedPane, Globals.lang("Program output"), 0);
    }

    public AbstractAction getAction(JFrame jFrame) {
        return new ErrorConsoleAction(jFrame);
    }

    public class TeeStream
    extends PrintStream {
        PrintStream out;

        public TeeStream(PrintStream printStream, PrintStream printStream2) {
            super(printStream);
            this.out = printStream2;
        }

        public void write(byte[] byArray, int n, int n2) {
            try {
                super.write(byArray, n, n2);
                this.out.write(byArray, n, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void flush() {
            super.flush();
            this.out.flush();
        }
    }

    class ErrorConsoleAction
    extends AbstractAction {
        JFrame frame;

        public ErrorConsoleAction(JFrame jFrame) {
            super(Globals.menuTitle("Show error console"));
            this.putValue("ShortDescription", Globals.lang("Display all error messages"));
            this.frame = jFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ErrorConsole.this.displayErrorConsole(this.frame);
        }
    }
}

