/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Util;

public class UndoableFieldChange
extends AbstractUndoableEdit {
    private BibtexEntry entry;
    private String field;
    private Object oldValue;
    private Object newValue;

    public UndoableFieldChange(BibtexEntry bibtexEntry, String string, Object object, Object object2) {
        this.entry = bibtexEntry;
        this.field = string;
        this.oldValue = object;
        this.newValue = object2;
    }

    public String getUndoPresentationName() {
        return "Undo: change field";
    }

    public String getRedoPresentationName() {
        return "Redo: change field";
    }

    public void undo() {
        super.undo();
        try {
            if (this.oldValue != null) {
                this.entry.setField(this.field, this.oldValue);
            } else {
                this.entry.clearField(this.field);
            }
        }
        catch (Throwable throwable) {
            Util.pr(throwable.getMessage());
        }
    }

    public void redo() {
        super.redo();
        try {
            if (this.newValue != null) {
                this.entry.setField(this.field, this.newValue);
            } else {
                this.entry.clearField(this.field);
            }
        }
        catch (Throwable throwable) {
            Util.pr(throwable.getMessage());
        }
    }
}

