/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Vector;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.ParserResult;

public class RemoteListener
extends Thread
implements ImportInspectionDialog.CallBack {
    private JabRef jabref;
    private ServerSocket socket;
    private boolean active = true;
    private boolean toStop = false;
    private static final String IDENTIFIER = "jabref";

    public RemoteListener(JabRef jabRef, ServerSocket serverSocket) {
        this.jabref = jabRef;
        this.socket = serverSocket;
    }

    public void disable() {
        this.toStop = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void run() {
        while (this.active) {
            try {
                Socket socket = this.socket.accept();
                socket.setSoTimeout(1000);
                if (this.toStop) {
                    this.active = false;
                    return;
                }
                OutputStream outputStream = socket.getOutputStream();
                InputStream inputStream = socket.getInputStream();
                outputStream.write(IDENTIFIER.getBytes());
                outputStream.write(0);
                outputStream.flush();
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    int n;
                    while ((n = inputStream.read()) != 0 && n >= 0) {
                        stringBuffer.append((char)n);
                    }
                    if (stringBuffer.length() == 0) continue;
                    String[] stringArray = stringBuffer.toString().split("\n");
                    Vector vector = this.jabref.processArguments(stringArray, false);
                    for (int i = 0; i < vector.size(); ++i) {
                        ParserResult parserResult = (ParserResult)vector.elementAt(i);
                        if (!parserResult.toOpenTab()) {
                            this.jabref.jrf.addTab(parserResult.getDatabase(), parserResult.getFile(), parserResult.getMetaData(), parserResult.getEncoding(), i == 0);
                            continue;
                        }
                        BasePanel basePanel = this.jabref.jrf.basePanel();
                        if (basePanel == null) {
                            this.jabref.jrf.addTab(parserResult.getDatabase(), parserResult.getFile(), parserResult.getMetaData(), parserResult.getEncoding(), i == 0);
                            continue;
                        }
                        ArrayList arrayList = new ArrayList(parserResult.getDatabase().getEntries());
                        this.jabref.jrf.addImportedEntries(basePanel, arrayList, "", false, this);
                    }
                    inputStream.close();
                    outputStream.close();
                    socket.close();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    inputStream.close();
                    outputStream.close();
                    socket.close();
                }
            }
            catch (SocketException socketException) {
                this.active = false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static RemoteListener openRemoteListener(JabRef jabRef) {
        try {
            ServerSocket serverSocket = new ServerSocket(Globals.prefs.getInt("remoteServerPort"), 1, InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
            RemoteListener remoteListener = new RemoteListener(jabRef, serverSocket);
            return remoteListener;
        }
        catch (IOException iOException) {
            if (!iOException.getMessage().startsWith("Address already in use")) {
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public static boolean sendToActiveJabRefInstance(String[] stringArray) {
        try {
            InetAddress inetAddress = InetAddress.getByName("localhost");
            Socket socket = new Socket(inetAddress, Globals.prefs.getInt("remoteServerPort"));
            socket.setSoTimeout(2000);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            StringBuffer stringBuffer = new StringBuffer();
            try {
                int n;
                while ((n = inputStream.read()) != 0 && n >= 0) {
                    stringBuffer.append((char)n);
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                System.out.println("Connection timed out.");
            }
            if (!IDENTIFIER.equals(stringBuffer.toString())) {
                String string = Globals.lang("Cannot use port %0 for remote operation; another application may be using it. Try specifying another port.", new String[]{String.valueOf(Globals.prefs.getInt("remoteServerPort"))});
                System.out.println(string);
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                byte[] byArray = stringArray[i].getBytes();
                outputStream.write(byArray);
                outputStream.write(10);
            }
            outputStream.write(0);
            outputStream.flush();
            inputStream.close();
            outputStream.close();
            socket.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void done(int n) {
        this.jabref.jrf.output(Globals.lang("Imported entries"));
    }

    public void cancelled() {
    }

    public void stopFetching() {
    }
}

