/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.imports.ImportCustomizationDialog;
import net.sf.jabref.imports.ImportFormat;

class ZipFileChooser
extends JDialog {
    private CustomImportList.Importer selectedImporter = null;
    private JButton okButton = new JButton(Globals.lang("Ok"));
    private JButton cancelButton = new JButton(Globals.lang("Cancel"));
    private JTable table;
    private JabRefPreferences prefs = Globals.prefs;
    private ZipFileChooser zipFileChooser;
    private ImportCustomizationDialog importCustomizationDialog;

    public Dimension getSize() {
        return new Dimension(400, 300);
    }

    private ZipEntry[] getSelectableZipEntries(ZipFile zipFile) {
        ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class")) continue;
            arrayList.add(zipEntry);
        }
        return arrayList.toArray(new ZipEntry[0]);
    }

    public ZipFileChooser(ImportCustomizationDialog importCustomizationDialog, ZipFile zipFile) throws HeadlessException {
        super(importCustomizationDialog, Globals.lang("Select file from ZIP-archive"), false);
        this.importCustomizationDialog = importCustomizationDialog;
        this.zipFileChooser = this;
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZipFileChooser.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ZipFileChooser.this.table.getSelectedRow();
                if (n != -1) {
                    ZipFileChooserTableModel zipFileChooserTableModel = (ZipFileChooserTableModel)ZipFileChooser.this.table.getModel();
                    ZipEntry zipEntry = zipFileChooserTableModel.getZipEntry(n);
                    CustomImportList.Importer importer = ((ZipFileChooser)ZipFileChooser.this).prefs.customImports.new CustomImportList.Importer();
                    importer.setBasePath(zipFileChooserTableModel.getZipFile().getName());
                    String string = zipEntry.getName().substring(0, zipEntry.getName().lastIndexOf(46));
                    importer.setClassName(string);
                    try {
                        ImportFormat importFormat = importer.getInstance();
                        importer.setName(importFormat.getFormatName());
                        importer.setCliId(importFormat.getCLIId());
                        ZipFileChooser.this.importCustomizationDialog.addOrReplaceImporter(importer);
                        ZipFileChooser.this.dispose();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(ZipFileChooser.this.zipFileChooser, Globals.lang("Could not instantiate %0 %1", importer.getName() + ":\n", exception.getMessage()));
                    }
                } else {
                    JOptionPane.showMessageDialog(ZipFileChooser.this.zipFileChooser, Globals.lang("Please select an importer."));
                }
            }
        });
        ZipFileChooserTableModel zipFileChooserTableModel = new ZipFileChooserTableModel(zipFile, this.getSelectableZipEntries(zipFile));
        this.table = new JTable(zipFileChooserTableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(150);
        tableColumnModel.getColumn(2).setPreferredWidth(100);
        JScrollPane jScrollPane = new JScrollPane(this.table, 20, 31);
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        jPanel2.add(Box.createHorizontalStrut(5));
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.setSize(this.getSize());
        this.pack();
        Util.placeDialog(this, importCustomizationDialog);
        new FocusRequester(this.table);
    }

    class ZipFileChooserTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{Globals.lang("Name"), Globals.lang("Last modified"), Globals.lang("Size")};
        private ZipEntry[] rows = null;
        private ZipFile zipFile = null;

        ZipFileChooserTableModel(ZipFile zipFile, ZipEntry[] zipEntryArray) {
            this.rows = zipEntryArray;
            this.zipFile = zipFile;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.rows.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public ZipEntry getZipEntry(int n) {
            return this.rows[n];
        }

        public ZipFile getZipFile() {
            return this.zipFile;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            ZipEntry zipEntry = this.getZipEntry(n);
            if (n2 == 0) {
                object = zipEntry.getName();
            } else if (n2 == 1) {
                object = SimpleDateFormat.getDateTimeInstance().format(new Date(zipEntry.getTime()));
            } else if (n2 == 2) {
                object = new Long(zipEntry.getSize());
            }
            return object;
        }
    }
}

