/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class OvidImporter
extends ImportFormat {
    public static Pattern ovid_src_pat = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+)\\(([\\w\\-]+)\\):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    public static Pattern ovid_src_pat_no_issue = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    public static Pattern ovid_src_pat_2 = Pattern.compile("([ \\w&\\-,]+)\\. Vol ([0-9]+)\\(([\\w\\-]+)\\) ([A-Za-z]+) ([0-9][0-9][0-9][0-9]), ([0-9]+\\-?[0-9]+)");
    public static Pattern incollection_pat = Pattern.compile("(.+)\\(([0-9][0-9][0-9][0-9])\\)\\. ([ \\w&\\-,:]+)\\.[ ]+\\(pp. ([0-9]+\\-?[0-9]+?)\\).[A-Za-z0-9, ]+pp\\. ([\\w, ]+): ([\\w, ]+)");
    public static Pattern book_pat = Pattern.compile("\\(([0-9][0-9][0-9][0-9])\\)\\. [A-Za-z, ]+([0-9]+) pp\\. ([\\w, ]+): ([\\w, ]+)");

    public String getFormatName() {
        return "Ovid";
    }

    public String getCLIId() {
        return "ovid";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        return true;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        String string;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() > 0 && string.charAt(0) != ' ') {
                stringBuffer.append("__NEWFIELD__");
            }
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        String[] stringArray = stringBuffer.toString().split("<[0-9]+>");
        for (int i = 1; i < stringArray.length; ++i) {
            Object object;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray2 = stringArray[i].split("__NEWFIELD__");
            for (int j = 0; j < stringArray2.length; ++j) {
                int n = stringArray2[j].indexOf(10);
                object = stringArray2[j].substring(0, n).trim();
                String string2 = stringArray2[j].substring(n).trim();
                if (string2.endsWith(".")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (((String)object).indexOf("Author") == 0 && ((String)object).indexOf("Author Keywords") == -1 && ((String)object).indexOf("Author e-mail") == -1) {
                    hashMap.put("author", string2);
                    continue;
                }
                if (((String)object).indexOf("Title") == 0) {
                    if ((string2 = string2.replaceAll("\\[.+\\]", "").trim()).endsWith(".")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    hashMap.put("title", string2);
                    continue;
                }
                if (((String)object).indexOf("Chapter Title") == 0) {
                    hashMap.put("chaptertitle", string2);
                    continue;
                }
                if (((String)object).indexOf("Source") == 0) {
                    Matcher matcher = ovid_src_pat.matcher(string2);
                    if (matcher.find()) {
                        hashMap.put("journal", matcher.group(1));
                        hashMap.put("volume", matcher.group(2));
                        hashMap.put("issue", matcher.group(3));
                        hashMap.put("pages", matcher.group(4));
                        hashMap.put("year", matcher.group(5));
                    } else {
                        matcher = ovid_src_pat_no_issue.matcher(string2);
                        if (matcher.find()) {
                            hashMap.put("journal", matcher.group(1));
                            hashMap.put("volume", matcher.group(2));
                            hashMap.put("pages", matcher.group(3));
                            hashMap.put("year", matcher.group(4));
                        } else {
                            matcher = ovid_src_pat_2.matcher(string2);
                            if (matcher.find()) {
                                hashMap.put("journal", matcher.group(1));
                                hashMap.put("volume", matcher.group(2));
                                hashMap.put("issue", matcher.group(3));
                                hashMap.put("month", matcher.group(4));
                                hashMap.put("year", matcher.group(5));
                                hashMap.put("pages", matcher.group(6));
                            } else {
                                matcher = incollection_pat.matcher(string2);
                                if (matcher.find()) {
                                    hashMap.put("editor", matcher.group(1).replaceAll(" \\(Ed\\)", ""));
                                    hashMap.put("year", matcher.group(2));
                                    hashMap.put("booktitle", matcher.group(3));
                                    hashMap.put("pages", matcher.group(4));
                                    hashMap.put("address", matcher.group(5));
                                    hashMap.put("publisher", matcher.group(6));
                                } else {
                                    matcher = book_pat.matcher(string2);
                                    if (matcher.find()) {
                                        hashMap.put("year", matcher.group(1));
                                        hashMap.put("pages", matcher.group(2));
                                        hashMap.put("address", matcher.group(3));
                                        hashMap.put("publisher", matcher.group(4));
                                    }
                                }
                            }
                        }
                    }
                    if (hashMap.get("pages") == null) continue;
                    hashMap.put("pages", ((String)hashMap.get("pages")).replaceAll("-", "--"));
                    continue;
                }
                if (((String)object).equals("Abstract")) {
                    hashMap.put("abstract", string2);
                    continue;
                }
                if (!((String)object).equals("Publication Type")) continue;
                if (string2.indexOf("Book") >= 0) {
                    hashMap.put("entrytype", "book");
                    continue;
                }
                if (string2.indexOf("Journal") < 0) continue;
                hashMap.put("entrytype", "article");
            }
            String string3 = (String)hashMap.get("author");
            if (string3 != null && string3.indexOf(" [Ed]") >= 0) {
                hashMap.remove("author");
                hashMap.put("editor", string3.replaceAll(" \\[Ed\\]", ""));
            }
            if ((string3 = (String)hashMap.get("author")) != null) {
                hashMap.put("author", this.fixNames(string3));
            }
            if ((string3 = (String)hashMap.get("editor")) != null) {
                hashMap.put("editor", this.fixNames(string3));
            }
            String string4 = hashMap.containsKey("entrytype") ? (String)hashMap.get("entrytype") : "other";
            hashMap.remove("entrytype");
            if (string4.equals("book") && hashMap.containsKey("chaptertitle")) {
                string4 = "incollection";
                hashMap.put("title", (String)hashMap.remove("chaptertitle"));
            }
            object = new BibtexEntry(Util.createNeutralId(), Globals.getEntryType(string4));
            ((BibtexEntry)object).setField(hashMap);
            arrayList.add(object);
        }
        return arrayList;
    }

    private String fixNames(String string) {
        String string2 = string.indexOf(";") > 0 ? string.replaceAll("[^\\.A-Za-z,;\\- ]", "").replaceAll(";", " and") : string;
        return AuthorList.fixAuthor_lastNameFirst(string2);
    }
}

