/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.OAI2Handler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OAI2Fetcher
implements EntryFetcher,
Runnable {
    public static final String OAI2_ARXIV_PREFIXIDENTIFIER = "oai%3AarXiv.org%3A";
    public static final String OAI2_ARXIV_HOST = "arxiv.org";
    public static final String OAI2_ARXIV_SCRIPT = "oai2";
    public static final String OAI2_ARXIV_METADATAPREFIX = "arXiv";
    public static final String OAI2_ARXIV_ARCHIVENAME = "ArXiv.org";
    public static final String OAI2_IDENTIFIER_FIELD = "oai2identifier";
    private SAXParserFactory parserFactory;
    private SAXParser saxParser;
    private String oai2Host;
    private String oai2Script;
    private String oai2MetaDataPrefix;
    private String oai2PrefixIdentifier;
    private String oai2ArchiveName;
    private boolean shouldContinue = true;
    private String query;
    private ImportInspectionDialog dialog;
    private JabRefFrame frame;
    private long waitTime = -1L;
    private Date lastCall;

    private boolean shouldWait() {
        return this.waitTime > 0L;
    }

    public OAI2Fetcher(String string, String string2, String string3, String string4, String string5, long l) {
        this.oai2Host = string;
        this.oai2Script = string2;
        this.oai2MetaDataPrefix = string3;
        this.oai2PrefixIdentifier = string4;
        this.oai2ArchiveName = string5;
        this.waitTime = l;
        try {
            this.parserFactory = SAXParserFactory.newInstance();
            this.saxParser = this.parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public OAI2Fetcher() {
        this(OAI2_ARXIV_HOST, OAI2_ARXIV_SCRIPT, OAI2_ARXIV_METADATAPREFIX, OAI2_ARXIV_PREFIXIDENTIFIER, OAI2_ARXIV_ARCHIVENAME, 20000L);
    }

    public String constructUrl(String string) {
        String string2 = "";
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("http://").append(this.oai2Host).append("/");
        stringBuffer.append(this.oai2Script).append("?");
        stringBuffer.append("verb=GetRecord");
        stringBuffer.append("&identifier=");
        stringBuffer.append(this.oai2PrefixIdentifier);
        stringBuffer.append(string2);
        stringBuffer.append("&metadataPrefix=").append(this.oai2MetaDataPrefix);
        return stringBuffer.toString();
    }

    public static String fixKey(String string) {
        int n = string.indexOf(46);
        int n2 = string.indexOf(47);
        if (n > -1 && n < n2) {
            string = string.substring(0, n) + string.substring(n2, string.length());
        }
        return string;
    }

    public BibtexEntry importOai2Entry(String string) {
        string = OAI2Fetcher.fixKey(string);
        String string2 = this.constructUrl(string);
        try {
            URL uRL = new URL(string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", "Jabref");
            InputStream inputStream = httpURLConnection.getInputStream();
            BibtexEntry bibtexEntry = new BibtexEntry(Util.createNeutralId(), BibtexEntryType.ARTICLE);
            bibtexEntry.setField(OAI2_IDENTIFIER_FIELD, string);
            OAI2Handler oAI2Handler = new OAI2Handler(bibtexEntry);
            this.saxParser.parse(inputStream, (DefaultHandler)oAI2Handler);
            return bibtexEntry;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("An Exception ocurred while accessing '%0'", string2) + "\n\n" + iOException.toString(), Globals.lang(this.getKeyName()), 0);
        }
        catch (SAXException sAXException) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("An SAXException ocurred while parsing '%0':", string2) + "\n\n" + sAXException.getMessage(), Globals.lang(this.getKeyName()), 0);
        }
        catch (RuntimeException runtimeException) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("An Error occurred while fetching from OAI2 source (%0):", string2) + "\n\n" + runtimeException.getMessage(), Globals.lang(this.getKeyName()), 0);
        }
        return null;
    }

    public String getHelpPage() {
        return null;
    }

    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    public String getKeyName() {
        return "Fetch " + this.oai2ArchiveName;
    }

    public JPanel getOptionsPanel() {
        return null;
    }

    public String getTitle() {
        return Globals.menuTitle(this.getKeyName());
    }

    public void processQuery(String string, ImportInspectionDialog importInspectionDialog, JabRefFrame jabRefFrame) {
        this.query = string;
        this.dialog = importInspectionDialog;
        this.frame = jabRefFrame;
        new Thread(this).start();
    }

    public void cancelled() {
        this.shouldContinue = false;
    }

    public void done(int n) {
    }

    public void stopFetching() {
        this.shouldContinue = false;
    }

    public void run() {
        try {
            this.dialog.setVisible(true);
            this.shouldContinue = true;
            this.query = this.query.replaceAll(" ", ";");
            String[] stringArray = this.query.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (this.shouldWait() && this.lastCall != null) {
                    long l = new Date().getTime() - this.lastCall.getTime();
                    while (l < this.waitTime) {
                        this.frame.output("Waiting for ArXiv..." + (this.waitTime - l) / 1000L + " s");
                        Thread.sleep(1000L);
                        l = new Date().getTime() - this.lastCall.getTime();
                    }
                }
                this.frame.output("Processing " + string);
                if (!this.shouldContinue) break;
                BibtexEntry bibtexEntry = this.importOai2Entry(string);
                if (this.shouldWait()) {
                    this.lastCall = new Date();
                }
                if (bibtexEntry != null) {
                    this.dialog.addEntry(bibtexEntry);
                }
                this.dialog.setProgress(i + 1, stringArray.length);
            }
            this.dialog.entryListComplete();
            this.frame.output("");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

