/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.Util;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.AuthorDialog;
import net.sf.jabref.imports.MedlineHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MedlineFetcher
extends SidePaneComponent
implements Runnable,
ImportInspectionDialog.CallBack {
    final int PACING = 20;
    final int MAX_TO_FETCH = 10;
    boolean keepOn = true;
    String idList;
    JTextField tf = new JTextField();
    JPanel pan = new JPanel();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    MedlineFetcher ths = this;
    AuthorDialog authorDialog;
    JFrame jFrame;
    JButton go = new JButton(Globals.lang("Fetch"));
    JButton helpBut = new JButton(GUIGlobals.getImage("helpSmall"));
    HelpAction help = new HelpAction(Globals.helpDiag, GUIGlobals.medlineHelp, "Help");

    public MedlineFetcher(SidePaneManager sidePaneManager) {
        super(sidePaneManager, GUIGlobals.getIconUrl("medline"), Globals.lang("Fetch Medline"));
        this.helpBut.addActionListener(this.help);
        this.helpBut.setMargin(new Insets(0, 0, 0, 0));
        this.tf.setPreferredSize(new Dimension(1, this.tf.getPreferredSize().height));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.con.fill = 1;
        this.gbl.setConstraints(this.tf, this.con);
        jPanel.add(this.tf);
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.go, this.con);
        jPanel.add(this.go);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.helpBut, this.con);
        jPanel.add(this.helpBut);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(MedlineFetcher.this.ths).start();
            }
        };
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)jPanel, "Center");
        this.go.addActionListener(actionListener);
        this.tf.addActionListener(actionListener);
        this.tf.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary() && MedlineFetcher.this.tf.getText().length() > 0) {
                    MedlineFetcher.this.tf.selectAll();
                }
            }
        });
    }

    public JTextField getTextField() {
        return this.tf;
    }

    public void fetchById() {
        Pattern pattern = Pattern.compile("\\d+[,\\d+]*");
        Matcher matcher = pattern.matcher(this.idList);
        if (matcher.matches()) {
            this.panel.frame().output(Globals.lang("Fetching Medline by ID..."));
            ArrayList arrayList = MedlineFetcher.fetchMedline(this.idList);
            if (arrayList != null && arrayList.size() > 0) {
                this.tf.setText("");
                this.panel.frame().addImportedEntries(this.panel, arrayList, null, false, this);
            } else {
                this.panel.output(Globals.lang("No Medline entries found."));
            }
        } else {
            JOptionPane.showMessageDialog(this.panel.frame(), Globals.lang("Please enter a semicolon or comma separated list of Medline IDs (numbers)."), Globals.lang("Input error"), 0);
        }
    }

    public static ArrayList fetchMedline(String string) {
        ArrayList arrayList = null;
        try {
            String string2 = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&retmode=xml&rettype=citation&id=" + string;
            URL uRL = new URL(string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            MedlineHandler medlineHandler = new MedlineHandler();
            sAXParser.parse(httpURLConnection.getInputStream(), (DefaultHandler)medlineHandler);
            arrayList = medlineHandler.getItems();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    public void run() {
        this.idList = this.tf.getText().replace(';', ',');
        Pattern pattern = Pattern.compile("\\d+[,\\d+]*");
        Pattern pattern2 = Pattern.compile(".+[,.+]*");
        Matcher matcher = pattern.matcher(this.idList);
        Matcher matcher2 = pattern2.matcher(this.idList);
        if (matcher.matches()) {
            this.panel.frame().output(Globals.lang("Fetching Medline by id ..."));
            this.idList = this.tf.getText().replace(';', ',');
            this.fetchById();
        } else if (matcher2.matches()) {
            int n;
            this.panel.frame().output(Globals.lang("Fetching Medline by term ..."));
            String string = this.setupTerm(this.idList);
            SearchResult searchResult = this.getIds(string, 0, 1);
            if (searchResult.count == 0) {
                JOptionPane.showMessageDialog(this.panel.frame(), Globals.lang("No references found"));
                return;
            }
            String string2 = Globals.lang("References found") + ": " + Integer.toString(searchResult.count) + "  " + Globals.lang("Number of references to fetch?");
            String string3 = JOptionPane.showInputDialog(string2, (Object)Integer.toString(searchResult.count));
            if (string3 == null || string3.equals("")) {
                return;
            }
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.panel.output("");
                return;
            }
            ImportInspectionDialog importInspectionDialog = new ImportInspectionDialog(this.panel.frame(), this.panel, BibtexFields.DEFAULT_INSPECTION_FIELDS, Globals.lang("Fetch Medline"), false);
            Util.placeDialog(importInspectionDialog, this.panel.frame());
            importInspectionDialog.setDefaultSelected(false);
            importInspectionDialog.setVisible(true);
            this.keepOn = true;
            importInspectionDialog.addCallBack(new ImportInspectionDialog.CallBack(){

                public void done(int n) {
                    if (n > 0) {
                        MedlineFetcher.this.panel.output(Globals.lang("Medline entries fetched") + ": " + n);
                        MedlineFetcher.this.panel.markBaseChanged();
                    } else {
                        MedlineFetcher.this.panel.output(Globals.lang("No Medline entries found."));
                    }
                }

                public void cancelled() {
                    MedlineFetcher.this.panel.output(Globals.lang("%0 import cancelled.", "Medline"));
                }

                public void stopFetching() {
                    MedlineFetcher.this.keepOn = false;
                }
            });
            for (int i = 0; i < n && this.keepOn; i += 20) {
                searchResult = this.getIds(string, i, 20);
                ArrayList arrayList = MedlineFetcher.fetchMedline(searchResult.ids);
                if (!this.keepOn) break;
                importInspectionDialog.addEntries(arrayList);
                importInspectionDialog.setProgress(i + 20, n);
            }
            importInspectionDialog.entryListComplete();
        }
    }

    public String setupTerm(String string) {
        Pattern pattern = Pattern.compile(", ");
        Pattern pattern2 = Pattern.compile(",");
        Pattern pattern3 = Pattern.compile(" ");
        Matcher matcher = pattern.matcher(string);
        string = matcher.replaceAll("\\+AND\\+");
        matcher = pattern2.matcher(string);
        string = matcher.replaceAll("\\+AND\\+");
        matcher = pattern3.matcher(string);
        string = matcher.replaceAll("+");
        return string;
    }

    public SearchResult getIds(String string, int n, int n2) {
        String string2 = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils";
        String string3 = string2 + "/esearch.fcgi?db=pubmed&retmax=" + Integer.toString(n2) + "&retstart=" + Integer.toString(n) + "&term=";
        Pattern pattern = Pattern.compile("<Id>(\\d+)</Id>");
        Pattern pattern2 = Pattern.compile("<Count>(\\d+)<\\/Count>");
        Pattern pattern3 = Pattern.compile("<RetMax>(\\d+)<\\/RetMax>");
        Pattern pattern4 = Pattern.compile("<RetStart>(\\d+)<\\/RetStart>");
        boolean bl = true;
        SearchResult searchResult = new SearchResult();
        try {
            String string4;
            URL uRL = new URL(string3 + string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                Matcher matcher;
                Matcher matcher2 = pattern.matcher(string4);
                if (matcher2.find()) {
                    searchResult.addID(matcher2.group(1));
                }
                Matcher matcher3 = pattern3.matcher(string4);
                if (matcher2.find()) {
                    searchResult.retmax = Integer.parseInt(matcher3.group(1));
                }
                if ((matcher = pattern4.matcher(string4)).find()) {
                    searchResult.retstart = Integer.parseInt(matcher.group(1));
                }
                Matcher matcher4 = pattern2.matcher(string4);
                if (!bl || !matcher4.find()) continue;
                searchResult.count = Integer.parseInt(matcher4.group(1));
                bl = false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("bad url");
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("connection failed");
            iOException.printStackTrace();
        }
        return searchResult;
    }

    public String[] getTitles(String[] stringArray) {
        String[] stringArray2 = new String[Math.min(10, stringArray.length)];
        for (int i = 0; i < Math.min(10, stringArray.length); ++i) {
            String string = this.getOneCitation(stringArray[i]);
            stringArray2[i] = this.getVitalData(string);
        }
        return stringArray2;
    }

    public String getOneCitation(String string) {
        String string2 = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils";
        String string3 = string2 + "/efetch.fcgi?db=pubmed&retmode=xml&rettype=citation&id=";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string4;
            URL uRL = new URL(string3 + string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string4);
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("bad url");
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("connection failed");
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public String getVitalData(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("<ArticleTitle>(.+)</ArticleTitle>");
        Pattern pattern2 = Pattern.compile("<Author>(.+)</Author>");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            stringBuffer.append("Title: ").append(matcher.group(1));
        }
        return stringBuffer.toString();
    }

    public void done(int n) {
        this.panel.output(Globals.lang("Medline entries fetched") + ": " + n);
    }

    public void cancelled() {
        this.panel.output(Globals.lang("%0 import cancelled.", "Medline"));
    }

    public void stopFetching() {
    }

    public class SearchResult {
        public int count = 0;
        public int retmax = 0;
        public int retstart = 0;
        public String ids = "";
        public ArrayList idList = new ArrayList();

        public void addID(String string) {
            this.idList.add(string);
            this.ids = !this.ids.equals("") ? this.ids + "," + string : string;
        }
    }
}

