/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.util.CaseChanger;

public class IsiImporter
extends ImportFormat {
    static final Pattern isiPattern = Pattern.compile("FN ISI Export Format|VR 1.|PY \\d{4}");
    static Pattern subsupPattern = Pattern.compile("/(sub|sup)\\s+(.*?)\\s*/");

    public String getFormatName() {
        return "ISI";
    }

    public String getCLIId() {
        return "isi";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (!isiPattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    public static void processSubSup(HashMap hashMap) {
        String[] stringArray = new String[]{"title", "abstract", "review", "notes"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!hashMap.containsKey(stringArray[i])) continue;
            Matcher matcher = subsupPattern.matcher((String)hashMap.get(stringArray[i]));
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string = matcher.group(2);
                if ((string = string.replaceAll("\\$", "\\\\\\\\\\\\\\$")).length() > 1) {
                    string = "{" + string + "}";
                }
                if (matcher.group(1).equals("sub")) {
                    matcher.appendReplacement(stringBuffer, "\\$_" + string + "\\$");
                    continue;
                }
                matcher.appendReplacement(stringBuffer, "\\$^" + string + "\\$");
            }
            matcher.appendTail(stringBuffer);
            hashMap.put(stringArray[i], stringBuffer.toString());
        }
    }

    public static void processCapitalization(HashMap hashMap) {
        String[] stringArray = new String[]{"title", "journal", "publisher"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (!hashMap.containsKey(stringArray[i]) || !(string = (String)hashMap.get(stringArray[i])).toUpperCase().equals(string)) continue;
            string = CaseChanger.changeCase(string, 3);
            hashMap.put(stringArray[i], string);
        }
    }

    public List importEntries(InputStream inputStream) throws IOException {
        Object object;
        String string;
        if (inputStream == null) {
            throw new IOException("No stream given.");
        }
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 3) continue;
            if (string.substring(0, 3).equals("PT ")) {
                stringBuffer.append("::").append(string);
                continue;
            }
            object = string.substring(0, 3).trim();
            if (((String)object).length() == 2) {
                stringBuffer.append(" ## ");
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("EOLEOL");
            stringBuffer.append(string.trim());
        }
        object = stringBuffer.toString().split("::");
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < ((String[])object).length; ++i) {
            Object object2;
            Object object3;
            String[] stringArray = object[i].split(" ## ");
            if (stringArray.length == 0) {
                stringArray = ((String)object[i]).split("\n");
            }
            Object object4 = "";
            Object object5 = "";
            Object object6 = "";
            hashMap.clear();
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].length() <= 2) continue;
                object3 = stringArray[j].substring(0, 2);
                object2 = stringArray[j].substring(3);
                if (((String)object2).startsWith(" - ")) {
                    object2 = ((String)object2).substring(3);
                }
                object2 = ((String)object2).trim();
                if (((String)object3).equals("PT")) {
                    object5 = ((String)object2).startsWith("J") ? "article" : object2;
                    object4 = "article";
                    continue;
                }
                if (((String)object3).equals("TY")) {
                    if ("JOUR".equals(object2)) {
                        object4 = "article";
                        continue;
                    }
                    if (!"CONF".equals(object2)) continue;
                    object4 = "inproceedings";
                    continue;
                }
                if (((String)object3).equals("JO")) {
                    hashMap.put("booktitle", object2);
                    continue;
                }
                if (((String)object3).equals("AU")) {
                    String string2 = IsiImporter.isiAuthorsConvert(((String)object2).replaceAll("EOLEOL", " and "));
                    if (hashMap.get("author") != null) {
                        string2 = (String)hashMap.get("author") + " and " + string2;
                    }
                    hashMap.put("author", string2);
                    continue;
                }
                if (((String)object3).equals("TI")) {
                    hashMap.put("title", ((String)object2).replaceAll("EOLEOL", " "));
                    continue;
                }
                if (((String)object3).equals("SO") || ((String)object3).equals("JA")) {
                    hashMap.put("journal", ((String)object2).replaceAll("EOLEOL", " "));
                    continue;
                }
                if (((String)object3).equals("ID") || ((String)object3).equals("KW")) {
                    object2 = ((String)object2).replaceAll("EOLEOL", " ");
                    Object object7 = (String)hashMap.get("keywords");
                    object7 = object7 != null && ((String)object7).indexOf((String)object2) == -1 ? (String)object7 + ", " + (String)object2 : object2;
                    hashMap.put("keywords", object7);
                    continue;
                }
                if (((String)object3).equals("AB")) {
                    hashMap.put("abstract", ((String)object2).replaceAll("EOLEOL", " "));
                    continue;
                }
                if (((String)object3).equals("BP") || ((String)object3).equals("BR") || ((String)object3).equals("SP")) {
                    object6 = object2;
                    continue;
                }
                if (((String)object3).equals("EP")) {
                    int n = ((String)object2).indexOf(32);
                    if (n != -1 && ((String)object2).substring(0, n).trim().length() > 0) {
                        object2 = ((String)object2).substring(0, n);
                    }
                    object6 = (String)object6 + "--" + (String)object2;
                    continue;
                }
                if (((String)object3).equals("PS")) {
                    object6 = IsiImporter.parsePages((String)object2);
                    continue;
                }
                if (((String)object3).equals("AR")) {
                    object6 = object2;
                    continue;
                }
                if (((String)object3).equals("IS")) {
                    hashMap.put("number", object2);
                    continue;
                }
                if (((String)object3).equals("PY")) {
                    hashMap.put("year", object2);
                    continue;
                }
                if (((String)object3).equals("VL")) {
                    hashMap.put("volume", object2);
                    continue;
                }
                if (((String)object3).equals("PU")) {
                    hashMap.put("publisher", object2);
                    continue;
                }
                if (((String)object3).equals("PD")) {
                    String string3 = IsiImporter.parseMonth((String)object2);
                    if (string3 == null) continue;
                    hashMap.put("month", string3);
                    continue;
                }
                if (((String)object3).equals("DT")) {
                    object4 = object2;
                    if (((String)object4).equals("Review")) {
                        object4 = "article";
                        continue;
                    }
                    if (((String)object4).startsWith("Article") || ((String)object4).startsWith("Journal") || ((String)object5).equals("article")) {
                        object4 = "article";
                        continue;
                    }
                    object4 = "misc";
                    continue;
                }
                if (((String)object3).equals("CR")) {
                    hashMap.put("CitedReferences", ((String)object2).replaceAll("EOLEOL", " ; ").trim());
                    continue;
                }
                if (((String)object3).equals("ER") || ((String)object3).equals("EF") || ((String)object3).equals("VR") || ((String)object3).equals("FN")) continue;
                hashMap.put(object3, object2);
            }
            if (!"".equals(object6)) {
                hashMap.put("pages", object6);
            }
            if (hashMap.size() == 0) continue;
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType((String)object4));
            object3 = new ArrayList();
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                String string4 = (String)hashMap.get(e);
                if (string4 != null && string4.trim().length() != 0) continue;
                ((ArrayList)object3).add(e);
            }
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                hashMap.remove(object2.next());
            }
            IsiImporter.processSubSup(hashMap);
            IsiImporter.processCapitalization(hashMap);
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }

    public static String parsePages(String string) {
        int n = string.lastIndexOf("-");
        return string.substring(0, n) + "--" + string.substring(n + 1);
    }

    public static String parseMonth(String string) {
        int n;
        String[] stringArray = string.split("\\s|\\-");
        for (n = 0; n < stringArray.length; ++n) {
            if (!Globals.MONTH_STRINGS.containsKey(stringArray[n].toLowerCase())) continue;
            return "#" + stringArray[n].toLowerCase() + "#";
        }
        for (n = 0; n < stringArray.length; ++n) {
            try {
                int n2 = Integer.parseInt(stringArray[n]);
                if (n2 < 1 || n2 > 12) continue;
                return "#" + Globals.MONTHS[n2 - 1] + "#";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String isiAuthorConvert(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = stringArray[0].trim();
        stringBuffer.append(string2).append(", ");
        String string3 = stringArray[1].trim();
        String[] stringArray2 = string3.split("\\s+");
        for (int i = 0; i < stringArray2.length; ++i) {
            string3 = stringArray2[i];
            if (string3.toUpperCase().equals(string3)) {
                string3 = string3.replaceAll("\\.", "");
                for (int j = 0; j < string3.length(); ++j) {
                    stringBuffer.append(string3.charAt(j)).append(".");
                    if (j >= string3.length() - 1) continue;
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append(string3);
            }
            if (i >= stringArray2.length - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String[] isiAuthorsConvert(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = IsiImporter.isiAuthorConvert(stringArray[i]);
        }
        return stringArray2;
    }

    public static String isiAuthorsConvert(String string) {
        String[] stringArray = IsiImporter.isiAuthorsConvert(string.split(" and |;"));
        return Util.join(stringArray, " and ", 0, stringArray.length);
    }
}

