/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ZipFileChooser;

public class ImportCustomizationDialog
extends JDialog {
    private final JabRefFrame frame;
    private JButton addFromFolderButton = new JButton(Globals.lang("Add from folder"));
    private JButton addFromJarButton = new JButton(Globals.lang("Add from jar"));
    private JButton showDescButton = new JButton(Globals.lang("Show description"));
    private JButton removeButton = new JButton(Globals.lang("Remove"));
    private JButton closeButton = new JButton(Globals.lang("Close"));
    private JButton helpButton = new JButton(Globals.lang("Help"));
    private JPanel buttons = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JTable customImporterTable;
    private JabRefPreferences prefs = Globals.prefs;
    private ImportCustomizationDialog importCustomizationDialog = this;

    public Dimension getSize() {
        int n = 680;
        return new Dimension(n, n / 2);
    }

    private String pathToClass(File file, File file2) {
        String string = null;
        while (!file2.equals(file)) {
            string = file2.getName() + (string != null ? "." + string : "");
            file2 = file2.getParentFile();
        }
        string = string.substring(0, string.lastIndexOf(46));
        return string;
    }

    void addOrReplaceImporter(CustomImportList.Importer importer) {
        this.prefs.customImports.replaceImporter(importer);
        Globals.importFormatReader.resetImportFormats();
        ((ImportTableModel)this.customImporterTable.getModel()).fireTableDataChanged();
    }

    public ImportCustomizationDialog(JabRefFrame jabRefFrame) throws HeadlessException {
        super(jabRefFrame, Globals.lang("Manage custom imports"), false);
        this.frame = jabRefFrame;
        this.addFromFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomImportList.Importer importer = ((ImportCustomizationDialog)ImportCustomizationDialog.this).prefs.customImports.new CustomImportList.Importer();
                importer.setBasePath(Globals.getNewDir(ImportCustomizationDialog.this.frame, new File(ImportCustomizationDialog.this.prefs.get("workingDirectory")), "", Globals.lang("Select Classpath of New Importer"), 2, false));
                String string = Globals.getNewFile(ImportCustomizationDialog.this.frame, importer.getBasePath(), ".class", Globals.lang("Select new ImportFormat Subclass"), 2, false);
                if (string != null) {
                    try {
                        importer.setClassName(ImportCustomizationDialog.this.pathToClass(importer.getBasePath(), new File(string)));
                        importer.setName(importer.getInstance().getFormatName());
                        importer.setCliId(importer.getInstance().getCLIId());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0 %1", string + ":\n", exception.getMessage()));
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        noClassDefFoundError.printStackTrace();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0 %1. Have you chosen the correct package path?", string + ":\n", noClassDefFoundError.getMessage()));
                    }
                    ImportCustomizationDialog.this.addOrReplaceImporter(importer);
                    ImportCustomizationDialog.this.customImporterTable.revalidate();
                    ImportCustomizationDialog.this.customImporterTable.repaint();
                    ImportCustomizationDialog.this.frame.setUpImportMenus();
                }
            }
        });
        this.addFromFolderButton.setToolTipText(Globals.lang("Add a (compiled) custom ImportFormat class from a class path. \nThe path need not be on the classpath of JabRef."));
        this.addFromJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Globals.getNewFile(ImportCustomizationDialog.this.frame, new File(ImportCustomizationDialog.this.prefs.get("workingDirectory")), ".zip,.jar", Globals.lang("Select a Zip-archive"), 2, false);
                ZipFile zipFile = null;
                if (string != null) {
                    try {
                        zipFile = new ZipFile(new File(string), 1);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not open %0 %1", string + ":\n", iOException.getMessage()) + "\n" + Globals.lang("Have you chosen the correct package path?"));
                        return;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        noClassDefFoundError.printStackTrace();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0 %1", string + ":\n", noClassDefFoundError.getMessage()) + "\n" + Globals.lang("Have you chosen the correct package path?"));
                    }
                }
                if (zipFile != null) {
                    ZipFileChooser zipFileChooser = new ZipFileChooser(ImportCustomizationDialog.this.importCustomizationDialog, zipFile);
                    zipFileChooser.setVisible(true);
                }
                ImportCustomizationDialog.this.customImporterTable.revalidate();
                ImportCustomizationDialog.this.customImporterTable.repaint(10L);
                ImportCustomizationDialog.this.frame.setUpImportMenus();
            }
        });
        this.addFromJarButton.setToolTipText(Globals.lang("Add a (compiled) custom ImportFormat class from a Zip-archive.\nThe Zip-archive need not be on the classpath of JabRef."));
        this.showDescButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImportCustomizationDialog.this.customImporterTable.getSelectedRow();
                if (n != -1) {
                    CustomImportList.Importer importer = ((ImportTableModel)ImportCustomizationDialog.this.customImporterTable.getModel()).getImporter(n);
                    try {
                        ImportFormat importFormat = importer.getInstance();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, importFormat.getDescription());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0 %1", importer.getName() + ":\n", exception.getMessage()));
                    }
                } else {
                    JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Please select an importer"));
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImportCustomizationDialog.this.customImporterTable.getSelectedRow();
                if (n != -1) {
                    ImportCustomizationDialog.this.customImporterTable.removeRowSelectionInterval(n, n);
                    ((ImportCustomizationDialog)ImportCustomizationDialog.this).prefs.customImports.remove(((ImportTableModel)ImportCustomizationDialog.this.customImporterTable.getModel()).getImporter(n));
                    Globals.importFormatReader.resetImportFormats();
                    ImportCustomizationDialog.this.customImporterTable.revalidate();
                    ImportCustomizationDialog.this.customImporterTable.repaint();
                    ImportCustomizationDialog.this.frame.setUpImportMenus();
                } else {
                    JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Please select an importer."));
                }
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportCustomizationDialog.this.dispose();
            }
        };
        this.closeButton.addActionListener(abstractAction);
        this.helpButton.addActionListener(new HelpAction(this.frame.helpDiag, GUIGlobals.importCustomizationHelp, "Help"));
        ImportTableModel importTableModel = new ImportTableModel();
        this.customImporterTable = new JTable(importTableModel);
        TableColumnModel tableColumnModel = this.customImporterTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(80);
        tableColumnModel.getColumn(2).setPreferredWidth(200);
        tableColumnModel.getColumn(3).setPreferredWidth(200);
        JScrollPane jScrollPane = new JScrollPane(this.customImporterTable, 20, 31);
        this.customImporterTable.setSelectionMode(0);
        this.customImporterTable.setPreferredScrollableViewportSize(this.getSize());
        if (this.customImporterTable.getRowCount() > 0) {
            this.customImporterTable.setRowSelectionInterval(0, 0);
        }
        ActionMap actionMap = this.mainPanel.getActionMap();
        InputMap inputMap = this.mainPanel.getInputMap(2);
        inputMap.put(this.frame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)jScrollPane, "Center");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(this.addFromFolderButton);
        buttonBarBuilder.addGridded(this.addFromJarButton);
        buttonBarBuilder.addGridded(this.showDescButton);
        buttonBarBuilder.addGridded(this.removeButton);
        buttonBarBuilder.addGridded(this.closeButton);
        buttonBarBuilder.addUnrelatedGap();
        buttonBarBuilder.addGridded(this.helpButton);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.buttons, "South");
        this.setSize(this.getSize());
        this.pack();
        Util.placeDialog(this, this.frame);
        new FocusRequester(this.customImporterTable);
    }

    class ImportTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{Globals.lang("Import name"), Globals.lang("Command line id"), Globals.lang("ImportFormat class"), Globals.lang("Contained in")};

        ImportTableModel() {
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            CustomImportList.Importer importer = this.getImporter(n);
            if (n2 == 0) {
                object = importer.getName();
            } else if (n2 == 1) {
                object = importer.getClidId();
            } else if (n2 == 2) {
                object = importer.getClassName();
            } else if (n2 == 3) {
                object = importer.getBasePath();
            }
            return object;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return Globals.prefs.customImports.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public CustomImportList.Importer getImporter(int n) {
            CustomImportList.Importer[] importerArray = Globals.prefs.customImports.toArray(new CustomImportList.Importer[0]);
            return importerArray[n];
        }
    }
}

