/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JTabbedPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;

public class SortTabsAction
extends MnemonicAwareAction
implements Comparator {
    private JabRefFrame frame;

    public SortTabsAction(JabRefFrame jabRefFrame) {
        this.putValue("Name", "Sort tabs");
        this.putValue("ShortDescription", Globals.lang("Rearrange tabs alphabetically by title"));
        this.frame = jabRefFrame;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        JTabbedPane jTabbedPane = this.frame.getTabbedPane();
        TreeMap<String, BasePanel> treeMap = new TreeMap<String, BasePanel>(this);
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            object = (BasePanel)jTabbedPane.getComponent(i);
            treeMap.put(jTabbedPane.getTitleAt(i), (BasePanel)object);
        }
        jTabbedPane.removeAll();
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            BasePanel basePanel = (BasePanel)treeMap.get(object);
            jTabbedPane.addTab((String)object, basePanel);
        }
    }

    public int compare(Object object, Object object2) {
        return ((String)object).toLowerCase().compareTo(((String)object2).toLowerCase());
    }
}

