/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.GroupTreeNode;

public class UndoableChangeAssignment
extends AbstractUndoableEdit {
    private final Set m_previousAssignmentBackup;
    private final Set m_newAssignmentBackup;
    private int[] m_pathToNode = null;
    private GroupTreeNode m_groupsRootHandle = null;

    public UndoableChangeAssignment(Set set, Set set2) {
        this.m_previousAssignmentBackup = new HashSet(set);
        this.m_newAssignmentBackup = new HashSet(set2);
    }

    public UndoableChangeAssignment(Set set, Set set2, GroupTreeNode groupTreeNode) {
        this(set, set2);
        this.setEditedNode(groupTreeNode);
    }

    public void setEditedNode(GroupTreeNode groupTreeNode) {
        this.m_groupsRootHandle = (GroupTreeNode)groupTreeNode.getRoot();
        this.m_pathToNode = groupTreeNode.getIndexedPath();
    }

    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("change assignment of entries");
    }

    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("change assignment of entries");
    }

    public void undo() {
        super.undo();
        ExplicitGroup explicitGroup = (ExplicitGroup)this.m_groupsRootHandle.getChildAt(this.m_pathToNode).getGroup();
        explicitGroup.clearAssignments();
        Iterator iterator = this.m_previousAssignmentBackup.iterator();
        while (iterator.hasNext()) {
            explicitGroup.addEntry((BibtexEntry)iterator.next());
        }
    }

    public void redo() {
        super.redo();
        ExplicitGroup explicitGroup = (ExplicitGroup)this.m_groupsRootHandle.getChildAt(this.m_pathToNode).getGroup();
        explicitGroup.clearAssignments();
        Iterator iterator = this.m_newAssignmentBackup.iterator();
        while (iterator.hasNext()) {
            explicitGroup.addEntry((BibtexEntry)iterator.next());
        }
    }
}

