/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.GroupTreeNode;

public class GroupTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected Object highlight1Cell = null;
    protected Object[] highlight2Cells = null;
    protected Object[] highlight3Cells = null;
    protected Object highlightBorderCell = null;
    public static ImageIcon groupRefiningIcon = GUIGlobals.getImage("groupRefining");
    public static ImageIcon groupIncludingIcon = GUIGlobals.getImage("groupIncluding");
    public static ImageIcon groupRegularIcon = null;

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Component component;
        block24: {
            JLabel jLabel;
            block23: {
                int n2;
                if (object == this.highlight1Cell) {
                    bl = true;
                }
                component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (!(object instanceof GroupTreeNode)) {
                    return component;
                }
                AbstractGroup abstractGroup = ((GroupTreeNode)object).getGroup();
                if (abstractGroup == null || !(component instanceof JLabel)) {
                    return component;
                }
                jLabel = (JLabel)component;
                if (this.highlightBorderCell != null && this.highlightBorderCell == object) {
                    jLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                } else {
                    jLabel.setBorder(BorderFactory.createEmptyBorder());
                }
                boolean bl5 = Globals.prefs.getBoolean("groupShowDynamic") && abstractGroup.isDynamic();
                boolean bl6 = false;
                if (this.highlight2Cells != null) {
                    for (n2 = 0; n2 < this.highlight2Cells.length; ++n2) {
                        if (this.highlight2Cells[n2] != object) continue;
                        bl6 = true;
                        break;
                    }
                }
                n2 = 0;
                if (this.highlight3Cells != null) {
                    for (int i = 0; i < this.highlight3Cells.length; ++i) {
                        if (this.highlight3Cells[i] != object) continue;
                        n2 = 1;
                        break;
                    }
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                if (bl6) {
                    stringBuffer.append("<font color=\"#FF0000\">");
                }
                if (n2 != 0) {
                    stringBuffer.append("<u>");
                }
                if (bl5) {
                    stringBuffer.append("<i>");
                }
                stringBuffer.append(Util.quoteForHTML(abstractGroup.getName()));
                if (bl5) {
                    stringBuffer.append("</i>");
                }
                if (n2 != 0) {
                    stringBuffer.append("</u>");
                }
                if (bl6) {
                    stringBuffer.append("</font>");
                }
                stringBuffer.append("</html>");
                String string = stringBuffer.toString();
                if (!jLabel.getText().equals(string)) {
                    jLabel.setText(string);
                }
                jLabel.setToolTipText("<html>" + abstractGroup.getShortDescription() + "</html>");
                if (!Globals.prefs.getBoolean("groupShowIcons")) break block23;
                switch (abstractGroup.getHierarchicalContext()) {
                    case 1: {
                        if (jLabel.getIcon() != groupRefiningIcon) {
                            jLabel.setIcon(groupRefiningIcon);
                            break;
                        }
                        break block24;
                    }
                    case 2: {
                        if (jLabel.getIcon() != groupIncludingIcon) {
                            jLabel.setIcon(groupIncludingIcon);
                            break;
                        }
                        break block24;
                    }
                    default: {
                        if (jLabel.getIcon() != groupRegularIcon) {
                            jLabel.setIcon(groupRegularIcon);
                            break;
                        }
                        break block24;
                    }
                }
                break block24;
            }
            jLabel.setIcon(null);
        }
        return component;
    }

    void setHighlight1Cell(Object object) {
        this.highlight1Cell = object;
    }

    void setHighlight2Cells(Object[] objectArray) {
        this.highlight2Cells = objectArray;
    }

    void setHighlight3Cells(Object[] objectArray) {
        this.highlight3Cells = objectArray;
    }

    void setHighlightBorderCell(Object object) {
        this.highlightBorderCell = object;
    }
}

