/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.KeywordGroup;
import net.sf.jabref.groups.UndoableAddOrRemoveGroup;
import net.sf.jabref.undo.NamedCompound;

class AutoGroupDialog
extends JDialog
implements CaretListener {
    JTextField remove = new JTextField(60);
    JTextField field = new JTextField(60);
    JTextField deliminator = new JTextField(60);
    JLabel nf = new JLabel(Globals.lang("Field to group by") + ":");
    JLabel nr = new JLabel(Globals.lang("Characters to ignore") + ":");
    JCheckBox nd = new JCheckBox(Globals.lang("Use the following delimiter character(s)") + ":");
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JPanel main = new JPanel();
    JPanel opt = new JPanel();
    private boolean ok_pressed = false;
    private GroupTreeNode m_groupsRoot;
    private JabRefFrame frame;
    private BasePanel panel;
    private GroupSelector gs;
    private String oldRemove;
    private String oldField;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();

    public AutoGroupDialog(JabRefFrame jabRefFrame, BasePanel basePanel, GroupSelector groupSelector, GroupTreeNode groupTreeNode, String string, String string2, String string3) {
        super(jabRefFrame, Globals.lang("Automatically create groups"), true);
        this.frame = jabRefFrame;
        this.gs = groupSelector;
        this.panel = basePanel;
        this.m_groupsRoot = groupTreeNode;
        this.field.setText(string);
        this.remove.setText(string2);
        this.deliminator.setText(string3);
        this.nd.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                AutoGroupDialog.this.ok_pressed = true;
                AutoGroupDialog.this.dispose();
                GroupTreeNode groupTreeNode = new GroupTreeNode(new ExplicitGroup(Globals.lang("Automatically created groups"), 2));
                HashSet hashSet = null;
                hashSet = AutoGroupDialog.this.nd.isSelected() ? Util.findDeliminatedWordsInField(AutoGroupDialog.this.panel.getDatabase(), AutoGroupDialog.this.field().toLowerCase().trim(), AutoGroupDialog.this.deliminator.getText()) : Util.findAllWordsInField(AutoGroupDialog.this.panel.getDatabase(), AutoGroupDialog.this.field().toLowerCase().trim(), AutoGroupDialog.this.remove());
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next().toString();
                    object = new KeywordGroup((String)object2, AutoGroupDialog.this.field(), (String)object2, false, false, 0);
                    groupTreeNode.add(new GroupTreeNode((AbstractGroup)object));
                }
                AutoGroupDialog.this.m_groupsRoot.add(groupTreeNode);
                object2 = new NamedCompound(Globals.lang("Autogenerate groups"));
                object = new UndoableAddOrRemoveGroup(AutoGroupDialog.this.gs, AutoGroupDialog.this.m_groupsRoot, groupTreeNode, 0);
                ((UndoableAddOrRemoveGroup)object).setRevalidate(true);
                ((CompoundEdit)object2).addEdit((UndoableEdit)object);
                AutoGroupDialog.this.panel.markBaseChanged();
                AutoGroupDialog.this.gs.revalidateGroups();
                AutoGroupDialog.this.frame.output(Globals.lang("Created groups."));
                ((CompoundEdit)object2).end();
                ((AutoGroupDialog)AutoGroupDialog.this).panel.undoManager.addEdit((UndoableEdit)object2);
            }
        };
        this.remove.addActionListener(actionListener);
        this.field.addActionListener(actionListener);
        this.field.addCaretListener(this);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutoGroupDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(abstractAction);
        this.ok.addActionListener(actionListener);
        ActionMap actionMap = this.main.getActionMap();
        InputMap inputMap = this.main.getInputMap(2);
        inputMap.put(this.frame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        this.main.setLayout(this.gbl);
        this.opt.setLayout(this.gbl);
        this.main.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Group properties")));
        this.con.weightx = 0.0;
        this.con.gridwidth = 1;
        this.con.insets = new Insets(3, 5, 3, 5);
        this.con.anchor = 13;
        this.con.fill = 0;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.nf, this.con);
        this.main.add(this.nf);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.nr, this.con);
        this.main.add(this.nr);
        this.con.gridy = 2;
        this.gbl.setConstraints(this.nd, this.con);
        this.main.add(this.nd);
        this.con.weightx = 1.0;
        this.con.anchor = 17;
        this.con.fill = 2;
        this.con.gridy = 0;
        this.con.gridx = 1;
        this.gbl.setConstraints(this.field, this.con);
        this.main.add(this.field);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.remove, this.con);
        this.main.add(this.remove);
        this.con.gridy = 2;
        this.gbl.setConstraints(this.deliminator, this.con);
        this.main.add(this.deliminator);
        this.con.gridx = -1;
        this.con.gridy = -1;
        this.con.weightx = 1.0;
        this.con.gridwidth = 1;
        this.con.anchor = 13;
        this.con.fill = 0;
        this.gbl.setConstraints(this.ok, this.con);
        this.opt.add(this.ok);
        this.con.anchor = 17;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.cancel, this.con);
        this.opt.add(this.cancel);
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)this.opt, "South");
        this.updateComponents();
        this.setSize(400, 200);
        Util.placeDialog(this, this.frame);
    }

    public boolean okPressed() {
        return this.ok_pressed;
    }

    public String oldField() {
        return this.oldField;
    }

    public String oldRemove() {
        return this.oldRemove;
    }

    public String field() {
        return this.field.getText();
    }

    public String remove() {
        return this.remove.getText();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.updateComponents();
    }

    protected void updateComponents() {
        String string = this.field.getText().trim();
        this.ok.setEnabled(string.matches("\\w+"));
    }
}

