/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.external.PushToApplication;
import net.sf.jabref.external.PushToApplicationAction;
import net.sf.jabref.external.PushToEmacs;
import net.sf.jabref.external.PushToLatexEditor;
import net.sf.jabref.external.PushToLyx;
import net.sf.jabref.external.PushToWinEdt;

public class PushToApplicationButton
implements ActionListener {
    public static List applications;
    private JabRefFrame frame;
    private List pushActions;
    private JPanel comp;
    private JButton pushButton;
    private JButton menuButton;
    private int selected = 0;
    private JPopupMenu popup = null;
    private HashMap actions = new HashMap();
    private final Dimension buttonDim = new Dimension(23, 23);
    private static final URL ARROW_ICON;
    private MenuAction mAction = new MenuAction();

    public PushToApplicationButton(JabRefFrame jabRefFrame, List list) {
        this.frame = jabRefFrame;
        this.pushActions = list;
        this.init();
    }

    private void init() {
        this.comp = new JPanel();
        this.comp.setLayout(new BorderLayout());
        this.menuButton = new JButton(new ImageIcon(ARROW_ICON));
        this.menuButton.setMargin(new Insets(0, 0, 0, 0));
        this.menuButton.setPreferredSize(new Dimension(this.menuButton.getIcon().getIconWidth(), this.menuButton.getIcon().getIconHeight()));
        this.menuButton.addActionListener(new MenuButtonActionListener());
        this.menuButton.setToolTipText(Globals.lang("Select external application"));
        this.pushButton = new JButton();
        if (Globals.prefs.hasKey("pushToApplication")) {
            String string = Globals.prefs.get("pushToApplication");
            for (int i = 0; i < this.pushActions.size(); ++i) {
                PushToApplication pushToApplication = (PushToApplication)this.pushActions.get(i);
                if (!pushToApplication.getName().equals(string)) continue;
                this.selected = i;
                break;
            }
        }
        this.setSelected(this.selected);
        this.pushButton.addActionListener(this);
        this.comp.add((Component)this.pushButton, "Center");
        this.comp.add((Component)this.menuButton, "East");
        this.comp.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.comp.setMaximumSize(this.comp.getPreferredSize());
    }

    private void buildPopupMenu() {
        this.popup = new JPopupMenu();
        int n = 0;
        Iterator iterator = this.pushActions.iterator();
        while (iterator.hasNext()) {
            PushToApplication pushToApplication = (PushToApplication)iterator.next();
            JMenuItem jMenuItem = new JMenuItem(pushToApplication.getApplicationName(), pushToApplication.getIcon());
            jMenuItem.addActionListener(new PopupItemActionListener(n));
            this.popup.add(jMenuItem);
            ++n;
        }
    }

    private void setSelected(int n) {
        this.selected = n;
        PushToApplication pushToApplication = (PushToApplication)this.pushActions.get(n);
        this.pushButton.setIcon(pushToApplication.getIcon());
        this.pushButton.setToolTipText(pushToApplication.getTooltip());
        this.pushButton.setPreferredSize(this.buttonDim);
        Globals.prefs.put("pushToApplication", pushToApplication.getName());
        this.mAction.setTitle(pushToApplication.getApplicationName());
    }

    public Component getComponent() {
        return this.comp;
    }

    public Action getMenuAction() {
        return this.mAction;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PushToApplication pushToApplication = (PushToApplication)this.pushActions.get(this.selected);
        PushToApplicationAction pushToApplicationAction = (PushToApplicationAction)this.actions.get(pushToApplication);
        if (pushToApplicationAction == null) {
            pushToApplicationAction = new PushToApplicationAction(this.frame, pushToApplication);
            this.actions.put(pushToApplication, pushToApplicationAction);
        }
        pushToApplicationAction.actionPerformed(new ActionEvent(pushToApplication, 0, "push"));
    }

    static {
        ARROW_ICON = GUIGlobals.class.getResource("/images/secondary_sorted_reverse.png");
        applications = new ArrayList();
        applications.add(new PushToLyx());
        applications.add(new PushToEmacs());
        applications.add(new PushToWinEdt());
        applications.add(new PushToLatexEditor());
    }

    class MenuAction
    extends MnemonicAwareAction {
        public MenuAction() {
            this.putValue("AcceleratorKey", Globals.prefs.getKey("Push to application"));
        }

        public void setTitle(String string) {
            this.putValue("Name", Globals.lang("Push entries to external application (%0)", string));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PushToApplicationButton.this.actionPerformed(null);
        }
    }

    class MenuButtonActionListener
    implements ActionListener {
        MenuButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PushToApplicationButton.this.popup == null) {
                PushToApplicationButton.this.buildPopupMenu();
            }
            PushToApplicationButton.this.popup.show(PushToApplicationButton.this.comp, 0, PushToApplicationButton.this.menuButton.getHeight());
        }
    }

    class PopupItemActionListener
    implements ActionListener {
        private int index;

        public PopupItemActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PushToApplicationButton.this.setSelected(this.index);
            PushToApplicationButton.this.actionPerformed(null);
            PushToApplicationButton.this.pushButton.requestFocus();
        }
    }
}

