/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.external.PushToApplication;

public class PushToApplicationAction
extends AbstractAction
implements Runnable {
    private PushToApplication operation;
    private JabRefFrame frame;
    private BasePanel panel;
    private BibtexEntry[] entries;

    public PushToApplicationAction(JabRefFrame jabRefFrame, PushToApplication pushToApplication) {
        this.frame = jabRefFrame;
        this.putValue("SmallIcon", pushToApplication.getIcon());
        this.putValue("Name", pushToApplication.getName());
        this.putValue("ShortDescription", pushToApplication.getTooltip());
        if (pushToApplication.getKeyStrokeName() != null) {
            this.putValue("AcceleratorKey", Globals.prefs.getKey(pushToApplication.getKeyStrokeName()));
        }
        this.operation = pushToApplication;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.panel = this.frame.basePanel();
        if (this.panel == null) {
            return;
        }
        this.entries = this.panel.getSelectedEntries();
        if (this.entries.length == 0) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("This operation requires one or more entries to be selected."), (String)this.getValue("Name"), 0);
            return;
        }
        if (this.operation.requiresBibtexKeys()) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].getCiteKey() != null && this.entries[i].getCiteKey().trim().length() != 0) continue;
                JOptionPane.showMessageDialog(this.frame, Globals.lang("This operation requires all selected entries to have BibTex keys defined."), (String)this.getValue("Name"), 0);
                return;
            }
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        this.operation.pushEntries(this.entries, this.getKeyString(this.entries));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PushToApplicationAction.this.operation.operationCompleted(PushToApplicationAction.this.panel);
            }
        });
    }

    protected String getKeyString(BibtexEntry[] bibtexEntryArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        boolean bl = true;
        for (int i = 0; i < bibtexEntryArray.length; ++i) {
            BibtexEntry bibtexEntry = bibtexEntryArray[i];
            string = (String)bibtexEntry.getField("bibtexkey");
            if (string == null || string.equals("")) continue;
            if (bl) {
                stringBuffer.append(string);
                bl = false;
                continue;
            }
            stringBuffer.append(",").append(string);
        }
        return stringBuffer.toString();
    }
}

