/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.transform.TransformerException;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.UrlDragDrop;
import net.sf.jabref.Util;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.util.XMPUtil;

public class ExternalFilePanel
extends JPanel {
    private JButton browseBut;
    private JButton download;
    private JButton auto;
    private JButton xmp;
    private EntryEditor entryEditor;
    private FieldEditor fieldEditor;
    private JabRefFrame frame;
    private OpenFileFilter off;
    private BibtexEntry entry = null;
    private MetaData metaData;

    public ExternalFilePanel(String string, MetaData metaData, BibtexEntry bibtexEntry, FieldEditor fieldEditor, OpenFileFilter openFileFilter) {
        this(null, metaData, null, string, openFileFilter, null);
        this.entry = bibtexEntry;
        this.entryEditor = null;
        this.fieldEditor = fieldEditor;
    }

    public ExternalFilePanel(final JabRefFrame jabRefFrame, MetaData metaData, final EntryEditor entryEditor, final String string, OpenFileFilter openFileFilter, final FieldEditor fieldEditor) {
        this.frame = jabRefFrame;
        this.metaData = metaData;
        this.off = openFileFilter;
        this.entryEditor = entryEditor;
        this.fieldEditor = null;
        this.setLayout(new GridLayout(2, 2));
        this.browseBut = new JButton(Globals.lang("Browse"));
        this.download = new JButton(Globals.lang("Download"));
        this.auto = new JButton(Globals.lang("Auto"));
        this.xmp = new JButton(Globals.lang("Write XMP"));
        this.xmp.setToolTipText(Globals.lang("Write BibtexEntry as XMP-metadata to PDF."));
        this.browseBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFilePanel.this.browseFile(string, fieldEditor);
                entryEditor.storeFieldAction.actionPerformed(new ActionEvent(fieldEditor, 0, ""));
            }
        });
        this.download.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFilePanel.this.downLoadFile(string, fieldEditor, jabRefFrame);
            }
        });
        this.auto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFilePanel.this.autoSetFile(string, fieldEditor);
            }
        });
        this.xmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFilePanel.this.pushXMP(string, fieldEditor);
            }
        });
        this.add(this.browseBut);
        this.add(this.download);
        this.add(this.auto);
        this.add(this.xmp);
        if (fieldEditor != null) {
            ((JComponent)((Object)fieldEditor)).setDropTarget(new DropTarget((Component)((Object)fieldEditor), 0, new UrlDragDrop(entryEditor, jabRefFrame, fieldEditor)));
        }
    }

    public void setEntry(BibtexEntry bibtexEntry) {
        this.entry = bibtexEntry;
    }

    public BibtexEntry getEntry() {
        return this.entry != null ? this.entry : this.entryEditor.getEntry();
    }

    protected Object getKey() {
        return this.getEntry().getField("bibtexkey");
    }

    protected void output(String string) {
        if (this.frame != null) {
            this.frame.output(string);
        }
    }

    public void pushXMP(final String string, final FieldEditor fieldEditor) {
        new Thread(){

            public void run() {
                File file;
                ExternalFilePanel.this.output(Globals.lang("Looking for pdf..."));
                String string2 = ExternalFilePanel.this.metaData.getFileDirectory(string);
                File file2 = null;
                if (string2 != null && (file = Util.expandFilename(fieldEditor.getText(), new String[]{string2, "."})) != null) {
                    file2 = file;
                }
                if (file2 == null) {
                    file2 = new File(fieldEditor.getText());
                }
                if (file2 == null) {
                    ExternalFilePanel.this.output(Globals.lang("No file associated"));
                    return;
                }
                file = file2;
                ExternalFilePanel.this.output(Globals.lang("Writing XMP to '%0'...", file.getName()));
                try {
                    XMPUtil.writeXMP(file, ExternalFilePanel.this.getEntry());
                    ExternalFilePanel.this.output(Globals.lang("Wrote XMP to '%0'.", file.getName()));
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(fieldEditor.getParent(), Globals.lang("Error writing XMP to file: %0", iOException.getLocalizedMessage()), Globals.lang("Writing XMP"), 0);
                    Globals.logger(Globals.lang("Error while writing XMP %0", file.getAbsolutePath()));
                    ExternalFilePanel.this.output(Globals.lang("Error writing XMP to '%0'...", file.getName()));
                }
                catch (TransformerException transformerException) {
                    JOptionPane.showMessageDialog(fieldEditor.getParent(), Globals.lang("Error converting Bibtex to XMP: %0", transformerException.getLocalizedMessage()), Globals.lang("Writing XMP"), 0);
                    Globals.logger(Globals.lang("Error while converting BibtexEntry to XMP %0", file.getAbsolutePath()));
                    ExternalFilePanel.this.output(Globals.lang("Error converting XMP to '%0'...", file.getName()));
                }
            }
        }.start();
    }

    public void browseFile(String string, FieldEditor fieldEditor) {
        String string2;
        String string3 = this.metaData.getFileDirectory(string);
        if (string3 != null && string3.equals("")) {
            string3 = null;
        }
        String string4 = fieldEditor.getText();
        String string5 = null;
        if (string3 == null || !new File(string4).isAbsolute()) {
            string4 = string3 != null ? string3 : Globals.prefs.get(string + "_dir", "");
        }
        if ((string2 = Globals.getNewFile(this.frame, new File(string4), "." + string, 0, false)) != null) {
            File file = new File(string2);
            String string6 = file.getParent();
            if (string3 != null && string6.startsWith(string3)) {
                String string7 = string6.substring(string3.length(), string6.length()) + File.separator + file.getName();
                if (string7.startsWith(File.separator)) {
                    string7 = string7.substring(File.separator.length(), string7.length());
                }
                string5 = string7;
            } else {
                string5 = file.getPath();
            }
            fieldEditor.setText(string5);
            Globals.prefs.put(string + "_dir", file.getPath());
        }
    }

    public void downLoadFile(final String string, final FieldEditor fieldEditor, final Component component) {
        final String string2 = JOptionPane.showInputDialog(component, (Object)Globals.lang("Enter URL to download"));
        if (string2 == null || string2.trim().length() == 0) {
            return;
        }
        final BibtexEntry bibtexEntry = this.entryEditor != null ? this.entryEditor.getEntry() : this.entry;
        new Thread(){

            public String getPlannedFileName(String string4) {
                String string22 = ExternalFilePanel.this.off.getSuffix(string4);
                if (string22 == null) {
                    string22 = "." + string.toLowerCase();
                }
                String string3 = null;
                if (ExternalFilePanel.this.getKey() != null) {
                    string3 = ExternalFilePanel.this.getKey() + string22;
                } else {
                    string3 = JOptionPane.showInputDialog(component, (Object)Globals.lang("BibTeX key not set. Enter a name for the downloaded file"));
                    if (string3 != null && !ExternalFilePanel.this.off.accept(string3)) {
                        string3 = string3 + string22;
                    }
                }
                if (Globals.ON_WIN) {
                    string3 = string3.replaceAll("\\?|\\*|\\<|\\>|\\||\\\"|\\:|\\.$|\\[|\\]", "");
                } else if (Globals.ON_MAC) {
                    string3 = string3.replaceAll(":", "");
                }
                return string3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string5 = fieldEditor.getText();
                fieldEditor.setEnabled(false);
                boolean bl = true;
                try {
                    fieldEditor.setText(Globals.lang("Downloading..."));
                    ExternalFilePanel.this.output(Globals.lang("Downloading..."));
                    String string22 = this.getPlannedFileName(string2);
                    String string3 = ExternalFilePanel.this.metaData.getFileDirectory(string);
                    if (!new File(string3).exists()) {
                        JOptionPane.showMessageDialog(component, Globals.lang("Could not find directory for %0-files: %1", string, string3), Globals.lang("Download file"), 0);
                        Globals.logger(Globals.lang("Could not find directory for %0-files: %1", string, string3));
                        return;
                    }
                    File file = new File(new File(string3), string22);
                    URL uRL = new URL(string2);
                    URLDownload uRLDownload = new URLDownload(component, uRL, file);
                    try {
                        uRLDownload.download();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(component, Globals.lang("Invalid URL: " + iOException.getMessage()), Globals.lang("Download file"), 0);
                        Globals.logger("Error while downloading " + uRL.toString());
                        if (bl) {
                            fieldEditor.setText(string5);
                            fieldEditor.setEnabled(true);
                        }
                        return;
                    }
                    ExternalFilePanel.this.output(Globals.lang("Download completed"));
                    String string4 = file.getPath();
                    if (string4.startsWith(string3) && (string4 = string4.substring(string3.length(), string4.length())).startsWith(File.separator)) {
                        string4 = string4.substring(File.separator.length());
                    }
                    if (ExternalFilePanel.this.entryEditor == null || ExternalFilePanel.this.entryEditor.getEntry() != bibtexEntry) {
                        bibtexEntry.setField(string, string4);
                        if (fieldEditor != null) {
                            fieldEditor.setText(string4);
                            fieldEditor.setEnabled(true);
                        }
                        bl = false;
                    } else {
                        fieldEditor.setText(string4);
                        fieldEditor.setEnabled(true);
                        bl = false;
                        SwingUtilities.invokeLater(new Thread(){

                            public void run() {
                                ExternalFilePanel.this.entryEditor.updateField(fieldEditor);
                            }
                        });
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    JOptionPane.showMessageDialog(component, Globals.lang("Invalid URL"), Globals.lang("Download file"), 0);
                }
                finally {
                    if (bl) {
                        fieldEditor.setText(string5);
                        fieldEditor.setEnabled(true);
                    }
                }
            }
        }.start();
    }

    public Thread autoSetFile(final String string, final FieldEditor fieldEditor) {
        Object object = this.getKey();
        if (object == null || Globals.prefs.get(string + "Directory") == null) {
            this.output(Globals.lang("You must set both BibTeX key and %0 directory", string.toUpperCase()) + ".");
            return null;
        }
        this.output(Globals.lang("Searching for %0 file", string.toUpperCase()) + " '" + object + "." + string + "'...");
        Thread thread = new Thread(){

            public void run() {
                Object object = ExternalFilePanel.this.getKey();
                LinkedList<String> linkedList = new LinkedList<String>();
                linkedList.add(ExternalFilePanel.this.metaData.getFileDirectory(string));
                linkedList.add(".");
                String string2 = Util.findPdf(ExternalFilePanel.this.getEntry(), string, linkedList.toArray(new String[linkedList.size()]));
                if (string2 != null) {
                    fieldEditor.setText(string2);
                    if (ExternalFilePanel.this.entryEditor != null) {
                        ExternalFilePanel.this.entryEditor.updateField(fieldEditor);
                    }
                    ExternalFilePanel.this.output(Globals.lang("%0 field set", string.toUpperCase()) + ".");
                } else {
                    ExternalFilePanel.this.output(Globals.lang("No %0 found", string.toUpperCase()) + ".");
                }
            }
        };
        thread.start();
        return thread;
    }
}

