/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout;

import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.NameFormatterTab;
import net.sf.jabref.Util;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.export.layout.format.NameFormat;
import wsi.ra.tool.WSITools;
import wsi.ra.types.StringInt;

public class LayoutEntry {
    private LayoutFormatter[] option;
    private String text;
    private LayoutEntry[] layoutEntries;
    private int type;
    private String classPrefix;

    public LayoutEntry(StringInt stringInt, String string) throws Exception {
        this.type = stringInt.i;
        this.classPrefix = string;
        if (stringInt.i == 1) {
            this.text = stringInt.s;
        } else if (stringInt.i == 2) {
            this.text = stringInt.s.trim();
        } else if (stringInt.i != 3 && stringInt.i != 4 && stringInt.i == 5) {
            Vector vector = new Vector();
            WSITools.tokenize(vector, stringInt.s, "\n");
            if (vector.size() == 1) {
                this.text = (String)vector.get(0);
            } else {
                this.text = ((String)vector.get(0)).trim();
                this.option = LayoutEntry.getOptionalLayout((String)vector.get(1), this.classPrefix);
            }
        }
    }

    public LayoutEntry(Vector vector, String string, int n) throws Exception {
        int n2;
        this.classPrefix = string;
        String string2 = null;
        String string3 = null;
        Vector<StringInt> vector2 = null;
        Vector<LayoutEntry> vector3 = new Vector<LayoutEntry>();
        StringInt stringInt = (StringInt)vector.get(0);
        string2 = stringInt.s;
        stringInt = (StringInt)vector.get(vector.size() - 1);
        string3 = stringInt.s;
        if (!string2.equals(string3)) {
            System.err.println("Field start and end entry must be equal.");
        }
        this.type = n;
        this.text = stringInt.s;
        for (n2 = 1; n2 < vector.size() - 1; ++n2) {
            stringInt = (StringInt)vector.get(n2);
            if (stringInt.i != 1 && stringInt.i != 2) {
                if (stringInt.i == 3 || stringInt.i == 6) {
                    vector2 = new Vector<StringInt>();
                    string2 = stringInt.s;
                } else if (stringInt.i == 4 || stringInt.i == 7) {
                    if (string2.equals(stringInt.s)) {
                        vector2.add(stringInt);
                        LayoutEntry layoutEntry = stringInt.i == 7 ? new LayoutEntry(vector2, this.classPrefix, 6) : new LayoutEntry(vector2, this.classPrefix, 3);
                        vector3.add(layoutEntry);
                        vector2 = null;
                    } else {
                        System.out.println("Nested field entries are not implemented !!!");
                    }
                } else if (stringInt.i == 5) {
                    // empty if block
                }
            }
            if (vector2 == null) {
                vector3.add(new LayoutEntry(stringInt, this.classPrefix));
                continue;
            }
            vector2.add(stringInt);
        }
        this.layoutEntries = new LayoutEntry[vector3.size()];
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            this.layoutEntries[n2] = (LayoutEntry)vector3.get(n2);
        }
    }

    public String doLayout(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        switch (this.type) {
            case 1: {
                return this.text;
            }
            case 2: {
                return this.getField(bibtexEntry, this.text, bibtexDatabase);
            }
            case 3: 
            case 6: {
                String string = this.getField(bibtexEntry, this.text, bibtexDatabase);
                if (string == null || this.type == 6 && string.equalsIgnoreCase(LayoutHelper.getCurrentGroup())) {
                    return null;
                }
                if (this.type == 6) {
                    LayoutHelper.setCurrentGroup(string);
                }
                StringBuffer stringBuffer = new StringBuffer(100);
                boolean bl = false;
                for (int i = 0; i < this.layoutEntries.length; ++i) {
                    String string2 = this.layoutEntries[i].doLayout(bibtexEntry, bibtexDatabase);
                    if (string2 == null) {
                        if (i + 1 < this.layoutEntries.length && this.layoutEntries[i + 1].doLayout(bibtexEntry, bibtexDatabase).trim().length() == 0) {
                            ++i;
                            bl = true;
                            continue;
                        }
                    } else if (bl) {
                        int n;
                        for (n = 0; n < string2.length() && (string2.charAt(n) == '\n' || string2.charAt(n) == '\r'); ++n) {
                        }
                        if (n < string2.length()) {
                            stringBuffer.append(string2.substring(n));
                        }
                    } else {
                        stringBuffer.append(string2);
                    }
                    bl = false;
                }
                return stringBuffer.toString();
            }
            case 4: 
            case 7: {
                return "";
            }
            case 5: {
                String string;
                if (this.text.equals("bibtextype")) {
                    string = bibtexEntry.getType().getName();
                } else {
                    String string3 = this.text.startsWith("\\") ? this.getField(bibtexEntry, this.text.substring(1), bibtexDatabase) : this.getText(this.text, bibtexDatabase);
                    string = string3 == null ? "" : string3;
                }
                if (this.option != null) {
                    for (int i = 0; i < this.option.length; ++i) {
                        string = this.option[i].format(string);
                    }
                }
                return string;
            }
        }
        return "";
    }

    public String doLayout(BibtexDatabase bibtexDatabase) {
        if (this.type == 1) {
            return this.text;
        }
        if (this.type == 2) {
            throw new UnsupportedOperationException("bibtext entry fields not allowed in begin or end layout");
        }
        if (this.type == 3 || this.type == 6) {
            throw new UnsupportedOperationException("field and group starts not allowed in begin or end layout");
        }
        if (this.type == 4 || this.type == 7) {
            throw new UnsupportedOperationException("field and group ends not allowed in begin or end layout");
        }
        if (this.type == 5) {
            String string = this.getText(this.text, bibtexDatabase);
            if (this.option != null) {
                for (int i = 0; i < this.option.length; ++i) {
                    string = this.option[i].format(string);
                }
            }
            return string;
        }
        return "";
    }

    public static LayoutFormatter getLayoutFormatter(String string, String string2) throws Exception {
        LayoutFormatter layoutFormatter = null;
        if (string.length() > 0) {
            try {
                try {
                    layoutFormatter = (LayoutFormatter)Class.forName(string2 + string).newInstance();
                }
                catch (Throwable throwable) {
                    layoutFormatter = (LayoutFormatter)Class.forName(string).newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Exception(Globals.lang("Formatter not found") + ": " + string);
            }
            catch (InstantiationException instantiationException) {
                throw new Exception(string + " can not be instantiated.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Exception(string + " can't be accessed.");
            }
        }
        return layoutFormatter;
    }

    public static LayoutFormatter[] getOptionalLayout(String string, String string2) throws Exception {
        ArrayList arrayList = Util.parseMethodsCalls(string);
        ArrayList<LayoutFormatter> arrayList2 = new ArrayList<LayoutFormatter>(arrayList.size());
        Map map = NameFormatterTab.getNameFormatters();
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray = (String[])arrayList.get(i);
            String string3 = stringArray[0].trim();
            try {
                LayoutFormatter layoutFormatter = LayoutEntry.getLayoutFormatter(string3, string2);
                arrayList2.add(layoutFormatter);
                continue;
            }
            catch (Exception exception) {
                String string4 = (String)map.get(string3);
                if (string4 == null) {
                    throw new Exception(Globals.lang("Formatter not found") + ": " + string3);
                }
                NameFormat nameFormat = new NameFormat();
                nameFormat.setParameter(string4);
                arrayList2.add(nameFormat);
            }
        }
        return arrayList2.toArray(new LayoutFormatter[0]);
    }

    private String getText(String string, BibtexDatabase bibtexDatabase) {
        String string2 = string;
        if (string2 != null && bibtexDatabase != null) {
            string2 = bibtexDatabase.resolveForStrings(string2);
        }
        return string2;
    }

    private String getField(BibtexEntry bibtexEntry, String string, BibtexDatabase bibtexDatabase) {
        if (string.equals("bibtextype")) {
            return bibtexEntry.getType().getName();
        }
        String string2 = (String)bibtexEntry.getField(string);
        if (string2 != null && bibtexDatabase != null) {
            string2 = bibtexDatabase.resolveForStrings(string2);
        }
        return string2;
    }
}

