/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.UnsupportedCharsetException;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.VerifyingWriter;

public class SaveSession {
    private static final String TEMP_PREFIX = "jabref";
    private static final String TEMP_SUFFIX = "save.bib";
    File file;
    File tmp;
    File backupFile;
    String encoding;
    boolean backup;
    VerifyingWriter writer;

    public SaveSession(File file, String string, boolean bl) throws IOException, UnsupportedCharsetException {
        this.file = file;
        this.tmp = File.createTempFile(TEMP_PREFIX, TEMP_SUFFIX);
        this.backup = bl;
        this.encoding = string;
        this.writer = new VerifyingWriter((OutputStream)new FileOutputStream(this.tmp), string);
    }

    public VerifyingWriter getWriter() {
        return this.writer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void commit() throws SaveException {
        if (this.file == null) {
            return;
        }
        if (this.file.exists() && this.backup) {
            String string = this.file.getName();
            String string2 = this.file.getParent();
            File file = new File(string2, string + GUIGlobals.backupExt);
            try {
                Util.copyFile(this.file, file, true);
            }
            catch (IOException iOException) {
                throw new SaveException(Globals.lang("Save failed during backup creation") + ": " + iOException.getMessage());
            }
        }
        try {
            Util.copyFile(this.tmp, this.file, true);
        }
        catch (IOException iOException) {
            throw new SaveException(Globals.lang("Save failed while committing changes") + ": " + iOException.getMessage());
        }
        this.tmp.delete();
    }

    public void cancel() throws IOException {
        this.tmp.delete();
    }

    public File getTemporaryFile() {
        return this.tmp;
    }
}

