/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;

class CustomExportDialog
extends JDialog {
    JTextField name = new JTextField(60);
    JTextField layoutFile = new JTextField(60);
    JTextField extension = new JTextField(60);
    JLabel nl = new JLabel(Globals.lang("Export name") + ":");
    JLabel nr = new JLabel(Globals.lang("Main layout file") + ":");
    JLabel nf = new JLabel(Globals.lang("File extension") + ":");
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JButton browse = new JButton(Globals.lang("Browse"));
    JPanel main = new JPanel();
    JPanel buttons = new JPanel();
    private boolean ok_pressed = false;
    private Vector groups;
    private int index;
    private JabRefFrame parent;
    private String oldName;
    private String oldRegexp;
    private String oldField;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();

    public CustomExportDialog(JabRefFrame jabRefFrame, String string, String string2, String string3) {
        this(jabRefFrame);
        this.name.setText(string);
        this.layoutFile.setText(string2);
        this.extension.setText(string3);
    }

    public CustomExportDialog(JabRefFrame jabRefFrame) {
        super(jabRefFrame, Globals.lang("Edit custom export"), true);
        this.parent = jabRefFrame;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomExportDialog.this.layoutFile.getText().equals("") || CustomExportDialog.this.name.getText().equals("") || CustomExportDialog.this.extension.getText().equals("") || !CustomExportDialog.this.layoutFile.getText().endsWith(".layout")) {
                    return;
                }
                CustomExportDialog.this.ok_pressed = true;
                CustomExportDialog.this.dispose();
            }
        };
        this.ok.addActionListener(actionListener);
        this.name.addActionListener(actionListener);
        this.layoutFile.addActionListener(actionListener);
        this.extension.addActionListener(actionListener);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomExportDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(abstractAction);
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(Globals.prefs.get("exportWorkingDirectory"));
                String string = Globals.getNewFile(CustomExportDialog.this.parent, file, ".layout", 0, false);
                if (string == null) {
                    return;
                }
                File file2 = new File(string);
                Globals.prefs.put("exportWorkingDirectory", file2.getParent());
                CustomExportDialog.this.layoutFile.setText(file2.getPath());
            }
        });
        ActionMap actionMap = this.main.getActionMap();
        InputMap inputMap = this.main.getInputMap(2);
        inputMap.put(this.parent.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        this.main.setLayout(this.gbl);
        this.main.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Export properties")));
        this.con.weightx = 0.0;
        this.con.gridwidth = 1;
        this.con.insets = new Insets(3, 5, 3, 5);
        this.con.anchor = 13;
        this.con.fill = 0;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.nl, this.con);
        this.main.add(this.nl);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.nr, this.con);
        this.main.add(this.nr);
        this.con.gridy = 2;
        this.gbl.setConstraints(this.nf, this.con);
        this.main.add(this.nf);
        this.con.gridwidth = 2;
        this.con.weightx = 1.0;
        this.con.anchor = 17;
        this.con.fill = 2;
        this.con.gridy = 0;
        this.con.gridx = 1;
        this.gbl.setConstraints(this.name, this.con);
        this.main.add(this.name);
        this.con.gridy = 1;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.layoutFile, this.con);
        this.main.add(this.layoutFile);
        this.con.gridx = 2;
        this.con.weightx = 0.0;
        this.gbl.setConstraints(this.browse, this.con);
        this.main.add(this.browse);
        this.con.weightx = 1.0;
        this.con.gridwidth = 2;
        this.con.gridx = 1;
        this.con.gridy = 2;
        this.gbl.setConstraints(this.extension, this.con);
        this.main.add(this.extension);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(this.ok);
        buttonBarBuilder.addGridded(this.cancel);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)this.buttons, "South");
        this.setSize(600, 170);
        Util.placeDialog(this, this.parent);
    }

    public boolean okPressed() {
        return this.ok_pressed;
    }

    public int index() {
        return this.index;
    }

    public String oldField() {
        return this.oldField;
    }

    public String oldName() {
        return this.oldName;
    }

    public String oldRegexp() {
        return this.oldRegexp;
    }

    public String layoutFile() {
        return this.layoutFile.getText();
    }

    public String name() {
        return this.name.getText();
    }

    public String extension() {
        String string = this.extension.getText();
        if (string.startsWith(".")) {
            return string;
        }
        if (string.startsWith("*.")) {
            return string.substring(1);
        }
        return "." + string;
    }
}

