/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveString;

public class StringRemoveChange
extends Change {
    BibtexString string;
    BibtexString inMem;
    InfoPane tp = new InfoPane();
    JScrollPane sp = new JScrollPane(this.tp);

    public StringRemoveChange(BibtexString bibtexString, BibtexString bibtexString2) {
        this.name = Globals.lang("Removed string") + ": '" + bibtexString.getName() + "'";
        this.string = bibtexString;
        this.inMem = bibtexString2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML><H2>");
        stringBuffer.append(Globals.lang("Removed string"));
        stringBuffer.append("</H2><H3>");
        stringBuffer.append(Globals.lang("Label")).append(":</H3>");
        stringBuffer.append(bibtexString.getName());
        stringBuffer.append("<H3>");
        stringBuffer.append(Globals.lang("Content")).append(":</H3>");
        stringBuffer.append(bibtexString.getContent());
        stringBuffer.append("</HTML>");
        this.tp.setText(stringBuffer.toString());
    }

    public void makeChange(BasePanel basePanel, NamedCompound namedCompound) {
        try {
            basePanel.database().removeString(this.inMem.getId());
            namedCompound.addEdit(new UndoableRemoveString(basePanel, basePanel.database(), this.string));
        }
        catch (Exception exception) {
            Globals.logger("Error: could not add string '" + this.string.getName() + "': " + exception.getMessage());
        }
    }

    JComponent description() {
        return this.sp;
    }
}

