/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.collab.FileUpdateListener;

public class FileUpdateMonitor
extends Thread {
    final int WAIT = 4000;
    static int tmpNum = 0;
    int no = 0;
    HashMap entries = new HashMap();
    boolean running;

    public FileUpdateMonitor() {
        this.setPriority(1);
    }

    public void run() {
        this.running = true;
        while (this.running) {
            Iterator iterator = this.entries.keySet().iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)this.entries.get(iterator.next());
                try {
                    if (!entry.hasBeenUpdated()) continue;
                    entry.notifyListener();
                }
                catch (IOException iOException) {
                    entry.notifyFileRemoved();
                }
            }
            try {
                FileUpdateMonitor.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stopMonitoring() {
        this.running = false;
    }

    public String addUpdateListener(FileUpdateListener fileUpdateListener, File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File not found");
        }
        ++this.no;
        String string = "" + this.no;
        this.entries.put(string, new Entry(fileUpdateListener, file));
        return string;
    }

    public boolean hasBeenModified(String string) throws IllegalArgumentException {
        Object v = this.entries.get(string);
        if (v == null) {
            return false;
        }
        try {
            return ((Entry)v).hasBeenUpdated();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void removeUpdateListener(String string) {
        this.entries.remove(string);
    }

    public void updateTimeStamp(String string) throws IllegalArgumentException {
        Object v = this.entries.get(string);
        if (v == null) {
            throw new IllegalArgumentException("Entry not found");
        }
        Entry entry = (Entry)v;
        entry.updateTimeStamp();
    }

    public void changeFile(String string, File file) throws IOException, IllegalArgumentException {
        if (!file.exists()) {
            throw new IOException("File not found");
        }
        Object v = this.entries.get(string);
        if (v == null) {
            throw new IllegalArgumentException("Entry not found");
        }
        ((Entry)v).file = file;
    }

    public File getTempFile(String string) throws IllegalArgumentException {
        Object v = this.entries.get(string);
        if (v == null) {
            throw new IllegalArgumentException("Entry not found");
        }
        return ((Entry)v).tmpFile;
    }

    static synchronized File getTempFile() {
        File file = null;
        try {
            file = File.createTempFile("jabref", null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file;
    }

    class Entry {
        FileUpdateListener listener;
        File file;
        File tmpFile;
        long timeStamp;

        public Entry(FileUpdateListener fileUpdateListener, File file) {
            this.listener = fileUpdateListener;
            this.file = file;
            this.timeStamp = this.file.lastModified();
            this.tmpFile = FileUpdateMonitor.getTempFile();
            this.copy();
        }

        public boolean hasBeenUpdated() throws IOException {
            long l = this.file.lastModified();
            if (l == 0L) {
                throw new IOException("File deleted");
            }
            return this.timeStamp != l;
        }

        public void updateTimeStamp() {
            this.timeStamp = this.file.lastModified();
            if (this.timeStamp == 0L) {
                this.notifyFileRemoved();
            }
            this.copy();
        }

        public boolean copy() {
            boolean bl = false;
            try {
                bl = Util.copyFile(this.file, this.tmpFile, true);
            }
            catch (IOException iOException) {
                Globals.logger("Cannot copy to temporary file '" + this.tmpFile.getPath() + "'");
            }
            return bl;
        }

        public void notifyListener() {
            this.timeStamp = this.file.lastModified();
            this.listener.fileUpdated();
        }

        public void notifyFileRemoved() {
            this.listener.fileRemoved();
        }

        public void finalize() {
            try {
                this.tmpFile.delete();
            }
            catch (Throwable throwable) {
                Globals.logger("Cannot delete temporary file '" + this.tmpFile.getPath() + "'");
            }
        }
    }
}

