/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

public class EntryChange
extends Change {
    BibtexEntry memEntry;
    BibtexEntry tmpEntry;
    BibtexEntry diskEntry;
    boolean isModifiedLocally;
    boolean modificationsAgree;

    public EntryChange(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2, BibtexEntry bibtexEntry3) {
        int n;
        String string = bibtexEntry2.getCiteKey();
        this.name = string == null ? "Modified entry" : "Modified entry: '" + string + "'";
        this.memEntry = bibtexEntry;
        this.tmpEntry = bibtexEntry2;
        this.diskEntry = bibtexEntry3;
        this.isModifiedLocally = !(Util.compareEntriesStrictly(bibtexEntry, bibtexEntry2) > 1.0);
        this.modificationsAgree = Util.compareEntriesStrictly(bibtexEntry, bibtexEntry3) > 1.0;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Object[] objectArray = bibtexEntry.getAllFields();
        for (n = 0; n < objectArray.length; ++n) {
            treeSet.add(objectArray[n]);
        }
        objectArray = bibtexEntry2.getAllFields();
        for (n = 0; n < objectArray.length; ++n) {
            treeSet.add(objectArray[n]);
        }
        objectArray = bibtexEntry3.getAllFields();
        for (n = 0; n < objectArray.length; ++n) {
            treeSet.add(objectArray[n]);
        }
        n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)bibtexEntry.getField(string2);
            String string4 = (String)bibtexEntry2.getField(string2);
            String string5 = (String)bibtexEntry3.getField(string2);
            if (string4 != null && string5 != null) {
                if (string4.equals(string5)) continue;
                this.add(new FieldChange(string2, bibtexEntry, string3, string4, string5));
                continue;
            }
            if (string4 == null && string5 != null && !string5.equals("")) {
                this.add(new FieldChange(string2, bibtexEntry, string3, string4, string5));
                continue;
            }
            if (string5 != null || string4 == null || string4.equals("") || string3 == null || string3.equals("")) continue;
            this.add(new FieldChange(string2, bibtexEntry, string3, string4, string5));
        }
    }

    public void makeChange(BasePanel basePanel, NamedCompound namedCompound) {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            Change change = (Change)enumeration.nextElement();
            if (!change.isAcceptable() || !change.isAccepted()) continue;
            change.makeChange(basePanel, namedCompound);
        }
    }

    JComponent description() {
        return new JLabel(this.name);
    }

    class FieldChange
    extends Change {
        BibtexEntry entry;
        String field;
        String inMem;
        String onTmp;
        String onDisk;
        InfoPane tp = new InfoPane();
        JScrollPane sp = new JScrollPane(this.tp);

        public FieldChange(String string, BibtexEntry bibtexEntry, String string2, String string3, String string4) {
            this.entry = bibtexEntry;
            this.name = string;
            this.field = string;
            this.inMem = string2;
            this.onTmp = string3;
            this.onDisk = string4;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<FONT SIZE=10>");
            stringBuffer.append("<H2>").append(Globals.lang("Modification of field")).append(" <I>").append(string).append("</I></H2>");
            if (string4 != null && !string4.equals("")) {
                stringBuffer.append("<H3>").append(Globals.lang("Value set externally")).append(":</H3> ").append(string4);
            } else {
                stringBuffer.append("<H3>").append(Globals.lang("Value cleared externally")).append("</H3>");
            }
            if (string2 != null && !string2.equals("")) {
                stringBuffer.append("<H3>").append(Globals.lang("Current value")).append(":</H3> ").append(string2);
            }
            this.tp.setContentType("text/html");
            this.tp.setText(stringBuffer.toString());
        }

        public void makeChange(BasePanel basePanel, NamedCompound namedCompound) {
            this.entry.setField(this.field, this.onDisk);
            namedCompound.addEdit(new UndoableFieldChange(this.entry, this.field, this.inMem, this.onDisk));
        }

        JComponent description() {
            return this.sp;
        }
    }
}

