/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;

public class EntryAddChange
extends Change {
    BibtexEntry diskEntry;
    PreviewPanel pp;
    JScrollPane sp;

    public EntryAddChange(BibtexEntry bibtexEntry) {
        super("Added entry");
        this.diskEntry = bibtexEntry;
        this.pp = new PreviewPanel(bibtexEntry, new MetaData(), Globals.prefs.get("preview0"));
        this.sp = new JScrollPane(this.pp);
    }

    public void makeChange(BasePanel basePanel, NamedCompound namedCompound) {
        try {
            this.diskEntry.setId(Util.createNeutralId());
            basePanel.database().insertEntry(this.diskEntry);
            namedCompound.addEdit(new UndoableInsertEntry(basePanel.database(), this.diskEntry, basePanel));
        }
        catch (KeyCollisionException keyCollisionException) {
            // empty catch block
        }
    }

    JComponent description() {
        return this.sp;
    }
}

