/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexString;
import net.sf.jabref.EntryComparator;
import net.sf.jabref.EntrySorter;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.ChangeDisplayDialog;
import net.sf.jabref.collab.EntryAddChange;
import net.sf.jabref.collab.EntryChange;
import net.sf.jabref.collab.EntryDeleteChange;
import net.sf.jabref.collab.GroupChange;
import net.sf.jabref.collab.PreambleChange;
import net.sf.jabref.collab.StringAddChange;
import net.sf.jabref.collab.StringChange;
import net.sf.jabref.collab.StringNameChange;
import net.sf.jabref.collab.StringRemoveChange;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;

public class ChangeScanner
extends Thread {
    final double MATCH_THRESHOLD = 0.4;
    final String[] sortBy = new String[]{"year", "author", "title"};
    File f;
    BibtexDatabase inMem;
    MetaData mdInMem;
    BasePanel panel;
    JabRefFrame frame;
    DefaultMutableTreeNode changes = new DefaultMutableTreeNode(Globals.lang("External changes"));

    public ChangeScanner(JabRefFrame jabRefFrame, BasePanel basePanel) {
        this.panel = basePanel;
        this.frame = jabRefFrame;
        this.inMem = basePanel.database();
        this.mdInMem = basePanel.metaData();
        this.setPriority(1);
    }

    public void changeScan(File file) {
        this.f = file;
        this.start();
    }

    public void run() {
        try {
            File file = Globals.fileUpdateMonitor.getTempFile(this.panel.fileMonitorHandle());
            ParserResult parserResult = OpenDatabaseAction.loadDatabase(file, Globals.prefs.get("defaultEncoding"));
            BibtexDatabase bibtexDatabase = parserResult.getDatabase();
            MetaData metaData = new MetaData(parserResult.getMetaData(), bibtexDatabase);
            parserResult = OpenDatabaseAction.loadDatabase(this.f, Globals.prefs.get("defaultEncoding"));
            BibtexDatabase bibtexDatabase2 = parserResult.getDatabase();
            MetaData metaData2 = new MetaData(parserResult.getMetaData(), bibtexDatabase2);
            EntryComparator entryComparator = new EntryComparator(false, true, this.sortBy[2]);
            entryComparator = new EntryComparator(false, true, this.sortBy[1], entryComparator);
            entryComparator = new EntryComparator(false, true, this.sortBy[0], entryComparator);
            EntrySorter entrySorter = bibtexDatabase.getSorter(entryComparator);
            entryComparator = new EntryComparator(false, true, this.sortBy[2]);
            entryComparator = new EntryComparator(false, true, this.sortBy[1], entryComparator);
            entryComparator = new EntryComparator(false, true, this.sortBy[0], entryComparator);
            EntrySorter entrySorter2 = bibtexDatabase2.getSorter(entryComparator);
            entryComparator = new EntryComparator(false, true, this.sortBy[2]);
            entryComparator = new EntryComparator(false, true, this.sortBy[1], entryComparator);
            entryComparator = new EntryComparator(false, true, this.sortBy[0], entryComparator);
            EntrySorter entrySorter3 = this.inMem.getSorter(entryComparator);
            this.scanPreamble(this.inMem, bibtexDatabase, bibtexDatabase2);
            this.scanStrings(this.inMem, bibtexDatabase, bibtexDatabase2);
            this.scanEntries(entrySorter3, entrySorter, entrySorter2);
            this.scanGroups(this.mdInMem, metaData, metaData2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean changesFound() {
        return this.changes.getChildCount() > 0;
    }

    public void displayResult() {
        if (this.changes.getChildCount() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ChangeDisplayDialog changeDisplayDialog = new ChangeDisplayDialog(ChangeScanner.this.frame, ChangeScanner.this.panel, ChangeScanner.this.changes);
                    Util.placeDialog(changeDisplayDialog, ChangeScanner.this.frame);
                    changeDisplayDialog.setVisible(true);
                }
            });
        } else {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("No actual changes found."), Globals.lang("External changes"), 1);
        }
    }

    private void scanEntries(EntrySorter entrySorter, EntrySorter entrySorter2, EntrySorter entrySorter3) {
        int n;
        int n2 = 0;
        int n3 = 0;
        HashSet<String> hashSet = new HashSet<String>(entrySorter3.getEntryCount());
        HashSet<Integer> hashSet2 = new HashSet<Integer>(entrySorter2.getEntryCount());
        block0: for (n2 = 0; n2 < entrySorter2.getEntryCount(); ++n2) {
            double d = -1.0;
            if (!hashSet.contains("" + n3) && n3 < entrySorter3.getEntryCount()) {
                d = Util.compareEntriesStrictly(entrySorter2.getEntryAt(n2), entrySorter3.getEntryAt(n3));
            }
            if (d > 1.0) {
                hashSet.add("" + n3);
                ++n3;
                continue;
            }
            if (n3 < entrySorter3.getEntryCount() - 1) {
                for (n = n3 + 1; n < entrySorter3.getEntryCount(); ++n) {
                    d = !hashSet.contains("" + n) ? Util.compareEntriesStrictly(entrySorter2.getEntryAt(n2), entrySorter3.getEntryAt(n)) : -1.0;
                    if (!(d > 1.0)) continue;
                    hashSet.add("" + n);
                    continue block0;
                }
            }
            hashSet2.add(new Integer(n2));
        }
        if (hashSet2.size() > 0) {
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                Change change;
                Integer n4 = (Integer)iterator.next();
                n2 = n4;
                n = -1;
                double d = 0.0;
                double d2 = -1.0;
                if (n3 < entrySorter3.getEntryCount() - 1) {
                    for (int i = n3; i < entrySorter3.getEntryCount(); ++i) {
                        d2 = !hashSet.contains("" + i) ? Util.compareEntriesStrictly(entrySorter2.getEntryAt(n2), entrySorter3.getEntryAt(i)) : -1.0;
                        if (!(d2 > d)) continue;
                        d = d2;
                        n = i;
                    }
                }
                if (d > 0.4) {
                    hashSet.add("" + n);
                    iterator.remove();
                    change = new EntryChange(this.bestFit(entrySorter2, entrySorter, n2), entrySorter2.getEntryAt(n2), entrySorter3.getEntryAt(n));
                    this.changes.add(change);
                    continue;
                }
                change = new EntryDeleteChange(this.bestFit(entrySorter2, entrySorter, n2), entrySorter2.getEntryAt(n2));
                this.changes.add(change);
            }
        }
        if (hashSet.size() < entrySorter3.getEntryCount()) {
            for (int i = 0; i < entrySorter3.getEntryCount(); ++i) {
                if (hashSet.contains("" + i)) continue;
                boolean bl = false;
                for (int j = 0; j < entrySorter.getEntryCount(); ++j) {
                    if (!(Util.compareEntriesStrictly(entrySorter.getEntryAt(j), entrySorter3.getEntryAt(i)) >= 1.0)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                EntryAddChange entryAddChange = new EntryAddChange(entrySorter3.getEntryAt(i));
                this.changes.add(entryAddChange);
            }
        }
    }

    private BibtexEntry bestFit(EntrySorter entrySorter, EntrySorter entrySorter2, int n) {
        double d = -1.0;
        int n2 = 0;
        for (int i = 0; i < entrySorter2.getEntryCount(); ++i) {
            double d2 = Util.compareEntriesStrictly(entrySorter.getEntryAt(n), entrySorter2.getEntryAt(i));
            if (d2 > d) {
                d = d2;
                n2 = i;
            }
            if (d > 1.0) break;
        }
        return entrySorter2.getEntryAt(n2);
    }

    private void scanPreamble(BibtexDatabase bibtexDatabase, BibtexDatabase bibtexDatabase2, BibtexDatabase bibtexDatabase3) {
        String string = bibtexDatabase.getPreamble();
        String string2 = bibtexDatabase2.getPreamble();
        String string3 = bibtexDatabase3.getPreamble();
        if (string2 != null) {
            if (string3 == null || !string2.equals(string3)) {
                this.changes.add(new PreambleChange(string2, string, string3));
            }
        } else if (string3 != null && !string3.equals("")) {
            this.changes.add(new PreambleChange(string2, string, string3));
        }
    }

    private void scanStrings(BibtexDatabase bibtexDatabase, BibtexDatabase bibtexDatabase2, BibtexDatabase bibtexDatabase3) {
        BibtexString bibtexString;
        BibtexString bibtexString2;
        Object object;
        Object object2;
        BibtexString bibtexString3;
        Object e;
        int n = bibtexDatabase2.getStringCount();
        int n2 = bibtexDatabase3.getStringCount();
        if (n == 0 && n2 == 0) {
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet hashSet2 = new HashSet();
        HashSet<String> hashSet3 = new HashSet<String>(bibtexDatabase2.getStringCount());
        Iterator iterator = bibtexDatabase2.getStringKeySet().iterator();
        block0: while (iterator.hasNext()) {
            e = iterator.next();
            bibtexString3 = bibtexDatabase2.getString(e);
            object2 = bibtexDatabase3.getStringKeySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (hashSet.contains(object) || !(bibtexString2 = bibtexDatabase3.getString(object)).getName().equals(bibtexString3.getName())) continue;
                if (bibtexString3.getContent() != null && !bibtexString3.getContent().equals(bibtexString2.getContent())) {
                    bibtexString = this.findString(bibtexDatabase, bibtexString3.getName(), hashSet2);
                    if (bibtexString != null) {
                        this.changes.add(new StringChange(bibtexString, bibtexString3.getName(), bibtexString.getContent(), bibtexString3.getContent(), bibtexString2.getContent()));
                    } else {
                        this.changes.add(new StringChange(null, bibtexString3.getName(), null, bibtexString3.getContent(), bibtexString2.getContent()));
                    }
                }
                hashSet.add(object);
                continue block0;
            }
            hashSet3.add(bibtexString3.getId());
        }
        if (hashSet3.size() > 0) {
            iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                bibtexString3 = bibtexDatabase2.getString(e);
                object2 = bibtexString3.getContent();
                object = bibtexDatabase3.getStringKeySet().iterator();
                while (object.hasNext()) {
                    bibtexString2 = object.next();
                    if (hashSet.contains(bibtexString2) || !(bibtexString = bibtexDatabase3.getString(bibtexString2)).getContent().equals(bibtexString3.getContent())) continue;
                    BibtexString bibtexString4 = null;
                    Iterator iterator2 = bibtexDatabase.getStringKeySet().iterator();
                    while (iterator2.hasNext()) {
                        Object e2 = iterator2.next();
                        BibtexString bibtexString5 = bibtexDatabase.getString(e2);
                        if (!bibtexString5.getContent().equals(bibtexString.getContent()) || hashSet2.contains(e2)) continue;
                        hashSet2.add(e2);
                        bibtexString4 = bibtexString5;
                        break;
                    }
                    this.changes.add(new StringNameChange(bibtexString4, bibtexString4.getName(), bibtexString3.getName(), bibtexString.getName(), bibtexString3.getContent()));
                    iterator.remove();
                    hashSet.add(bibtexString2);
                }
            }
        }
        if (hashSet3.size() > 0) {
            iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                bibtexString3 = bibtexDatabase2.getString(e);
                object2 = this.findString(bibtexDatabase, bibtexString3.getName(), hashSet2);
                if (object2 == null) continue;
                this.changes.add(new StringRemoveChange(bibtexString3, (BibtexString)object2));
            }
        }
        iterator = bibtexDatabase3.getStringKeySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (hashSet.contains(e)) continue;
            bibtexString3 = bibtexDatabase3.getString(e);
            hashSet.add(e);
            this.changes.add(new StringAddChange(bibtexString3));
        }
    }

    private BibtexString findString(BibtexDatabase bibtexDatabase, String string, HashSet hashSet) {
        if (!bibtexDatabase.hasStringLabel(string)) {
            return null;
        }
        Iterator iterator = bibtexDatabase.getStringKeySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            BibtexString bibtexString = bibtexDatabase.getString(e);
            if (!bibtexString.getName().equals(string) || hashSet.contains(e)) continue;
            hashSet.add(e);
            return bibtexString;
        }
        return null;
    }

    public void scanGroups(MetaData metaData, MetaData metaData2, MetaData metaData3) {
        GroupTreeNode groupTreeNode = metaData.getGroups();
        GroupTreeNode groupTreeNode2 = metaData2.getGroups();
        GroupTreeNode groupTreeNode3 = metaData3.getGroups();
        if (groupTreeNode2 == null && groupTreeNode3 == null) {
            return;
        }
        if (groupTreeNode2 != null && groupTreeNode3 == null || groupTreeNode2 == null && groupTreeNode3 != null) {
            this.changes.add(new GroupChange(groupTreeNode3));
            return;
        }
        if (groupTreeNode2.equals(groupTreeNode3)) {
            return;
        }
        this.changes.add(new GroupChange(groupTreeNode3));
    }
}

