/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;

public class ChangeDisplayDialog
extends JDialog
implements TreeSelectionListener {
    DefaultMutableTreeNode root;
    JTree tree;
    JPanel infoPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JPanel infoBorder = new JPanel();
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JCheckBox cb = new JCheckBox(Globals.lang("Accept change"));
    JLabel rootInfo = new JLabel(Globals.lang("Select the tree nodes to view and accept or reject changes") + ".");
    Change selected = null;
    JComponent infoShown = null;

    public ChangeDisplayDialog(JFrame jFrame, final BasePanel basePanel, final DefaultMutableTreeNode defaultMutableTreeNode) {
        super(jFrame, Globals.lang("External changes"), true);
        this.root = defaultMutableTreeNode;
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.addTreeSelectionListener(this);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setLeftComponent(new JScrollPane(this.tree));
        jSplitPane.setRightComponent(this.infoBorder);
        this.cb.setMargin(new Insets(2, 2, 2, 2));
        this.cb.setEnabled(false);
        this.infoPanel.setLayout(new BorderLayout());
        this.infoBorder.setLayout(new BorderLayout());
        this.infoBorder.setBorder(BorderFactory.createEtchedBorder());
        this.infoBorder.add((Component)this.infoPanel, "Center");
        this.setInfo(this.rootInfo);
        this.infoPanel.add((Component)this.cb, "South");
        this.buttonPanel.add(this.ok);
        this.buttonPanel.add(this.cancel);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.cb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ChangeDisplayDialog.this.selected != null) {
                    ChangeDisplayDialog.this.selected.setAccepted(ChangeDisplayDialog.this.cb.isSelected());
                }
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeDisplayDialog.this.dispose();
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NamedCompound namedCompound = new NamedCompound(Globals.lang("Merged external changes"));
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    Change change = (Change)enumeration.nextElement();
                    if (!change.isAcceptable() || !change.isAccepted()) continue;
                    change.makeChange(basePanel, namedCompound);
                }
                namedCompound.end();
                basePanel.undoManager.addEdit(namedCompound);
                basePanel.markBaseChanged();
                basePanel.setUpdatedExternally(false);
                ChangeDisplayDialog.this.dispose();
            }
        });
        this.pack();
    }

    private void setInfo(JComponent jComponent) {
        if (this.infoShown != null) {
            this.infoPanel.remove(this.infoShown);
        }
        this.infoShown = jComponent;
        this.infoPanel.add((Component)this.infoShown, "Center");
        this.infoPanel.revalidate();
        this.infoPanel.repaint();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object instanceof Change) {
            this.selected = (Change)object;
            this.setInfo(this.selected.description());
            this.cb.setSelected(this.selected.isAccepted());
            this.cb.setEnabled(this.selected.isAcceptable());
        } else {
            this.setInfo(this.rootInfo);
            this.selected = null;
            this.cb.setEnabled(false);
        }
    }
}

